/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.util.Arrays;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.Flattener;

class TemporaryCoefficientsContainer {
    private final Flattener flattener;
    private final double[] c;
    private final double[] s;
    private final double initialValue;

    TemporaryCoefficientsContainer(int degree, int order, double initialValue) {
        this.flattener = new Flattener(degree, order);
        this.c = new double[this.flattener.arraySize()];
        this.s = new double[this.flattener.arraySize()];
        this.initialValue = initialValue;
        Arrays.fill(this.c, initialValue);
        Arrays.fill(this.s, initialValue);
    }

    TemporaryCoefficientsContainer resize(int degree, int order) {
        TemporaryCoefficientsContainer resized = new TemporaryCoefficientsContainer(degree, order, this.initialValue);
        for (int n = 0; n <= degree; ++n) {
            for (int m = 0; m <= FastMath.min((int)n, (int)order); ++m) {
                if (!this.flattener.withinRange(n, m)) continue;
                int rIndex = resized.flattener.index(n, m);
                int index = this.flattener.index(n, m);
                resized.c[rIndex] = this.c[index];
                resized.s[rIndex] = this.s[index];
            }
        }
        return resized;
    }

    Flattener getFlattener() {
        return this.flattener;
    }

    public double[] getC() {
        return this.c;
    }

    public double[] getS() {
        return this.s;
    }
}

