/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;

class SecularTrendSphericalHarmonics
implements RawSphericalHarmonicsProvider {
    private final RawSphericalHarmonicsProvider provider;
    private final AbsoluteDate referenceDate;
    private final Flattener flattener;
    private final double[] cTrend;
    private final double[] sTrend;

    SecularTrendSphericalHarmonics(RawSphericalHarmonicsProvider provider, AbsoluteDate referenceDate, Flattener flattener, double[] cTrend, double[] sTrend) {
        this.provider = provider;
        this.referenceDate = referenceDate;
        this.flattener = flattener;
        this.cTrend = (double[])cTrend.clone();
        this.sTrend = (double[])sTrend.clone();
    }

    @Override
    public int getMaxDegree() {
        return FastMath.max((int)this.flattener.getDegree(), (int)this.provider.getMaxDegree());
    }

    @Override
    public int getMaxOrder() {
        return FastMath.max((int)this.flattener.getOrder(), (int)this.provider.getMaxOrder());
    }

    @Override
    public double getMu() {
        return this.provider.getMu();
    }

    @Override
    public double getAe() {
        return this.provider.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    @Override
    public RawSphericalHarmonicsProvider.RawSphericalHarmonics onDate(final AbsoluteDate date) {
        final RawSphericalHarmonicsProvider.RawSphericalHarmonics harmonics = this.provider.onDate(date);
        final double dateOffset = date.durationFrom(this.referenceDate);
        return new RawSphericalHarmonicsProvider.RawSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getRawCnm(int n, int m) {
                double cnm = harmonics.getRawCnm(n, m);
                if (SecularTrendSphericalHarmonics.this.flattener.withinRange(n, m)) {
                    cnm += dateOffset * SecularTrendSphericalHarmonics.this.cTrend[SecularTrendSphericalHarmonics.this.flattener.index(n, m)];
                }
                return cnm;
            }

            @Override
            public double getRawSnm(int n, int m) {
                double snm = harmonics.getRawSnm(n, m);
                if (SecularTrendSphericalHarmonics.this.flattener.withinRange(n, m)) {
                    snm += dateOffset * SecularTrendSphericalHarmonics.this.sTrend[SecularTrendSphericalHarmonics.this.flattener.index(n, m)];
                }
                return snm;
            }
        };
    }
}

