/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.SecularTrendSphericalHarmonics;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;

public class SHMFormatReader
extends PotentialCoefficientsReader {
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final String GRCOEF = "GRCOEF";
    private static final String GRCOF2 = "GRCOF2";
    private static final String GRDOTA = "GRDOTA";
    private static final int EARTH = 1;
    private static final int LIMITS = 2;
    private static final int COEFFS = 4;
    private AbsoluteDate referenceDate;
    private Flattener dotFlattener;
    private double[] cDot;
    private double[] sDot;

    @DefaultDataContext
    public SHMFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this(supportedNames, missingCoefficientsAllowed, DataContext.getDefault().getTimeScales().getTT());
    }

    public SHMFormatReader(String supportedNames, boolean missingCoefficientsAllowed, TimeScale timeScale) {
        super(supportedNames, missingCoefficientsAllowed, timeScale);
        this.reset();
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.reset();
        boolean normalized = false;
        TideSystem tideSystem = TideSystem.UNKNOWN;
        Flattener flattener = null;
        int dotDegree = -1;
        int dotOrder = -1;
        int flags = 0;
        double[] c0 = null;
        double[] s0 = null;
        double[] c1 = null;
        double[] s1 = null;
        String line = null;
        int lineNumber = 1;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            line = r.readLine();
            if (line != null && "FIRST ".equals(line.substring(0, 6)) && "SHM    ".equals(line.substring(49, 56))) {
                line = r.readLine();
                while (line != null) {
                    ++lineNumber;
                    if (line.length() >= 6) {
                        String[] tab = SEPARATOR.split(line);
                        if ("EARTH".equals(tab[0])) {
                            this.setMu(SHMFormatReader.parseDouble(tab[1]));
                            this.setAe(SHMFormatReader.parseDouble(tab[2]));
                            flags |= 1;
                        }
                        if ("SHM".equals(tab[0])) {
                            int degree = FastMath.min((int)this.getMaxParseDegree(), (int)Integer.parseInt(tab[1]));
                            int order = FastMath.min((int)this.getMaxParseOrder(), (int)degree);
                            flattener = new Flattener(degree, order);
                            c0 = SHMFormatReader.buildFlatArray(flattener, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                            s0 = SHMFormatReader.buildFlatArray(flattener, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                            c1 = SHMFormatReader.buildFlatArray(flattener, 0.0);
                            s1 = SHMFormatReader.buildFlatArray(flattener, 0.0);
                            String lowerCaseLine = line.toLowerCase(Locale.US);
                            normalized = lowerCaseLine.contains("fully normalized");
                            tideSystem = lowerCaseLine.contains("exclusive permanent tide") ? TideSystem.TIDE_FREE : TideSystem.UNKNOWN;
                            flags |= 2;
                        }
                        if (GRCOEF.equals(line.substring(0, 6)) || GRCOF2.equals(tab[0]) || GRDOTA.equals(tab[0])) {
                            int j;
                            int i = Integer.parseInt(tab[1]);
                            if (flattener.withinRange(i, j = Integer.parseInt(tab[2]))) {
                                if (GRDOTA.equals(tab[0])) {
                                    this.parseCoefficient(tab[3], flattener, c1, i, j, "Cdot", name);
                                    this.parseCoefficient(tab[4], flattener, s1, i, j, "Sdot", name);
                                    dotDegree = FastMath.max((int)dotDegree, (int)i);
                                    dotOrder = FastMath.max((int)dotOrder, (int)j);
                                    DateComponents localRef = new DateComponents(Integer.parseInt(tab[7].substring(0, 4)), Integer.parseInt(tab[7].substring(4, 6)), Integer.parseInt(tab[7].substring(6, 8)));
                                    if (this.referenceDate == null) {
                                        this.referenceDate = this.toDate(localRef);
                                    } else if (!this.referenceDate.equals(this.toDate(localRef))) {
                                        AbsoluteDate localDate = this.toDate(localRef);
                                        throw new OrekitException((Localizable)OrekitMessages.SEVERAL_REFERENCE_DATES_IN_GRAVITY_FIELD, this.referenceDate, localDate, name, localDate.durationFrom(this.referenceDate));
                                    }
                                } else {
                                    this.parseCoefficient(tab[3], flattener, c0, i, j, "C", name);
                                    this.parseCoefficient(tab[4], flattener, s0, i, j, "S", name);
                                }
                            }
                            flags |= 4;
                        }
                    }
                    line = r.readLine();
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        if (flags != 7) {
            String loaderName = this.getClass().getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
        if (this.missingCoefficientsAllowed() && Precision.equals((double)c0[flattener.index(0, 0)], (double)0.0, (int)0)) {
            c0[flattener.index((int)0, (int)0)] = 1.0;
        }
        if (dotDegree >= 0) {
            this.dotFlattener = new Flattener(dotDegree, dotOrder);
            this.cDot = new double[this.dotFlattener.arraySize()];
            this.sDot = new double[this.dotFlattener.arraySize()];
            for (int n = 0; n <= dotDegree; ++n) {
                for (int m = 0; m <= FastMath.min((int)n, (int)dotOrder); ++m) {
                    this.cDot[this.dotFlattener.index((int)n, (int)m)] = c1[flattener.index(n, m)];
                    this.sDot[this.dotFlattener.index((int)n, (int)m)] = s1[flattener.index(n, m)];
                }
            }
        }
        this.setRawCoefficients(normalized, flattener, c0, s0, name);
        this.setTideSystem(tideSystem);
        this.setReadComplete(true);
    }

    private void reset() {
        this.setReadComplete(false);
        this.referenceDate = null;
        this.dotFlattener = null;
        this.cDot = null;
        this.sDot = null;
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) {
        RawSphericalHarmonicsProvider provider = this.getBaseProvider(wantNormalized, degree, order);
        if (this.dotFlattener != null) {
            double scale = 3.168808781402895E-8;
            Flattener rescaledFlattener = new Flattener(FastMath.min((int)degree, (int)this.dotFlattener.getDegree()), FastMath.min((int)order, (int)this.dotFlattener.getOrder()));
            provider = new SecularTrendSphericalHarmonics(provider, this.referenceDate, rescaledFlattener, this.rescale(3.168808781402895E-8, wantNormalized, rescaledFlattener, this.dotFlattener, this.cDot), this.rescale(3.168808781402895E-8, wantNormalized, rescaledFlattener, this.dotFlattener, this.sDot));
        }
        return provider;
    }
}

