/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TemporaryCoefficientsContainer;
import org.orekit.forces.gravity.potential.TideSystem;

public class SHAFormatReader
extends PotentialCoefficientsReader {
    private static final String ZERO = "0.0";
    private static final String ONE = "1.0";
    private static final String SPACES = "\\s+";
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final Pattern REAL = Pattern.compile("[-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d");
    private static final Pattern HEADER_LINE = Pattern.compile("^\\s*" + REAL + "\\s+" + REAL + "\\s+\\d+\\s+\\d+\\s*$");
    private static final Pattern DATA_LINE = Pattern.compile("^\\s*\\d+\\s+\\d+\\s+" + REAL + "\\s+" + REAL + "\\s+" + REAL + "\\s+" + REAL + "\\s*$");
    private static final int START_DEGREE_ORDER = 120;

    public SHAFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        super(supportedNames, missingCoefficientsAllowed, null);
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.setReadComplete(false);
        this.setTideSystem(TideSystem.UNKNOWN);
        int lineNumber = 0;
        String line = null;
        TemporaryCoefficientsContainer container = new TemporaryCoefficientsContainer(120, 120, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            line = r.readLine();
            while (line != null) {
                if (++lineNumber == 1) {
                    if (!HEADER_LINE.matcher(line).matches()) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                    String[] headerFields = SEPARATOR.split(line.trim());
                    this.setMu(Double.parseDouble(headerFields[0]));
                    this.setAe(Double.parseDouble(headerFields[1]));
                    int maxDegree = Integer.parseInt(headerFields[2]);
                    int maxOrder = Integer.parseInt(headerFields[3]);
                    container = container.resize(maxDegree, maxOrder);
                    this.parseCoefficient(ONE, container.getFlattener(), container.getC(), 0, 0, "C", name);
                    this.parseCoefficient(ZERO, container.getFlattener(), container.getS(), 0, 0, "S", name);
                    this.parseCoefficient(ZERO, container.getFlattener(), container.getS(), 1, 0, "C", name);
                    this.parseCoefficient(ZERO, container.getFlattener(), container.getS(), 1, 0, "S", name);
                    this.parseCoefficient(ZERO, container.getFlattener(), container.getS(), 1, 1, "C", name);
                    this.parseCoefficient(ZERO, container.getFlattener(), container.getS(), 1, 1, "S", name);
                } else if (lineNumber > 1) {
                    if (!DATA_LINE.matcher(line).matches()) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                    String[] dataFields = SEPARATOR.split(line.trim());
                    int n = Integer.parseInt(dataFields[0]);
                    int m = Integer.parseInt(dataFields[1]);
                    this.parseCoefficient(dataFields[2], container.getFlattener(), container.getC(), n, m, "C", name);
                    this.parseCoefficient(dataFields[3], container.getFlattener(), container.getS(), n, m, "S", name);
                }
                line = r.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        this.setRawCoefficients(true, container.getFlattener(), container.getC(), container.getS(), name);
        this.setReadComplete(true);
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) {
        return this.getBaseProvider(wantNormalized, degree, order);
    }
}

