/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.ConstantSphericalHarmonics;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.TimeDependentHarmonic;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;

public abstract class PotentialCoefficientsReader
implements DataLoader {
    private int maxParseDegree;
    private int maxParseOrder;
    private final String supportedNames;
    private final boolean missingCoefficientsAllowed;
    private final TimeScale timeScale;
    private boolean readComplete;
    private double ae;
    private double mu;
    private Flattener flattener;
    private double[] rawC;
    private double[] rawS;
    private boolean normalized;
    private TideSystem tideSystem;

    @DefaultDataContext
    protected PotentialCoefficientsReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this(supportedNames, missingCoefficientsAllowed, DataContext.getDefault().getTimeScales().getTT());
    }

    protected PotentialCoefficientsReader(String supportedNames, boolean missingCoefficientsAllowed, TimeScale timeScale) {
        this.supportedNames = supportedNames;
        this.missingCoefficientsAllowed = missingCoefficientsAllowed;
        this.maxParseDegree = Integer.MAX_VALUE;
        this.maxParseOrder = Integer.MAX_VALUE;
        this.readComplete = false;
        this.ae = Double.NaN;
        this.mu = Double.NaN;
        this.flattener = null;
        this.rawC = null;
        this.rawS = null;
        this.normalized = false;
        this.tideSystem = TideSystem.UNKNOWN;
        this.timeScale = timeScale;
    }

    public String getSupportedNames() {
        return this.supportedNames;
    }

    public boolean missingCoefficientsAllowed() {
        return this.missingCoefficientsAllowed;
    }

    public void setMaxParseDegree(int maxParseDegree) {
        this.maxParseDegree = maxParseDegree;
    }

    public int getMaxParseDegree() {
        return this.maxParseDegree;
    }

    public void setMaxParseOrder(int maxParseOrder) {
        this.maxParseOrder = maxParseOrder;
    }

    public int getMaxParseOrder() {
        return this.maxParseOrder;
    }

    @Override
    public boolean stillAcceptsData() {
        return !this.readComplete || this.getMaxAvailableDegree() < this.getMaxParseDegree() || this.getMaxAvailableOrder() < this.getMaxParseOrder();
    }

    protected void setReadComplete(boolean readComplete) {
        this.readComplete = readComplete;
    }

    protected void setAe(double ae) {
        this.ae = ae;
    }

    protected double getAe() {
        return this.ae;
    }

    protected void setMu(double mu) {
        this.mu = mu;
    }

    protected double getMu() {
        return this.mu;
    }

    protected void setTideSystem(TideSystem tideSystem) {
        this.tideSystem = tideSystem;
    }

    protected TideSystem getTideSystem() {
        return this.tideSystem;
    }

    protected void setRawCoefficients(boolean rawNormalized, Flattener f, double[] c, double[] s, String name) {
        int j;
        int i;
        this.flattener = f;
        this.normalized = rawNormalized;
        this.setIfUnset(c, this.flattener.index(0, 0), 1.0);
        this.setIfUnset(s, this.flattener.index(0, 0), 0.0);
        if (this.flattener.getDegree() >= 1) {
            this.setIfUnset(c, this.flattener.index(1, 0), 0.0);
            this.setIfUnset(s, this.flattener.index(1, 0), 0.0);
            if (this.flattener.getOrder() >= 1) {
                this.setIfUnset(c, this.flattener.index(1, 1), 0.0);
                this.setIfUnset(s, this.flattener.index(1, 1), 0.0);
            }
        }
        for (i = 0; i <= this.flattener.getDegree(); ++i) {
            for (j = 0; j <= FastMath.min((int)i, (int)this.flattener.getOrder()); ++j) {
                if (!Double.isNaN(c[this.flattener.index(i, j)])) continue;
                throw new OrekitException((Localizable)OrekitMessages.MISSING_GRAVITY_FIELD_COEFFICIENT_IN_FILE, Character.valueOf('C'), i, j, name);
            }
        }
        this.rawC = (double[])c.clone();
        for (i = 0; i <= this.flattener.getDegree(); ++i) {
            for (j = 0; j <= FastMath.min((int)i, (int)this.flattener.getOrder()); ++j) {
                if (!Double.isNaN(s[this.flattener.index(i, j)])) continue;
                throw new OrekitException((Localizable)OrekitMessages.MISSING_GRAVITY_FIELD_COEFFICIENT_IN_FILE, Character.valueOf('S'), i, j, name);
            }
        }
        this.rawS = (double[])s.clone();
    }

    private boolean setIfUnset(double[] array, int i, double value) {
        if (array.length > i && (Double.isNaN(array[i]) || Precision.equals((double)array[i], (double)0.0, (int)0))) {
            array[i] = value;
            return true;
        }
        return false;
    }

    public int getMaxAvailableDegree() {
        return this.flattener.getDegree();
    }

    public int getMaxAvailableOrder() {
        return this.flattener.getOrder();
    }

    @Override
    public abstract void loadData(InputStream var1, String var2) throws IOException, ParseException, OrekitException;

    public abstract RawSphericalHarmonicsProvider getProvider(boolean var1, int var2, int var3);

    protected ConstantSphericalHarmonics getBaseProvider(boolean wantNormalized, int degree, int order) {
        if (!this.readComplete) {
            throw new OrekitException((Localizable)OrekitMessages.NO_GRAVITY_FIELD_DATA_LOADED, new Object[0]);
        }
        Flattener truncatedFlattener = new Flattener(degree, order);
        return new ConstantSphericalHarmonics(this.ae, this.mu, this.tideSystem, truncatedFlattener, this.rescale(1.0, wantNormalized, truncatedFlattener, this.flattener, this.rawC), this.rescale(1.0, wantNormalized, truncatedFlattener, this.flattener, this.rawS));
    }

    protected static double[] buildFlatArray(Flattener flattener, double value) {
        double[] array = new double[flattener.arraySize()];
        Arrays.fill(array, value);
        return array;
    }

    protected static double parseDouble(String string) {
        return Double.parseDouble(string.toUpperCase(Locale.ENGLISH).replace('D', 'E'));
    }

    protected static double[] buildRow(int degree, int order, double value) {
        double[] row = new double[FastMath.min((int)order, (int)degree) + 1];
        Arrays.fill(row, value);
        return row;
    }

    protected void parseCoefficient(String field, Flattener f, double[] array, int i, int j, String cName, String name) {
        int index = f.index(i, j);
        double value = PotentialCoefficientsReader.parseDouble(field);
        double oldValue = array[index];
        if (!Double.isNaN(oldValue) && !Precision.equals((double)oldValue, (double)0.0, (int)0)) {
            throw new OrekitException((Localizable)OrekitMessages.DUPLICATED_GRAVITY_FIELD_COEFFICIENT_IN_FILE, name, i, j, name);
        }
        array[index] = value;
    }

    protected double[] rescale(double scale, boolean wantNormalized, Flattener rescaledFlattener, Flattener originalFlattener, double[] original) {
        FactorsGenerator generator;
        if (rescaledFlattener.getDegree() > originalFlattener.getDegree()) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_DEGREE_FOR_GRAVITY_FIELD, rescaledFlattener.getDegree(), this.flattener.getDegree());
        }
        if (rescaledFlattener.getOrder() > originalFlattener.getOrder()) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ORDER_FOR_GRAVITY_FIELD, rescaledFlattener.getOrder(), this.flattener.getOrder());
        }
        if (wantNormalized == this.normalized) {
            generator = (n, m) -> scale;
        } else {
            double[][] unnormalizationFactors = GravityFieldFactory.getUnnormalizationFactors(rescaledFlattener.getDegree(), rescaledFlattener.getOrder());
            generator = wantNormalized ? (n, m) -> scale / unnormalizationFactors[n][m] : (n, m) -> scale * unnormalizationFactors[n][m];
        }
        double[] rescaled = PotentialCoefficientsReader.buildFlatArray(rescaledFlattener, 0.0);
        for (int n2 = 0; n2 <= rescaledFlattener.getDegree(); ++n2) {
            for (int m2 = 0; m2 <= FastMath.min((int)n2, (int)rescaledFlattener.getOrder()); ++m2) {
                int rescaledndex = rescaledFlattener.index(n2, m2);
                int originalndex = originalFlattener.index(n2, m2);
                rescaled[rescaledndex] = original[originalndex] * generator.factor(n2, m2);
            }
        }
        return rescaled;
    }

    protected TimeDependentHarmonic[] rescale(boolean wantNormalized, Flattener rescaledFlattener, Flattener originalFlattener, TimeDependentHarmonic[] original) {
        FactorsGenerator generator;
        if (rescaledFlattener.getDegree() > originalFlattener.getDegree()) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_DEGREE_FOR_GRAVITY_FIELD, rescaledFlattener.getDegree(), this.flattener.getDegree());
        }
        if (rescaledFlattener.getOrder() > originalFlattener.getOrder()) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ORDER_FOR_GRAVITY_FIELD, rescaledFlattener.getOrder(), this.flattener.getOrder());
        }
        if (wantNormalized == this.normalized) {
            generator = (n, m) -> 1.0;
        } else {
            double[][] unnormalizationFactors = GravityFieldFactory.getUnnormalizationFactors(rescaledFlattener.getDegree(), rescaledFlattener.getOrder());
            generator = wantNormalized ? (n, m) -> 1.0 / unnormalizationFactors[n][m] : (n, m) -> unnormalizationFactors[n][m];
        }
        TimeDependentHarmonic[] rescaled = new TimeDependentHarmonic[rescaledFlattener.arraySize()];
        for (int n2 = 0; n2 <= rescaledFlattener.getDegree(); ++n2) {
            for (int m2 = 0; m2 <= FastMath.min((int)n2, (int)rescaledFlattener.getOrder()); ++m2) {
                int originalndex = originalFlattener.index(n2, m2);
                if (original[originalndex] == null) continue;
                int rescaledndex = rescaledFlattener.index(n2, m2);
                double factor = generator.factor(n2, m2);
                rescaled[rescaledndex] = new TimeDependentHarmonic(factor, original[originalndex]);
            }
        }
        return rescaled;
    }

    protected AbsoluteDate toDate(DateComponents components) {
        return this.toDate(components, TimeComponents.H12);
    }

    protected AbsoluteDate toDate(DateComponents dc, TimeComponents tc) {
        return new AbsoluteDate(dc, tc, this.timeScale);
    }

    private static interface FactorsGenerator {
        public double factor(int var1, int var2);
    }
}

