/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.forces.gravity.potential.ConstantSphericalHarmonics;
import org.orekit.forces.gravity.potential.PiecewisePart;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

class PiecewiseSphericalHarmonics
implements RawSphericalHarmonicsProvider {
    private final ConstantSphericalHarmonics constant;
    private final AbsoluteDate[] references;
    private final double[] pulsations;
    private final TimeSpanMap<PiecewisePart> pieces;
    private final int maxDegree;
    private final int maxOrder;

    PiecewiseSphericalHarmonics(ConstantSphericalHarmonics constant, AbsoluteDate[] references, double[] pulsations, TimeSpanMap<PiecewisePart> pieces) {
        this.constant = constant;
        this.references = (AbsoluteDate[])references.clone();
        this.pulsations = (double[])pulsations.clone();
        this.pieces = pieces;
        int d = constant.getMaxDegree();
        int o = constant.getMaxOrder();
        for (TimeSpanMap.Span<PiecewisePart> span = pieces.getFirstSpan(); span != null; span = span.next()) {
            PiecewisePart piece = span.getData();
            if (piece == null) continue;
            d = FastMath.max((int)d, (int)piece.getMaxDegree());
            o = FastMath.max((int)o, (int)piece.getMaxOrder());
        }
        this.maxDegree = d;
        this.maxOrder = o;
    }

    public ConstantSphericalHarmonics getConstant() {
        return this.constant;
    }

    @Override
    public int getMaxDegree() {
        return this.maxDegree;
    }

    @Override
    public int getMaxOrder() {
        return this.maxOrder;
    }

    @Override
    public double getMu() {
        return this.constant.getMu();
    }

    @Override
    public double getAe() {
        return this.constant.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        AbsoluteDate last = AbsoluteDate.PAST_INFINITY;
        for (AbsoluteDate date : this.references) {
            if (!date.isAfter(last)) continue;
            last = date;
        }
        return last;
    }

    @Override
    public TideSystem getTideSystem() {
        return this.constant.getTideSystem();
    }

    @Override
    public RawSphericalHarmonicsProvider.RawSphericalHarmonics onDate(final AbsoluteDate date) {
        final RawSphericalHarmonicsProvider.RawSphericalHarmonics raw = this.constant.onDate(date);
        final PiecewisePart piece = this.pieces.get(date);
        final double[] offsets = new double[this.references.length];
        final SinCos[][] sinCos = new SinCos[this.references.length][this.pulsations.length];
        for (int i = 0; i < this.references.length; ++i) {
            double offset;
            offsets[i] = offset = date.durationFrom(this.references[i]);
            for (int j = 0; j < this.pulsations.length; ++j) {
                sinCos[i][j] = FastMath.sinCos((double)(offset * this.pulsations[j]));
            }
        }
        return new RawSphericalHarmonicsProvider.RawSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getRawCnm(int n, int m) {
                return raw.getRawCnm(n, m) + piece.computeCnm(n, m, offsets, sinCos);
            }

            @Override
            public double getRawSnm(int n, int m) {
                return raw.getRawSnm(n, m) + piece.computeSnm(n, m, offsets, sinCos);
            }
        };
    }
}

