/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.util.SinCos;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.TimeDependentHarmonic;

class PiecewisePart {
    private final Flattener flattener;
    private final TimeDependentHarmonic[] components;

    PiecewisePart(Flattener flattener, TimeDependentHarmonic[] components) {
        this.flattener = flattener;
        this.components = (TimeDependentHarmonic[])components.clone();
    }

    public int getMaxDegree() {
        return this.flattener.getDegree();
    }

    public int getMaxOrder() {
        return this.flattener.getOrder();
    }

    public double computeCnm(int n, int m, double[] offsets, SinCos[][] pulsations) {
        TimeDependentHarmonic harmonic = this.components[this.flattener.index(n, m)];
        return harmonic == null ? 0.0 : harmonic.computeCnm(offsets, pulsations);
    }

    public double computeSnm(int n, int m, double[] offsets, SinCos[][] pulsations) {
        TimeDependentHarmonic harmonic = this.components[this.flattener.index(n, m)];
        return harmonic == null ? 0.0 : harmonic.computeSnm(offsets, pulsations);
    }
}

