/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.OceanTidesWave;

public abstract class OceanTidesReader
implements DataLoader {
    private final String supportedNames;
    private int maxParseDegree;
    private int maxParseOrder;
    private List<OceanTidesWave> waves;
    private String name;
    private Map<Integer, double[][][]> coefficients;
    private int maxDegree;
    private int maxOrder;

    public OceanTidesReader(String supportedNames) {
        this.supportedNames = supportedNames;
        this.maxParseDegree = Integer.MAX_VALUE;
        this.maxParseOrder = Integer.MAX_VALUE;
        this.waves = new ArrayList<OceanTidesWave>();
    }

    public String getSupportedNames() {
        return this.supportedNames;
    }

    public void setMaxParseDegree(int maxParseDegree) {
        this.maxParseDegree = maxParseDegree;
    }

    public int getMaxParseDegree() {
        return this.maxParseDegree;
    }

    public void setMaxParseOrder(int maxParseOrder) {
        this.maxParseOrder = maxParseOrder;
    }

    public int getMaxParseOrder() {
        return this.maxParseOrder;
    }

    @Override
    public boolean stillAcceptsData() {
        return this.getMaxAvailableDegree() != this.getMaxParseDegree() || this.getMaxAvailableOrder() != this.getMaxParseOrder();
    }

    protected void startParse(String fileName) {
        this.waves = new ArrayList<OceanTidesWave>();
        this.name = fileName;
        this.coefficients = new HashMap<Integer, double[][][]>();
        this.maxDegree = -1;
        this.maxOrder = -1;
    }

    public boolean canAdd(int n, int m) {
        this.maxDegree = FastMath.max((int)this.maxDegree, (int)n);
        this.maxOrder = FastMath.max((int)this.maxOrder, (int)m);
        return n <= this.getMaxParseDegree() && m <= this.getMaxParseOrder();
    }

    protected void addWaveCoefficients(int doodson, int n, int m, double cPlus, double sPlus, double cMinus, double sMinus, int lineNumber, String line) {
        if (!this.coefficients.containsKey(doodson)) {
            double[][][] array = new double[this.getMaxParseDegree() + 1][][];
            for (int i = 0; i <= this.getMaxParseDegree(); ++i) {
                array[i] = new double[FastMath.min((int)i, (int)this.getMaxParseOrder()) + 1][4];
                for (double[] a : array[i]) {
                    Arrays.fill(a, Double.NaN);
                }
            }
            this.coefficients.put(doodson, array);
        }
        double[] cs = this.coefficients.get(doodson)[n][m];
        cs[0] = cPlus;
        cs[1] = sPlus;
        cs[2] = cMinus;
        cs[3] = sMinus;
    }

    protected void endParse() {
        if (this.maxDegree < this.getMaxParseDegree() || this.maxOrder < this.getMaxParseOrder()) {
            throw new OrekitException((Localizable)OrekitMessages.OCEAN_TIDE_DATA_DEGREE_ORDER_LIMITS, this.name, this.maxDegree, this.maxOrder);
        }
        for (Map.Entry<Integer, double[][][]> entry : this.coefficients.entrySet()) {
            int waveDegree = -1;
            int waveOrder = -1;
            for (int i = 0; i < entry.getValue().length; ++i) {
                for (int j = 0; j < entry.getValue()[i].length; ++j) {
                    if (Double.isNaN(entry.getValue()[i][j][0])) continue;
                    waveDegree = FastMath.max((int)waveDegree, (int)i);
                    waveOrder = FastMath.max((int)waveOrder, (int)j);
                }
            }
            this.waves.add(new OceanTidesWave(entry.getKey(), waveDegree, waveOrder, entry.getValue()));
        }
    }

    public List<OceanTidesWave> getWaves() {
        return this.waves;
    }

    public int getMaxAvailableDegree() {
        return this.waves.stream().map(OceanTidesWave::getMaxDegree).max(Integer::compareTo).orElse(-1);
    }

    public int getMaxAvailableOrder() {
        return this.waves.stream().map(OceanTidesWave::getMaxOrder).max(Integer::compareTo).orElse(-1);
    }
}

