/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.ConstantSphericalHarmonics;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.PiecewisePart;
import org.orekit.forces.gravity.potential.PiecewiseSphericalHarmonics;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.TimeDependentHarmonic;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeSpanMap;

public class ICGEMFormatReader
extends PotentialCoefficientsReader {
    private static final String FORMAT = "format";
    private static final double MAX_FORMAT = 2.0;
    private static final String PRODUCT_TYPE = "product_type";
    private static final String GRAVITY_FIELD = "gravity_field";
    private static final String GRAVITY_CONSTANT = "gravity_constant";
    private static final String REFERENCE_RADIUS = "radius";
    private static final String MAX_DEGREE = "max_degree";
    private static final String ERRORS = "errors";
    private static final String TIDE_SYSTEM_INDICATOR = "tide_system";
    private static final String ZERO_TIDE = "zero_tide";
    private static final String TIDE_FREE = "tide_free";
    private static final String TIDE_UNKNOWN = "unknown";
    private static final String NORMALIZATION_INDICATOR = "norm";
    private static final String NORMALIZED = "fully_normalized";
    private static final String UNNORMALIZED = "unnormalized";
    private static final String END_OF_HEADER = "end_of_head";
    private static final String GFC = "gfc";
    private static final String GFCT = "gfct";
    private static final String DOT = "dot";
    private static final String TRND = "trnd";
    private static final String ASIN = "asin";
    private static final String ACOS = "acos";
    private static final String BASE_NAMES = "C/S";
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final Pattern SUPPORTED_FORMAT = Pattern.compile("icgem(\\d+\\.\\d+)");
    private static final int MU = 1;
    private static final int AE = 2;
    private static final int LIMITS = 4;
    private static final int ERR = 8;
    private static final int COEFFS = 16;
    private boolean normalized;
    private List<AbsoluteDate> referenceDates;
    private List<Double> pulsations;
    private TimeSpanMap<Container> containers;

    @DefaultDataContext
    public ICGEMFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this(supportedNames, missingCoefficientsAllowed, DataContext.getDefault().getTimeScales().getTT());
    }

    public ICGEMFormatReader(String supportedNames, boolean missingCoefficientsAllowed, TimeScale timeScale) {
        super(supportedNames, missingCoefficientsAllowed, timeScale);
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.setReadComplete(false);
        this.containers = null;
        this.referenceDates = new ArrayList<AbsoluteDate>();
        this.pulsations = new ArrayList<Double>();
        this.normalized = true;
        TideSystem tideSystem = TideSystem.UNKNOWN;
        Errors errors = Errors.NO;
        double version = 1.0;
        boolean inHeader = true;
        Flattener flattener = null;
        int flags = 0;
        double[] c0 = null;
        double[] s0 = null;
        int lineNumber = 0;
        String line = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            line = r.readLine();
            while (line != null) {
                block78: {
                    boolean parseError;
                    block76: {
                        String[] tab;
                        block80: {
                            AbsoluteDate t1;
                            block79: {
                                parseError = false;
                                ++lineNumber;
                                if ((line = line.trim()).isEmpty()) break block78;
                                tab = SEPARATOR.split(line);
                                if (!inHeader) break block79;
                                if (tab.length >= 2 && FORMAT.equals(tab[0])) {
                                    Matcher matcher = SUPPORTED_FORMAT.matcher(tab[1]);
                                    if (matcher.matches()) {
                                        version = Double.parseDouble(matcher.group(1));
                                        if (version > 2.0) {
                                            parseError = true;
                                        }
                                    } else {
                                        parseError = true;
                                    }
                                } else if (tab.length >= 2 && PRODUCT_TYPE.equals(tab[0])) {
                                    parseError = !GRAVITY_FIELD.equals(tab[1]);
                                } else if (tab.length >= 2 && tab[0].endsWith(GRAVITY_CONSTANT)) {
                                    this.setMu(ICGEMFormatReader.parseDouble(tab[1]));
                                    flags |= 1;
                                } else if (tab.length >= 2 && REFERENCE_RADIUS.equals(tab[0])) {
                                    this.setAe(ICGEMFormatReader.parseDouble(tab[1]));
                                    flags |= 2;
                                } else if (tab.length >= 2 && MAX_DEGREE.equals(tab[0])) {
                                    int degree = FastMath.min((int)this.getMaxParseDegree(), (int)Integer.parseInt(tab[1]));
                                    int order = FastMath.min((int)this.getMaxParseOrder(), (int)degree);
                                    flattener = new Flattener(degree, order);
                                    c0 = ICGEMFormatReader.buildFlatArray(flattener, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                                    s0 = ICGEMFormatReader.buildFlatArray(flattener, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                                    flags |= 4;
                                } else if (tab.length >= 2 && ERRORS.equals(tab[0])) {
                                    try {
                                        errors = Errors.valueOf(tab[1].toUpperCase(Locale.US));
                                        flags |= 8;
                                    }
                                    catch (IllegalArgumentException iae) {
                                        parseError = true;
                                    }
                                } else if (tab.length >= 2 && TIDE_SYSTEM_INDICATOR.equals(tab[0])) {
                                    if (ZERO_TIDE.equals(tab[1])) {
                                        tideSystem = TideSystem.ZERO_TIDE;
                                    } else if (TIDE_FREE.equals(tab[1])) {
                                        tideSystem = TideSystem.TIDE_FREE;
                                    } else if (TIDE_UNKNOWN.equals(tab[1])) {
                                        tideSystem = TideSystem.UNKNOWN;
                                    } else {
                                        parseError = true;
                                    }
                                } else if (tab.length >= 2 && NORMALIZATION_INDICATOR.equals(tab[0])) {
                                    if (NORMALIZED.equals(tab[1])) {
                                        this.normalized = true;
                                    } else if (UNNORMALIZED.equals(tab[1])) {
                                        this.normalized = false;
                                    } else {
                                        parseError = true;
                                    }
                                } else if (tab.length >= 1 && END_OF_HEADER.equals(tab[0])) {
                                    inHeader = false;
                                }
                                if (parseError) {
                                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                }
                                break block76;
                            }
                            if (!this.dataKeyKnown(tab) || tab.length <= 2) break block80;
                            int n = Integer.parseInt(tab[1]);
                            int m = Integer.parseInt(tab[2]);
                            flags |= 0x10;
                            if (!flattener.withinRange(n, m)) break block78;
                            if (tab.length > 4 && GFC.equals(tab[0])) {
                                this.parseCoefficient(tab[3], flattener, c0, n, m, "C", name);
                                this.parseCoefficient(tab[4], flattener, s0, n, m, "S", name);
                            } else if (version < 2.0 && tab.length > 5 + errors.fields && GFCT.equals(tab[0])) {
                                if (this.containers == null) {
                                    this.containers = new TimeSpanMap<Container>(new Container(flattener));
                                }
                                int globalIndex = flattener.index(n, m);
                                c0[globalIndex] = 0.0;
                                s0[globalIndex] = 0.0;
                                AbsoluteDate lineDate = this.parseDate(tab[5 + errors.fields]);
                                int referenceIndex = this.referenceDateIndex(this.referenceDates, lineDate);
                                if (referenceIndex != 0) {
                                    throw new OrekitException((Localizable)OrekitMessages.SEVERAL_REFERENCE_DATES_IN_GRAVITY_FIELD, this.referenceDates.get(0), lineDate, name, lineDate.durationFrom(this.referenceDates.get(0)));
                                }
                                Container single = this.containers.getFirstSpan().getData();
                                int index = single.flattener.index(n, m);
                                if (single.components[index] != null) {
                                    throw new OrekitException((Localizable)OrekitMessages.DUPLICATED_GRAVITY_FIELD_COEFFICIENT_IN_FILE, BASE_NAMES, n, m, name);
                                }
                                ((Container)single).components[index] = new TimeDependentHarmonic(referenceIndex, ICGEMFormatReader.parseDouble(tab[3]), ICGEMFormatReader.parseDouble(tab[4]));
                            } else if (version >= 2.0 && tab.length > 6 + errors.fields && GFCT.equals(tab[0])) {
                                if (this.containers == null) {
                                    this.containers = new TimeSpanMap<Object>(null);
                                }
                                int globalIndex = flattener.index(n, m);
                                c0[globalIndex] = 0.0;
                                s0[globalIndex] = 0.0;
                                AbsoluteDate t0 = this.parseDate(tab[5 + errors.fields]);
                                AbsoluteDate t12 = this.parseDate(tab[6 + errors.fields]);
                                List<TimeSpanMap.Span<Container>> active = this.getActive(flattener, t0, t12);
                                for (TimeSpanMap.Span<Container> span : active) {
                                    Container container = span.getData();
                                    int index = container.flattener.index(n, m);
                                    if (container.components[index] != null) {
                                        throw new OrekitException((Localizable)OrekitMessages.DUPLICATED_GRAVITY_FIELD_COEFFICIENT_IN_FILE, BASE_NAMES, n, m, name);
                                    }
                                    ((Container)container).components[index] = new TimeDependentHarmonic(this.referenceDateIndex(this.referenceDates, t0), ICGEMFormatReader.parseDouble(tab[3]), ICGEMFormatReader.parseDouble(tab[4]));
                                }
                            } else if (version < 2.0 && tab.length > 4 && (DOT.equals(tab[0]) || TRND.equals(tab[0]))) {
                                Container single = this.containers.getFirstSpan().getData();
                                TimeDependentHarmonic harmonic = single.components[single.flattener.index(n, m)];
                                if (harmonic == null) {
                                    parseError = true;
                                } else {
                                    harmonic.setTrend(ICGEMFormatReader.parseDouble(tab[3]) / 3.15576E7, ICGEMFormatReader.parseDouble(tab[4]) / 3.15576E7);
                                }
                            } else if (version >= 2.0 && tab.length > 6 + errors.fields && TRND.equals(tab[0])) {
                                AbsoluteDate t0 = this.parseDate(tab[5 + errors.fields]);
                                t1 = this.parseDate(tab[6 + errors.fields]);
                                List<TimeSpanMap.Span<Container>> active = this.getActive(flattener, t0, t1);
                                for (TimeSpanMap.Span<Container> span : active) {
                                    Container container = span.getData();
                                    int index = container.flattener.index(n, m);
                                    if (container.components[index] == null) {
                                        parseError = true;
                                        break block76;
                                    }
                                    container.components[index].setTrend(ICGEMFormatReader.parseDouble(tab[3]) / 3.15576E7, ICGEMFormatReader.parseDouble(tab[4]) / 3.15576E7);
                                }
                            } else if (version < 2.0 && tab.length > 5 + errors.fields && (ASIN.equals(tab[0]) || ACOS.equals(tab[0]))) {
                                double period = ICGEMFormatReader.parseDouble(tab[5 + errors.fields]) * 3.15576E7;
                                int pIndex = this.pulsationIndex(this.pulsations, Math.PI * 2 / period);
                                Container single = this.containers.getFirstSpan().getData();
                                TimeDependentHarmonic harmonic = single.components[single.flattener.index(n, m)];
                                if (harmonic == null) {
                                    parseError = true;
                                } else if (ACOS.equals(tab[0])) {
                                    harmonic.addCosine(-1, pIndex, ICGEMFormatReader.parseDouble(tab[3]), ICGEMFormatReader.parseDouble(tab[4]));
                                } else {
                                    harmonic.addSine(-1, pIndex, ICGEMFormatReader.parseDouble(tab[3]), ICGEMFormatReader.parseDouble(tab[4]));
                                }
                            } else if (version >= 2.0 && tab.length > 7 + errors.fields && (ASIN.equals(tab[0]) || ACOS.equals(tab[0]))) {
                                AbsoluteDate t0 = this.parseDate(tab[5 + errors.fields]);
                                t1 = this.parseDate(tab[6 + errors.fields]);
                                int tIndex = this.referenceDateIndex(this.referenceDates, t0);
                                double period = ICGEMFormatReader.parseDouble(tab[7 + errors.fields]) * 3.15576E7;
                                int pIndex = this.pulsationIndex(this.pulsations, Math.PI * 2 / period);
                                List<TimeSpanMap.Span<Container>> active = this.getActive(flattener, t0, t1);
                                for (TimeSpanMap.Span<Container> span : active) {
                                    Container container = span.getData();
                                    int index = container.flattener.index(n, m);
                                    if (container.components[index] == null) {
                                        parseError = true;
                                        break block76;
                                    }
                                    if (ASIN.equals(tab[0])) {
                                        container.components[index].addSine(tIndex, pIndex, ICGEMFormatReader.parseDouble(tab[3]), ICGEMFormatReader.parseDouble(tab[4]));
                                        continue;
                                    }
                                    container.components[index].addCosine(tIndex, pIndex, ICGEMFormatReader.parseDouble(tab[3]), ICGEMFormatReader.parseDouble(tab[4]));
                                }
                            } else {
                                parseError = true;
                            }
                            break block76;
                        }
                        if (this.dataKeyKnown(tab)) {
                            parseError = true;
                        }
                    }
                    if (parseError) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                }
                line = r.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        if (flags != 31) {
            String loaderName = this.getClass().getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
        if (this.missingCoefficientsAllowed() && Precision.equals((double)c0[flattener.index(0, 0)], (double)0.0, (int)0)) {
            c0[flattener.index((int)0, (int)0)] = 1.0;
        }
        this.setRawCoefficients(this.normalized, flattener, c0, s0, name);
        this.setTideSystem(tideSystem);
        this.setReadComplete(true);
    }

    private boolean dataKeyKnown(String[] tab) {
        return tab.length > 0 && (GFC.equals(tab[0]) || GFCT.equals(tab[0]) || DOT.equals(tab[0]) || TRND.equals(tab[0]) || ASIN.equals(tab[0]) || ACOS.equals(tab[0]));
    }

    private List<TimeSpanMap.Span<Container>> getActive(Flattener flattener, AbsoluteDate t0, AbsoluteDate t1) {
        ArrayList<TimeSpanMap.Span<Container>> active = new ArrayList<TimeSpanMap.Span<Container>>();
        TimeSpanMap.Span<Container> span = this.containers.getSpan(t0);
        if (span.getStart().isBefore(t0)) {
            if (span.getEnd().isAfterOrEqualTo(t1)) {
                if (span.getData() == null) {
                    span = this.containers.addValidBetween(new Container(flattener), t0, t1);
                } else {
                    this.containers.addValidAfter(this.copyContainer(span.getData(), flattener), t1, false);
                    span = this.containers.addValidAfter(this.copyContainer(span.getData(), flattener), t0, false);
                }
            } else {
                span = this.containers.addValidAfter(this.copyContainer(span.getData(), flattener), t0, false);
            }
        }
        while (span.getStart().isBefore(t1)) {
            if (span.getEnd().isAfter(t1)) {
                span = this.containers.addValidBefore(this.copyContainer(span.getData(), flattener), t1, false);
            }
            active.add(span);
            span = span.next();
        }
        return active;
    }

    private Container copyContainer(Container original, Flattener flattener) {
        return original == null ? new Container(flattener) : original.resize(flattener.getDegree(), flattener.getOrder());
    }

    private int referenceDateIndex(List<AbsoluteDate> known, AbsoluteDate referenceDate) {
        for (int i = 0; i < known.size(); ++i) {
            if (!known.get(i).equals(referenceDate)) continue;
            return i;
        }
        known.add(referenceDate);
        return known.size() - 1;
    }

    private int pulsationIndex(List<Double> known, double pulsation) {
        for (int i = 0; i < known.size(); ++i) {
            if (!Precision.equals((double)known.get(i), (double)pulsation, (int)1)) continue;
            return i;
        }
        known.add(pulsation);
        return known.size() - 1;
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) {
        ConstantSphericalHarmonics constant = this.getBaseProvider(wantNormalized, degree, order);
        if (this.containers == null) {
            return constant;
        }
        AbsoluteDate[] dates = new AbsoluteDate[this.referenceDates.size()];
        for (int i = 0; i < dates.length; ++i) {
            dates[i] = this.referenceDates.get(i);
        }
        double[] puls = new double[this.pulsations.size()];
        for (int i = 0; i < puls.length; ++i) {
            puls[i] = this.pulsations.get(i);
        }
        TimeSpanMap<Object> pieces = new TimeSpanMap<Object>(null);
        for (TimeSpanMap.Span<Container> span = this.containers.getFirstSpan(); span != null; span = span.next()) {
            if (span.getData() == null) continue;
            Flattener spanFlattener = span.getData().flattener;
            Flattener rescaledFlattener = new Flattener(FastMath.min((int)degree, (int)spanFlattener.getDegree()), FastMath.min((int)order, (int)spanFlattener.getOrder()));
            pieces.addValidBetween(new PiecewisePart(rescaledFlattener, this.rescale(wantNormalized, rescaledFlattener, span.getData().flattener, span.getData().components)), span.getStart(), span.getEnd());
        }
        return new PiecewiseSphericalHarmonics(constant, dates, puls, pieces);
    }

    private AbsoluteDate parseDate(String field) {
        DateComponents dc = new DateComponents(Integer.parseInt(field.substring(0, 4)), Integer.parseInt(field.substring(4, 6)), Integer.parseInt(field.substring(6, 8)));
        TimeComponents tc = field.length() > 8 ? new TimeComponents(Integer.parseInt(field.substring(9, 11)) * 3600 + Integer.parseInt(field.substring(11, 13)) * 60) : TimeComponents.H12;
        return this.toDate(dc, tc);
    }

    private static enum Errors {
        NO(0),
        CALIBRATED(2),
        FORMAL(2),
        CALIBRATED_AND_FORMAL(4);

        private final int fields;

        private Errors(int fields) {
            this.fields = fields;
        }
    }

    private static class Container {
        private final Flattener flattener;
        private final TimeDependentHarmonic[] components;

        Container(Flattener flattener) {
            this.flattener = flattener;
            this.components = new TimeDependentHarmonic[flattener.arraySize()];
        }

        Container resize(int degree, int order) {
            Container resized = new Container(new Flattener(degree, order));
            for (int n = 0; n <= degree; ++n) {
                for (int m = 0; m <= FastMath.min((int)n, (int)order); ++m) {
                    resized.components[resized.flattener.index((int)n, (int)m)] = this.components[this.flattener.index(n, m)];
                }
            }
            return resized;
        }
    }
}

