/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.OrekitParseException;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.SecularTrendSphericalHarmonics;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;

public class GRGSFormatReader
extends PotentialCoefficientsReader {
    private static final Pattern[] LINES;
    private static final int EARTH = 1;
    private static final int LIMITS = 2;
    private static final int COEFFS = 4;
    private AbsoluteDate referenceDate;
    private Flattener dotFlattener;
    private double[] cDot;
    private double[] sDot;

    @DefaultDataContext
    public GRGSFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this(supportedNames, missingCoefficientsAllowed, DataContext.getDefault().getTimeScales().getTT());
    }

    public GRGSFormatReader(String supportedNames, boolean missingCoefficientsAllowed, TimeScale timeScale) {
        super(supportedNames, missingCoefficientsAllowed, timeScale);
        this.reset();
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.reset();
        Flattener flattener = null;
        int dotDegree = -1;
        int dotOrder = -1;
        int flags = 0;
        int lineNumber = 0;
        double[] c0 = null;
        double[] s0 = null;
        double[] c1 = null;
        double[] s1 = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line = r.readLine();
            while (line != null) {
                Matcher matcher;
                if (!(matcher = LINES[FastMath.min((int)LINES.length, (int)(++lineNumber)) - 1].matcher(line)).matches()) {
                    throw new OrekitParseException(OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                }
                if (lineNumber == 3) {
                    this.setAe(GRGSFormatReader.parseDouble(matcher.group(1)));
                    this.setMu(GRGSFormatReader.parseDouble(matcher.group(3)));
                    flags |= 1;
                } else if (lineNumber == 4) {
                    this.referenceDate = this.toDate(new DateComponents(Integer.parseInt(matcher.group(1)), 1, 1));
                } else if (lineNumber == 5) {
                    int degree = FastMath.min((int)this.getMaxParseDegree(), (int)Integer.parseInt(matcher.group(1)));
                    int order = FastMath.min((int)this.getMaxParseOrder(), (int)degree);
                    flattener = new Flattener(degree, order);
                    c0 = GRGSFormatReader.buildFlatArray(flattener, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                    s0 = GRGSFormatReader.buildFlatArray(flattener, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                    c1 = GRGSFormatReader.buildFlatArray(flattener, 0.0);
                    s1 = GRGSFormatReader.buildFlatArray(flattener, 0.0);
                    flags |= 2;
                } else if (lineNumber > 6) {
                    int j;
                    int i = Integer.parseInt(matcher.group(1).trim());
                    if (flattener.withinRange(i, j = Integer.parseInt(matcher.group(2).trim()))) {
                        if ("DOT".equals(matcher.group(3).trim())) {
                            this.parseCoefficient(matcher.group(4), flattener, c1, i, j, "Cdot", name);
                            this.parseCoefficient(matcher.group(5), flattener, s1, i, j, "Sdot", name);
                            dotDegree = FastMath.max((int)dotDegree, (int)i);
                            dotOrder = FastMath.max((int)dotOrder, (int)j);
                        } else {
                            this.parseCoefficient(matcher.group(4), flattener, c0, i, j, "C", name);
                            this.parseCoefficient(matcher.group(5), flattener, s0, i, j, "S", name);
                        }
                    }
                    flags |= 4;
                }
                line = r.readLine();
            }
        }
        if (flags != 7) {
            String loaderName = this.getClass().getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
        if (this.missingCoefficientsAllowed() && Precision.equals((double)c0[flattener.index(0, 0)], (double)0.0, (int)0)) {
            c0[flattener.index((int)0, (int)0)] = 1.0;
        }
        if (dotDegree >= 0) {
            this.dotFlattener = new Flattener(dotDegree, dotOrder);
            this.cDot = new double[this.dotFlattener.arraySize()];
            this.sDot = new double[this.dotFlattener.arraySize()];
            for (int n = 0; n <= dotDegree; ++n) {
                for (int m = 0; m <= FastMath.min((int)n, (int)dotOrder); ++m) {
                    this.cDot[this.dotFlattener.index((int)n, (int)m)] = c1[flattener.index(n, m)];
                    this.sDot[this.dotFlattener.index((int)n, (int)m)] = s1[flattener.index(n, m)];
                }
            }
        }
        this.setRawCoefficients(true, flattener, c0, s0, name);
        this.setTideSystem(TideSystem.UNKNOWN);
        this.setReadComplete(true);
    }

    private void reset() {
        this.setReadComplete(false);
        this.referenceDate = null;
        this.dotFlattener = null;
        this.cDot = null;
        this.sDot = null;
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) {
        RawSphericalHarmonicsProvider provider = this.getBaseProvider(wantNormalized, degree, order);
        if (this.dotFlattener != null) {
            double scale = 3.168808781402895E-8;
            Flattener rescaledFlattener = new Flattener(FastMath.min((int)degree, (int)this.dotFlattener.getDegree()), FastMath.min((int)order, (int)this.dotFlattener.getOrder()));
            provider = new SecularTrendSphericalHarmonics(provider, this.referenceDate, rescaledFlattener, this.rescale(3.168808781402895E-8, wantNormalized, rescaledFlattener, this.dotFlattener, this.cDot), this.rescale(3.168808781402895E-8, wantNormalized, rescaledFlattener, this.dotFlattener, this.sDot));
        }
        return provider;
    }

    static {
        String real = "[-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d";
        String sep = ")\\s*(";
        String[] header = new String[]{"^\\s*FIELD - .*$", "^\\s+AE\\s+1/F\\s+GM\\s+OMEGA\\s*$", "^\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*$", "^\\s*REFERENCE\\s+DATE\\s+:\\s+(\\d+)\\.0+\\s*$", "^\\s*MAXIMAL\\s+DEGREE\\s+:\\s+(\\d+)\\s.*$", "^\\s*L\\s+M\\s+DOT\\s+CBAR\\s+SBAR\\s+SIGMA C\\s+SIGMA S(\\s+LIB)?\\s*$"};
        String data = "^([ 0-9]{3})([ 0-9]{3})( {3}|DOT)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)(\\s+[0-9]+)?\\s*$";
        LINES = new Pattern[header.length + 1];
        for (int i = 0; i < header.length; ++i) {
            GRGSFormatReader.LINES[i] = Pattern.compile(header[i]);
        }
        GRGSFormatReader.LINES[GRGSFormatReader.LINES.length - 1] = Pattern.compile("^([ 0-9]{3})([ 0-9]{3})( {3}|DOT)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)(\\s+[0-9]+)?\\s*$");
    }
}

