/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TemporaryCoefficientsContainer;
import org.orekit.forces.gravity.potential.TideSystem;

public class EGMFormatReader
extends PotentialCoefficientsReader {
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final int START_DEGREE_ORDER = 120;
    private final boolean useWgs84Coefficients;

    public EGMFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this(supportedNames, missingCoefficientsAllowed, false);
    }

    public EGMFormatReader(String supportedNames, boolean missingCoefficientsAllowed, boolean useWgs84Coefficients) {
        super(supportedNames, missingCoefficientsAllowed, null);
        this.useWgs84Coefficients = useWgs84Coefficients;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.setReadComplete(false);
        if (this.useWgs84Coefficients) {
            this.setAe(6378137.0);
            this.setMu(3.986004418E14);
        } else {
            this.setAe(6378136.3);
            this.setMu(3.986004415E14);
        }
        String lowerCaseName = name.toLowerCase(Locale.US);
        if (lowerCaseName.contains("2008") || lowerCaseName.contains("zerotide")) {
            this.setTideSystem(TideSystem.ZERO_TIDE);
        } else {
            this.setTideSystem(TideSystem.TIDE_FREE);
        }
        TemporaryCoefficientsContainer container = new TemporaryCoefficientsContainer(120, 120, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
        boolean okFields = true;
        int maxDegree = -1;
        int maxOrder = -1;
        int lineNumber = 0;
        String line = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            line = r.readLine();
            while (okFields && line != null) {
                ++lineNumber;
                if (line.length() >= 15) {
                    String[] tab = SEPARATOR.split(line.trim());
                    if (tab.length != 6) {
                        okFields = false;
                    }
                    int i = Integer.parseInt(tab[0]);
                    int j = Integer.parseInt(tab[1]);
                    if (i < 0 || j < 0) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                    if (i <= this.getMaxParseDegree() && j <= this.getMaxParseOrder()) {
                        while (!container.getFlattener().withinRange(i, j)) {
                            container = container.resize(container.getFlattener().getDegree() * 2, container.getFlattener().getOrder() * 2);
                        }
                        this.parseCoefficient(tab[2], container.getFlattener(), container.getC(), i, j, "C", name);
                        this.parseCoefficient(tab[3], container.getFlattener(), container.getS(), i, j, "S", name);
                        maxDegree = FastMath.max((int)maxDegree, (int)i);
                        maxOrder = FastMath.max((int)maxOrder, (int)j);
                    }
                }
                line = r.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        if (this.missingCoefficientsAllowed() && this.getMaxParseDegree() > 0 && this.getMaxParseOrder() > 0 && Precision.equals((double)container.getC()[container.getFlattener().index(0, 0)], (double)0.0, (int)0)) {
            container.getC()[container.getFlattener().index((int)0, (int)0)] = 1.0;
        }
        if (!okFields || maxDegree < 0) {
            String loaderName = this.getClass().getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
        container = container.resize(maxDegree, maxOrder);
        this.setRawCoefficients(true, container.getFlattener(), container.getC(), container.getS(), name);
        this.setReadComplete(true);
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) {
        return this.getBaseProvider(wantNormalized, degree, order);
    }
}

