/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;

class ConstantSphericalHarmonics
implements RawSphericalHarmonicsProvider {
    private final double ae;
    private final double mu;
    private final TideSystem tideSystem;
    private final Flattener flattener;
    private final double[] rawC;
    private final double[] rawS;

    ConstantSphericalHarmonics(double ae, double mu, TideSystem tideSystem, Flattener flattener, double[] rawC, double[] rawS) {
        this.ae = ae;
        this.mu = mu;
        this.tideSystem = tideSystem;
        this.flattener = flattener;
        this.rawC = rawC;
        this.rawS = rawS;
    }

    ConstantSphericalHarmonics(AbsoluteDate freezingDate, RawSphericalHarmonicsProvider raw) {
        this.ae = raw.getAe();
        this.mu = raw.getMu();
        this.tideSystem = raw.getTideSystem();
        this.flattener = new Flattener(raw.getMaxDegree(), raw.getMaxOrder());
        this.rawC = new double[this.flattener.arraySize()];
        this.rawS = new double[this.flattener.arraySize()];
        RawSphericalHarmonicsProvider.RawSphericalHarmonics frozen = raw.onDate(freezingDate);
        for (int n = 0; n <= this.flattener.getDegree(); ++n) {
            for (int m = 0; m <= FastMath.min((int)n, (int)this.flattener.getOrder()); ++m) {
                int index = this.flattener.index(n, m);
                this.rawC[index] = frozen.getRawCnm(n, m);
                this.rawS[index] = frozen.getRawSnm(n, m);
            }
        }
    }

    @Override
    public int getMaxDegree() {
        return this.flattener.getDegree();
    }

    @Override
    public int getMaxOrder() {
        return this.flattener.getOrder();
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public double getAe() {
        return this.ae;
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return null;
    }

    @Override
    public TideSystem getTideSystem() {
        return this.tideSystem;
    }

    @Override
    public RawSphericalHarmonicsProvider.RawSphericalHarmonics onDate(final AbsoluteDate date) {
        return new RawSphericalHarmonicsProvider.RawSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getRawCnm(int n, int m) {
                return ConstantSphericalHarmonics.this.rawC[ConstantSphericalHarmonics.this.flattener.index(n, m)];
            }

            @Override
            public double getRawSnm(int n, int m) {
                return ConstantSphericalHarmonics.this.rawS[ConstantSphericalHarmonics.this.flattener.index(n, m)];
            }
        };
    }
}

