/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.forces.gravity.AbstractBodyAttraction;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;

public class ThirdBodyAttraction
extends AbstractBodyAttraction {
    public ThirdBodyAttraction(CelestialBody body) {
        super(body);
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double gm = parameters[0];
        Vector3D centralToBody = this.getBodyPosition(s.getDate(), s.getFrame());
        double r2Central = centralToBody.getNormSq();
        Vector3D satToBody = centralToBody.subtract((Vector)s.getPosition());
        double r2Sat = satToBody.getNormSq();
        return new Vector3D(gm / (r2Sat * FastMath.sqrt((double)r2Sat)), satToBody, -gm / (r2Central * FastMath.sqrt((double)r2Central)), centralToBody);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        T gm = parameters[0];
        FieldVector3D<T> centralToBody = this.getBodyPosition(s.getDate(), s.getFrame());
        CalculusFieldElement r2Central = centralToBody.getNormSq();
        FieldVector3D satToBody = centralToBody.subtract(s.getPosition());
        CalculusFieldElement r2Sat = satToBody.getNormSq();
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2Sat.multiply((FieldElement)((CalculusFieldElement)r2Sat.sqrt()))).reciprocal()).multiply(gm), satToBody, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2Central.multiply((FieldElement)((CalculusFieldElement)r2Central.sqrt()))).reciprocal()).multiply(gm)).negate(), centralToBody);
    }
}

