/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.CelestialBody;
import org.orekit.forces.gravity.AbstractBodyAttraction;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SingleBodyRelativeAttraction
extends AbstractBodyAttraction {
    public SingleBodyRelativeAttraction(CelestialBody body) {
        super(body);
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        TimeStampedPVCoordinates bodyPV = this.getBodyPVCoordinates(s.getDate(), s.getFrame());
        Vector3D satToBody = bodyPV.getPosition().subtract((Vector)s.getPosition());
        double r2Sat = satToBody.getNormSq();
        double gm = parameters[0];
        double a = gm / r2Sat;
        return new Vector3D(a, (Vector3D)satToBody.normalize()).add((Vector)bodyPV.getAcceleration());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        TimeStampedFieldPVCoordinates<T> bodyPV = this.getBodyPVCoordinates(s.getDate(), s.getFrame());
        FieldVector3D satToBody = bodyPV.getPosition().subtract(s.getPosition());
        CalculusFieldElement r2Sat = satToBody.getNormSq();
        T gm = parameters[0];
        CalculusFieldElement a = (CalculusFieldElement)gm.divide((FieldElement)r2Sat);
        return new FieldVector3D(a, satToBody.normalize()).add(bodyPV.getAcceleration());
    }
}

