/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.forces.gravity.AbstractBodyAttraction;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;

public class SingleBodyAbsoluteAttraction
extends AbstractBodyAttraction {
    public SingleBodyAbsoluteAttraction(CelestialBody body) {
        super(body);
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        Vector3D bodyPosition = this.getBodyPosition(s.getDate(), s.getFrame());
        Vector3D satToBody = bodyPosition.subtract((Vector)s.getPosition());
        double r2Sat = satToBody.getNormSq();
        return new Vector3D(parameters[0] / (r2Sat * FastMath.sqrt((double)r2Sat)), satToBody);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldVector3D<T> centralToBody = this.getBodyPosition(s.getDate(), s.getFrame());
        FieldVector3D satToBody = centralToBody.subtract(s.getPosition());
        CalculusFieldElement r2Sat = satToBody.getNormSq();
        return new FieldVector3D((CalculusFieldElement)parameters[0].divide((FieldElement)((CalculusFieldElement)r2Sat.multiply((FieldElement)((CalculusFieldElement)r2Sat.sqrt())))), satToBody);
    }
}

