/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.ForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class NewtonianAttraction
implements ForceModel {
    public static final String CENTRAL_ATTRACTION_COEFFICIENT = "central attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver gmParameterDriver;

    public NewtonianAttraction(double mu) {
        this.gmParameterDriver = new ParameterDriver(CENTRAL_ATTRACTION_COEFFICIENT, mu, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    public double getMu(AbsoluteDate date) {
        return this.gmParameterDriver.getValue(date);
    }

    public <T extends CalculusFieldElement<T>> T getMu(Field<T> field, FieldAbsoluteDate<T> date) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        return (T)((CalculusFieldElement)zero.newInstance(this.gmParameterDriver.getValue(date.toAbsoluteDate())));
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) {
        adder.addKeplerContribution(this.getMu(s.getDate()));
    }

    @Override
    public <T extends CalculusFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) {
        Field<T> field = s.getDate().getField();
        adder.addKeplerContribution(this.getMu(field, s.getDate()));
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double mu = parameters[0];
        double r2 = s.getPosition().getNormSq();
        return new Vector3D(-mu / (FastMath.sqrt((double)r2) * r2), s.getPosition());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        T mu = parameters[0];
        CalculusFieldElement r2 = s.getPosition().getNormSq();
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.sqrt()).multiply((FieldElement)r2)).reciprocal()).multiply(mu)).negate(), s.getPosition());
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.gmParameterDriver);
    }
}

