/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.utils.ParameterDriver;

public class J2OnlyPerturbation
implements ForceModel {
    private final double mu;
    private final double rEq;
    private final TimeScalarFunction j2OverTime;
    private final Frame frame;

    public J2OnlyPerturbation(double mu, double rEq, TimeScalarFunction j2OverTime, Frame frame) {
        this.mu = mu;
        this.rEq = rEq;
        this.j2OverTime = j2OverTime;
        this.frame = frame;
    }

    public J2OnlyPerturbation(double mu, double rEq, final double constantJ2, Frame frame) {
        this.mu = mu;
        this.rEq = rEq;
        this.frame = frame;
        this.j2OverTime = new TimeScalarFunction(){

            @Override
            public double value(AbsoluteDate date) {
                return constantJ2;
            }

            @Override
            public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                return (T)((CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(constantJ2));
            }
        };
    }

    public J2OnlyPerturbation(final UnnormalizedSphericalHarmonicsProvider harmonicsProvider, Frame frame) {
        this.mu = harmonicsProvider.getMu();
        this.rEq = harmonicsProvider.getAe();
        this.frame = frame;
        this.j2OverTime = new TimeScalarFunction(){

            @Override
            public double value(AbsoluteDate date) {
                return -harmonicsProvider.getUnnormalizedC20(date);
            }

            @Override
            public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                return (T)((CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(this.value(date.toAbsoluteDate())));
            }
        };
    }

    public double getMu() {
        return this.mu;
    }

    public double getrEq() {
        return this.rEq;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public double getJ2(AbsoluteDate date) {
        return this.j2OverTime.value(date);
    }

    public <T extends CalculusFieldElement<T>> T getJ2(FieldAbsoluteDate<T> date) {
        return this.j2OverTime.value(date);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    @Override
    public Vector3D acceleration(SpacecraftState state, double[] parameters) {
        AbsoluteDate date = state.getDate();
        StaticTransform fromPropagationToJ2Frame = state.getFrame().getStaticTransformTo(this.frame, date);
        Vector3D positionInJ2Frame = fromPropagationToJ2Frame.transformPosition(state.getPosition());
        double j2 = this.j2OverTime.value(date);
        Vector3D accelerationInJ2Frame = J2OnlyPerturbation.computeAccelerationInJ2Frame(positionInJ2Frame, this.mu, this.rEq, j2);
        StaticTransform fromJ2FrameToPropagationOne = fromPropagationToJ2Frame.getStaticInverse();
        return fromJ2FrameToPropagationOne.transformVector(accelerationInJ2Frame);
    }

    public static Vector3D computeAccelerationInJ2Frame(Vector3D positionInJ2Frame, double mu, double rEq, double j2) {
        double squaredRadius = positionInJ2Frame.getNormSq();
        double squaredZ = positionInJ2Frame.getZ() * positionInJ2Frame.getZ();
        double ratioTimesFive = 5.0 * squaredZ / squaredRadius;
        double ratioTimesFiveMinusOne = ratioTimesFive - 1.0;
        double componentX = positionInJ2Frame.getX() * ratioTimesFiveMinusOne;
        double componentY = positionInJ2Frame.getY() * ratioTimesFiveMinusOne;
        double componentZ = positionInJ2Frame.getZ() * (ratioTimesFive - 3.0);
        double squaredRadiiRatio = rEq * rEq / squaredRadius;
        double cubedRadius = squaredRadius * FastMath.sqrt((double)squaredRadius);
        double factor = 3.0 * j2 * mu * squaredRadiiRatio / (2.0 * cubedRadius);
        return new Vector3D(componentX, componentY, componentZ).scalarMultiply(factor);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> state, T[] parameters) {
        FieldAbsoluteDate<T> date = state.getDate();
        FieldStaticTransform<T> fromPropagationToJ2Frame = state.getFrame().getStaticTransformTo(this.frame, date);
        FieldVector3D<T> positionInJ2Frame = fromPropagationToJ2Frame.transformPosition(state.getPosition());
        FieldVector3D<T> accelerationInJ2Frame = J2OnlyPerturbation.computeAccelerationInJ2Frame(positionInJ2Frame, this.mu, this.rEq, this.j2OverTime.value(date));
        FieldStaticTransform<T> fromJ2FrameToPropagation = fromPropagationToJ2Frame.getStaticInverse();
        return fromJ2FrameToPropagation.transformVector(accelerationInJ2Frame);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> computeAccelerationInJ2Frame(FieldVector3D<T> positionInJ2Frame, double mu, double rEq, T j2) {
        CalculusFieldElement squaredRadius = positionInJ2Frame.getNormSq();
        CalculusFieldElement squaredZ = (CalculusFieldElement)positionInJ2Frame.getZ().square();
        CalculusFieldElement ratioTimesFive = (CalculusFieldElement)((CalculusFieldElement)squaredZ.multiply(5.0)).divide((FieldElement)squaredRadius);
        CalculusFieldElement ratioTimesFiveMinusOne = (CalculusFieldElement)ratioTimesFive.subtract(1.0);
        CalculusFieldElement componentX = (CalculusFieldElement)positionInJ2Frame.getX().multiply((FieldElement)ratioTimesFiveMinusOne);
        CalculusFieldElement componentY = (CalculusFieldElement)positionInJ2Frame.getY().multiply((FieldElement)ratioTimesFiveMinusOne);
        CalculusFieldElement componentZ = (CalculusFieldElement)positionInJ2Frame.getZ().multiply((FieldElement)((CalculusFieldElement)ratioTimesFive.subtract(3.0)));
        CalculusFieldElement squaredRadiiRatio = (CalculusFieldElement)((CalculusFieldElement)squaredRadius.reciprocal()).multiply(rEq * rEq);
        CalculusFieldElement cubedRadius = (CalculusFieldElement)squaredRadius.multiply((FieldElement)FastMath.sqrt((CalculusFieldElement)squaredRadius));
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)j2.multiply(mu)).multiply(3.0)).multiply((FieldElement)squaredRadiiRatio)).divide((FieldElement)((CalculusFieldElement)cubedRadius.multiply(2)));
        return new FieldVector3D(componentX, componentY, componentZ).scalarMultiply(factor);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

