/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractBodyAttraction
implements ForceModel {
    public static final String ATTRACTION_COEFFICIENT_SUFFIX = " attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final CelestialBody body;
    private final ParameterDriver gmParameterDriver;

    protected AbstractBodyAttraction(CelestialBody body) {
        this.body = body;
        this.gmParameterDriver = new ParameterDriver(body.getName() + ATTRACTION_COEFFICIENT_SUFFIX, body.getGM(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
    }

    public String getBodyName() {
        return this.body.getName();
    }

    @Deprecated
    protected CelestialBody getBody() {
        return this.body;
    }

    protected Vector3D getBodyPosition(AbsoluteDate date, Frame frame) {
        return this.body.getPosition(date, frame);
    }

    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getBodyPosition(FieldAbsoluteDate<T> date, Frame frame) {
        return this.body.getPosition(date, frame);
    }

    protected TimeStampedPVCoordinates getBodyPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.body.getPVCoordinates(date, frame);
    }

    protected <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getBodyPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        return this.body.getPVCoordinates(date, frame);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.gmParameterDriver);
    }
}

