/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.empirical;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.forces.ForceModel;
import org.orekit.forces.empirical.AccelerationModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class ParametricAcceleration
implements ForceModel {
    private final Vector3D direction;
    private final boolean isInertial;
    private final AttitudeProvider attitudeOverride;
    private final AccelerationModel accelerationModel;

    public ParametricAcceleration(Vector3D direction, boolean isInertial, AccelerationModel accelerationModel) {
        this(direction, isInertial, null, accelerationModel);
    }

    public ParametricAcceleration(Vector3D direction, AttitudeProvider attitudeOverride, AccelerationModel accelerationModel) {
        this(direction, false, attitudeOverride, accelerationModel);
    }

    private ParametricAcceleration(Vector3D direction, boolean isInertial, AttitudeProvider attitudeOverride, AccelerationModel accelerationModel) {
        this.direction = direction;
        this.isInertial = isInertial;
        this.attitudeOverride = attitudeOverride;
        this.accelerationModel = accelerationModel;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.isInertial;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.accelerationModel.getParametersDrivers();
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.accelerationModel.init(initialState, target);
    }

    @Override
    public Vector3D acceleration(SpacecraftState state, double[] parameters) {
        Vector3D inertialDirection;
        AbsoluteDate date = state.getDate();
        if (this.isInertial) {
            inertialDirection = this.direction;
        } else {
            Rotation rotation = this.attitudeOverride == null ? state.getAttitude().getRotation() : this.attitudeOverride.getAttitudeRotation(state.getOrbit(), date, state.getFrame());
            inertialDirection = rotation.applyInverseTo(this.direction);
        }
        return new Vector3D(this.accelerationModel.signedAmplitude(state, parameters), inertialDirection);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> state, T[] parameters) {
        FieldVector3D inertialDirection;
        FieldAbsoluteDate<T> date = state.getDate();
        if (this.isInertial) {
            inertialDirection = new FieldVector3D(date.getField(), this.direction);
        } else {
            FieldRotation<T> rotation = this.attitudeOverride == null ? state.getAttitude().getRotation() : this.attitudeOverride.getAttitudeRotation(state.getOrbit(), date, state.getFrame());
            inertialDirection = rotation.applyInverseTo(this.direction);
        }
        return new FieldVector3D(this.accelerationModel.signedAmplitude(state, (CalculusFieldElement[])parameters), inertialDirection);
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        return Stream.empty();
    }
}

