/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.forces.drag.AbstractDragForceModel;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.frames.Frame;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldDateDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

@Deprecated
public class TimeSpanDragForce
extends AbstractDragForceModel {
    public static final String DATE_BEFORE = " - Before ";
    public static final String DATE_AFTER = " - After ";
    private final TimeSpanMap<DragSensitive> dragSensitiveTimeSpanMap;
    private final TimeScale timeScale;

    @DefaultDataContext
    public TimeSpanDragForce(Atmosphere atmosphere, DragSensitive spacecraft) {
        super(atmosphere);
        this.dragSensitiveTimeSpanMap = new TimeSpanMap<DragSensitive>(spacecraft);
        this.timeScale = TimeScalesFactory.getUTC();
    }

    public TimeSpanDragForce(Atmosphere atmosphere, DragSensitive spacecraft, TimeScale timeScale) {
        super(atmosphere);
        this.dragSensitiveTimeSpanMap = new TimeSpanMap<DragSensitive>(spacecraft);
        this.timeScale = timeScale;
    }

    public void addDragSensitiveValidBefore(DragSensitive dragSensitive, AbsoluteDate latestValidityDate) {
        this.dragSensitiveTimeSpanMap.addValidBefore(this.changeDragParameterDriversNames(dragSensitive, latestValidityDate, DATE_BEFORE), latestValidityDate, false);
    }

    public void addDragSensitiveValidAfter(DragSensitive dragSensitive, AbsoluteDate earliestValidityDate) {
        this.dragSensitiveTimeSpanMap.addValidAfter(this.changeDragParameterDriversNames(dragSensitive, earliestValidityDate, DATE_AFTER), earliestValidityDate, false);
    }

    public DragSensitive getDragSensitive(AbsoluteDate date) {
        return this.dragSensitiveTimeSpanMap.get(date);
    }

    public TimeSpanMap.Span<DragSensitive> getDragSensitiveSpan(AbsoluteDate date) {
        return this.dragSensitiveTimeSpanMap.getSpan(date);
    }

    public TimeSpanMap<DragSensitive> extractDragSensitiveRange(AbsoluteDate start, AbsoluteDate end) {
        return this.dragSensitiveTimeSpanMap.extractRange(start, end);
    }

    public TimeSpanMap.Span<DragSensitive> getFirstSpan() {
        return this.dragSensitiveTimeSpanMap.getFirstSpan();
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPosition();
        double rho = this.getAtmosphere().getDensity(date, position, frame);
        Vector3D vAtm = this.getAtmosphere().getVelocity(date, position, frame);
        Vector3D relativeVelocity = vAtm.subtract((Vector)s.getPVCoordinates().getVelocity());
        double[] extractedParameters = this.extractParameters(parameters, date);
        return this.getDragSensitive(date).dragAcceleration(s, rho, relativeVelocity, extractedParameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        T rho = this.getFieldDensity(s);
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        FieldVector3D<T> position = s.getPosition();
        FieldVector3D<T> vAtm = this.getAtmosphere().getVelocity(date, position, frame);
        FieldVector3D relativeVelocity = vAtm.subtract(s.getPVCoordinates().getVelocity());
        CalculusFieldElement[] extractedParameters = this.extractParameters((CalculusFieldElement[])parameters, date);
        return this.getDragSensitive(date.toAbsoluteDate()).dragAcceleration(s, (CalculusFieldElement)rho, relativeVelocity, extractedParameters);
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        AbsoluteDate[] transitionDates = this.getTransitionDates();
        DateDetector datesDetector = (DateDetector)((DateDetector)new DateDetector(transitionDates[0]).withMaxCheck(60.0)).withHandler((state, detector, increasing) -> Action.RESET_DERIVATIVES);
        for (int i = 1; i < transitionDates.length; ++i) {
            datesDetector.addEventDate(transitionDates[i]);
        }
        return Stream.of(datesDetector);
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        AbsoluteDate[] transitionDates = this.getTransitionDates();
        FieldDateDetector datesDetector = (FieldDateDetector)((FieldDateDetector)new FieldDateDetector<T>(field, (FieldTimeStamped[])Array.newInstance(FieldTimeStamped.class, 0)).withMaxCheck(60.0)).withHandler((state, detector, increasing) -> Action.RESET_DERIVATIVES);
        for (int i = 0; i < transitionDates.length; ++i) {
            datesDetector.addEventDate(new FieldAbsoluteDate<T>(field, transitionDates[i]));
        }
        return Stream.of(datesDetector);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        ArrayList<ParameterDriver> listParameterDrivers = new ArrayList<ParameterDriver>();
        for (TimeSpanMap.Span<DragSensitive> span = this.getFirstSpan(); span != null; span = span.next()) {
            for (ParameterDriver driver : span.getData().getDragParametersDrivers()) {
                if (this.findByName(listParameterDrivers, driver.getName())) continue;
                listParameterDrivers.add(driver);
            }
        }
        return listParameterDrivers;
    }

    public double[] extractParameters(double[] parameters, AbsoluteDate date) {
        List<ParameterDriver> dragParameterDriver = this.getDragSensitive(date).getDragParametersDrivers();
        List<ParameterDriver> allParameters = this.getParametersDrivers();
        double[] outParameters = new double[dragParameterDriver.size()];
        int index = 0;
        for (int i = 0; i < allParameters.size(); ++i) {
            String driverName = allParameters.get(i).getName();
            for (ParameterDriver dragDriver : dragParameterDriver) {
                if (!dragDriver.getName().equals(driverName)) continue;
                outParameters[index++] = parameters[i];
            }
        }
        return outParameters;
    }

    public <T extends CalculusFieldElement<T>> T[] extractParameters(T[] parameters, FieldAbsoluteDate<T> date) {
        List<ParameterDriver> dragPD = this.getDragSensitive(date.toAbsoluteDate()).getDragParametersDrivers();
        List<ParameterDriver> allParameters = this.getParametersDrivers();
        CalculusFieldElement[] outParameters = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)dragPD.size());
        int index = 0;
        for (int i = 0; i < allParameters.size(); ++i) {
            String driverName = allParameters.get(i).getName();
            for (ParameterDriver dragDriver : dragPD) {
                if (!dragDriver.getName().equals(driverName)) continue;
                outParameters[index++] = parameters[i];
            }
        }
        return outParameters;
    }

    private boolean findByName(List<ParameterDriver> driversList, String name) {
        for (ParameterDriver d : driversList) {
            if (!d.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private AbsoluteDate[] getTransitionDates() {
        ArrayList<AbsoluteDate> listDates = new ArrayList<AbsoluteDate>();
        for (TimeSpanMap.Transition<DragSensitive> transition = this.getFirstSpan().getEndTransition(); transition != null; transition = transition.next()) {
            listDates.add(transition.getDate());
        }
        return listDates.toArray(new AbsoluteDate[0]);
    }

    private DragSensitive changeDragParameterDriversNames(DragSensitive dragSensitive, AbsoluteDate date, String datePrefix) {
        for (ParameterDriver driver : dragSensitive.getDragParametersDrivers()) {
            String driverName = driver.getName();
            if (!driverName.equals("global drag factor") && !driverName.equals("drag coefficient") && !driverName.equals("lift ratio")) continue;
            driver.setName(driverName + datePrefix + date.toString(this.timeScale));
        }
        return dragSensitive;
    }
}

