/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class IsotropicDrag
implements DragSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final List<ParameterDriver> dragParametersDrivers = new ArrayList<ParameterDriver>(2);
    private final double crossSection;

    public IsotropicDrag(double crossSection, double dragCoeff) {
        this(crossSection, dragCoeff, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public IsotropicDrag(double crossSection, double dragCoeff, double dragCoeffMin, double dragCoeffMax) {
        this.dragParametersDrivers.add(new ParameterDriver("global drag factor", 1.0, this.SCALE, 0.0, Double.POSITIVE_INFINITY));
        this.dragParametersDrivers.add(new ParameterDriver("drag coefficient", dragCoeff, this.SCALE, dragCoeffMin, dragCoeffMax));
        this.crossSection = crossSection;
    }

    @Override
    public List<ParameterDriver> getDragParametersDrivers() {
        return Collections.unmodifiableList(this.dragParametersDrivers);
    }

    @Override
    public Vector3D dragAcceleration(SpacecraftState state, double density, Vector3D relativeVelocity, double[] parameters) {
        double dragCoeff = parameters[0] * parameters[1];
        return new Vector3D(relativeVelocity.getNorm() * density * dragCoeff * this.crossSection / (2.0 * state.getMass()), relativeVelocity);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> dragAcceleration(FieldSpacecraftState<T> state, T density, FieldVector3D<T> relativeVelocity, T[] parameters) {
        CalculusFieldElement dragCoeff = (CalculusFieldElement)parameters[0].multiply(parameters[1]);
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)relativeVelocity.getNorm().multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)density.multiply((FieldElement)dragCoeff)).multiply(this.crossSection / 2.0)))).divide(state.getMass()), relativeVelocity);
    }
}

