/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.drag.AbstractDragForceModel;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.frames.Frame;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class DragForce
extends AbstractDragForceModel {
    private final DragSensitive spacecraft;

    public DragForce(Atmosphere atmosphere, DragSensitive spacecraft) {
        super(atmosphere);
        this.spacecraft = spacecraft;
    }

    public DragForce(Atmosphere atmosphere, DragSensitive spacecraft, boolean useFiniteDifferencesOnDensityWrtPosition) {
        super(atmosphere, useFiniteDifferencesOnDensityWrtPosition);
        this.spacecraft = spacecraft;
    }

    @Override
    public boolean dependsOnAttitudeRate() {
        return this.getSpacecraft().dependsOnAttitudeRate();
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPosition();
        double rho = this.getAtmosphere().getDensity(date, position, frame);
        Vector3D vAtm = this.getAtmosphere().getVelocity(date, position, frame);
        Vector3D relativeVelocity = vAtm.subtract((Vector)s.getPVCoordinates().getVelocity());
        return this.spacecraft.dragAcceleration(s, rho, relativeVelocity, parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        T rho = this.getFieldDensity(s);
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        FieldVector3D<T> position = s.getPosition();
        FieldVector3D<T> vAtm = this.getAtmosphere().getVelocity(date, position, frame);
        FieldVector3D relativeVelocity = vAtm.subtract(s.getPVCoordinates().getVelocity());
        return this.spacecraft.dragAcceleration(s, (CalculusFieldElement)rho, relativeVelocity, (CalculusFieldElement[])parameters);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.spacecraft.getDragParametersDrivers();
    }

    public DragSensitive getSpacecraft() {
        return this.spacecraft;
    }
}

