/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.forces.Panel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;

public class SlewingPanel
extends Panel {
    private final double rotationRate;
    private final AbsoluteDate referenceDate;
    private final Vector3D rX;
    private final Vector3D rY;

    public SlewingPanel(Vector3D rotationAxis, double rotationRate, AbsoluteDate referenceDate, Vector3D referenceNormal, double area, double drag, double liftRatio, double absorption, double reflection) {
        super(area, true, drag, liftRatio, absorption, reflection);
        this.rotationRate = rotationRate;
        this.referenceDate = referenceDate;
        this.rY = (Vector3D)Vector3D.crossProduct((Vector3D)rotationAxis, (Vector3D)referenceNormal).normalize();
        this.rX = (Vector3D)Vector3D.crossProduct((Vector3D)this.rY, (Vector3D)rotationAxis).normalize();
    }

    @Override
    public Vector3D getNormal(SpacecraftState state) {
        SinCos sc = FastMath.sinCos((double)(state.getDate().durationFrom(this.referenceDate) * this.rotationRate));
        return new Vector3D(sc.cos(), this.rX, sc.sin(), this.rY);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getNormal(FieldSpacecraftState<T> state) {
        FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)state.getDate().durationFrom(this.referenceDate).multiply(this.rotationRate)));
        return new FieldVector3D((CalculusFieldElement)sc.cos(), this.rX, (CalculusFieldElement)sc.sin(), this.rY);
    }
}

