/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.forces.Panel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ExtendedPVCoordinatesProvider;

public class PointingPanel
extends Panel {
    private final Vector3D rotationAxis;
    private final ExtendedPVCoordinatesProvider target;

    public PointingPanel(Vector3D rotationAxis, ExtendedPVCoordinatesProvider target, double area, double drag, double liftRatio, double absorption, double reflection) {
        super(area, true, drag, liftRatio, absorption, reflection);
        this.rotationAxis = (Vector3D)rotationAxis.normalize();
        this.target = target;
    }

    @Override
    public Vector3D getNormal(SpacecraftState state) {
        Vector3D targetInert = (Vector3D)this.target.getPosition(state.getDate(), state.getFrame()).subtract((Vector)state.getPosition()).normalize();
        Vector3D targetSpacecraft = state.getAttitude().getRotation().applyTo(targetInert);
        double d = Vector3D.dotProduct((Vector3D)targetSpacecraft, (Vector3D)this.rotationAxis);
        double f = 1.0 - d * d;
        if (f < Precision.EPSILON) {
            return this.rotationAxis.orthogonal();
        }
        double s = 1.0 / FastMath.sqrt((double)f);
        return new Vector3D(s, targetSpacecraft, -s * d, this.rotationAxis);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getNormal(FieldSpacecraftState<T> state) {
        FieldVector3D targetInert = this.target.getPosition(state.getDate(), state.getFrame()).subtract(state.getPosition()).normalize();
        FieldVector3D targetSpacecraft = state.getAttitude().getRotation().applyTo(targetInert);
        CalculusFieldElement d = FieldVector3D.dotProduct((FieldVector3D)targetSpacecraft, (Vector3D)this.rotationAxis);
        CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)d.multiply((FieldElement)d)).subtract(1.0)).negate();
        if (f.getReal() < Precision.EPSILON) {
            return new FieldVector3D(f.getField(), this.rotationAxis.orthogonal());
        }
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)f.sqrt()).reciprocal();
        return new FieldVector3D(s, targetSpacecraft, (CalculusFieldElement)((CalculusFieldElement)s.multiply((FieldElement)d)).negate(), new FieldVector3D(state.getDate().getField(), this.rotationAxis));
    }
}

