/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.EventDetectorsProvider;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriversProvider;

public interface ForceModel
extends ParameterDriversProvider,
EventDetectorsProvider {
    default public void init(SpacecraftState initialState, AbsoluteDate target) {
    }

    default public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.init(initialState.toSpacecraftState(), target.toAbsoluteDate());
    }

    @Override
    default public Stream<EventDetector> getEventDetectors() {
        return this.getEventDetectors(this.getParametersDrivers());
    }

    @Override
    default public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        return this.getFieldEventDetectors(field, this.getParametersDrivers());
    }

    default public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) {
        adder.addNonKeplerianAcceleration(this.acceleration(s, this.getParameters(s.getDate())));
    }

    default public <T extends CalculusFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) {
        adder.addNonKeplerianAcceleration(this.acceleration(s, this.getParameters(s.getDate().getField(), s.getDate())));
    }

    public boolean dependsOnPositionOnly();

    default public boolean dependsOnAttitudeRate() {
        return false;
    }

    public Vector3D acceleration(SpacecraftState var1, double[] var2);

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> var1, T[] var2);
}

