/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.FixedPanel;
import org.orekit.forces.Panel;
import org.orekit.forces.PointingPanel;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class BoxAndSolarArraySpacecraft
implements RadiationSensitive,
DragSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final ParameterDriver dragFactorParameterDriver;
    private final ParameterDriver radiationFactorParameterDriver;
    private final List<Panel> panels;

    public BoxAndSolarArraySpacecraft(List<Panel> panels) {
        try {
            this.dragFactorParameterDriver = new ParameterDriver("global drag factor", 1.0, this.SCALE, 0.0, Double.POSITIVE_INFINITY);
            this.radiationFactorParameterDriver = new ParameterDriver("global radiation factor", 1.0, this.SCALE, 0.0, Double.POSITIVE_INFINITY);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
        this.panels = panels.stream().filter(p -> p.getArea() > 0.0).collect(Collectors.toList());
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, ExtendedPVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.buildPanels(xLength, yLength, zLength, sun, solarArrayArea, solarArrayAxis, dragCoeff, liftRatio, absorptionCoeff, reflectionCoeff));
    }

    public List<Panel> getPanels() {
        return Collections.unmodifiableList(this.panels);
    }

    @Override
    public List<ParameterDriver> getDragParametersDrivers() {
        return Collections.singletonList(this.dragFactorParameterDriver);
    }

    @Override
    public List<ParameterDriver> getRadiationParametersDrivers() {
        return Collections.singletonList(this.radiationFactorParameterDriver);
    }

    @Override
    public Vector3D dragAcceleration(SpacecraftState state, double density, Vector3D relativeVelocity, double[] parameters) {
        double dragFactor = parameters[0];
        double vNorm2 = relativeVelocity.getNormSq();
        double vNorm = FastMath.sqrt((double)vNorm2);
        Vector3D vDir = state.getAttitude().getRotation().applyTo(relativeVelocity.scalarMultiply(1.0 / vNorm));
        double coeff = density * dragFactor * vNorm2 / (2.0 * state.getMass());
        Vector3D acceleration = Vector3D.ZERO;
        for (Panel panel : this.panels) {
            Vector3D normal = panel.getNormal(state);
            double dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)vDir);
            if (panel.isDoubleSided() && dot > 0.0) {
                normal = normal.negate();
                dot = -dot;
            }
            if (!(dot < 0.0)) continue;
            double f = coeff * panel.getDrag() * panel.getArea() * dot;
            double liftRatio = panel.getLiftRatio();
            acceleration = new Vector3D(1.0, acceleration, (1.0 - liftRatio) * FastMath.abs((double)f), vDir, liftRatio * f * 2.0, normal);
        }
        return state.getAttitude().getRotation().applyInverseTo(acceleration);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> dragAcceleration(FieldSpacecraftState<T> state, T density, FieldVector3D<T> relativeVelocity, T[] parameters) {
        Field<T> field = state.getDate().getField();
        T dragFactor = parameters[0];
        CalculusFieldElement vNorm2 = relativeVelocity.getNormSq();
        CalculusFieldElement vNorm = FastMath.sqrt((CalculusFieldElement)vNorm2);
        FieldVector3D vDir = state.getAttitude().getRotation().applyTo(relativeVelocity.scalarMultiply((CalculusFieldElement)vNorm.reciprocal()));
        CalculusFieldElement coeff = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)density.multiply(dragFactor)).multiply((FieldElement)vNorm2)).divide((FieldElement)((CalculusFieldElement)state.getMass().multiply(2.0)));
        FieldVector3D acceleration = FieldVector3D.getZero(field);
        for (Panel panel : this.panels) {
            FieldVector3D normal = panel.getNormal(state);
            CalculusFieldElement dot = FieldVector3D.dotProduct(normal, (FieldVector3D)vDir);
            if (panel.isDoubleSided() && dot.getReal() > 0.0) {
                normal = normal.negate();
                dot = (CalculusFieldElement)dot.negate();
            }
            if (!panel.isDoubleSided() && !(dot.getReal() < 0.0)) continue;
            CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)coeff.multiply(panel.getDrag() * panel.getArea())).multiply((FieldElement)dot);
            double liftRatio = panel.getLiftRatio();
            acceleration = new FieldVector3D((CalculusFieldElement)field.getOne(), acceleration, (CalculusFieldElement)FastMath.abs((CalculusFieldElement)f).multiply(1.0 - liftRatio), vDir, (CalculusFieldElement)f.multiply(2.0 * liftRatio), normal);
        }
        return state.getAttitude().getRotation().applyInverseTo(acceleration);
    }

    @Override
    public Vector3D radiationPressureAcceleration(SpacecraftState state, Vector3D flux, double[] parameters) {
        if (flux.getNormSq() < Precision.SAFE_MIN) {
            return Vector3D.ZERO;
        }
        double radiationFactor = parameters[0];
        Vector3D fluxSat = state.getAttitude().getRotation().applyTo(flux).scalarMultiply(radiationFactor);
        Vector3D force = Vector3D.ZERO;
        for (Panel panel : this.panels) {
            Vector3D normal = panel.getNormal(state);
            double dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
            if (panel.isDoubleSided() && dot > 0.0) {
                normal = normal.negate();
                dot = -dot;
            }
            if (!(dot < 0.0)) continue;
            double absorptionCoeff = panel.getAbsorption();
            double specularReflectionCoeff = panel.getReflection();
            double diffuseReflectionCoeff = 1.0 - (absorptionCoeff + specularReflectionCoeff);
            double psr = fluxSat.getNorm();
            double cN = 2.0 * panel.getArea() * dot * (diffuseReflectionCoeff / 3.0 - specularReflectionCoeff * dot / psr);
            double cS = panel.getArea() * dot / psr * (specularReflectionCoeff - 1.0);
            force = new Vector3D(1.0, force, cN, normal, cS, fluxSat);
        }
        return state.getAttitude().getRotation().applyInverseTo(new Vector3D(1.0 / state.getMass(), force));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldSpacecraftState<T> state, FieldVector3D<T> flux, T[] parameters) {
        Field<T> field = state.getDate().getField();
        if (flux.getNormSq().getReal() < Precision.SAFE_MIN) {
            return FieldVector3D.getZero(field);
        }
        T radiationFactor = parameters[0];
        FieldVector3D fluxSat = state.getAttitude().getRotation().applyTo(flux).scalarMultiply(radiationFactor);
        FieldVector3D force = FieldVector3D.getZero(field);
        for (Panel panel : this.panels) {
            FieldVector3D normal = panel.getNormal(state);
            CalculusFieldElement dot = FieldVector3D.dotProduct(normal, (FieldVector3D)fluxSat);
            if (panel.isDoubleSided() && dot.getReal() > 0.0) {
                normal = normal.negate();
                dot = (CalculusFieldElement)dot.negate();
            }
            if (!(dot.getReal() < 0.0)) continue;
            double absorptionCoeff = panel.getAbsorption();
            double specularReflectionCoeff = panel.getReflection();
            double diffuseReflectionCoeff = 1.0 - (absorptionCoeff + specularReflectionCoeff);
            CalculusFieldElement psr = fluxSat.getNorm();
            CalculusFieldElement cN = (CalculusFieldElement)((CalculusFieldElement)dot.multiply(-2.0 * panel.getArea())).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dot.multiply(specularReflectionCoeff)).divide((FieldElement)psr)).subtract(diffuseReflectionCoeff / 3.0)));
            CalculusFieldElement cS = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dot.multiply(panel.getArea())).multiply(specularReflectionCoeff - 1.0)).divide((FieldElement)psr);
            force = new FieldVector3D((CalculusFieldElement)field.getOne(), force, cN, normal, cS, fluxSat);
        }
        return state.getAttitude().getRotation().applyInverseTo(new FieldVector3D((CalculusFieldElement)state.getMass().reciprocal(), force));
    }

    public static List<Panel> buildBox(double xLength, double yLength, double zLength, double drag, double liftRatio, double absorption, double reflection) {
        ArrayList<Panel> panels = new ArrayList<Panel>(6);
        panels.add(new FixedPanel(Vector3D.MINUS_I, yLength * zLength, false, drag, liftRatio, absorption, reflection));
        panels.add(new FixedPanel(Vector3D.PLUS_I, yLength * zLength, false, drag, liftRatio, absorption, reflection));
        panels.add(new FixedPanel(Vector3D.MINUS_J, xLength * zLength, false, drag, liftRatio, absorption, reflection));
        panels.add(new FixedPanel(Vector3D.PLUS_J, xLength * zLength, false, drag, liftRatio, absorption, reflection));
        panels.add(new FixedPanel(Vector3D.MINUS_K, xLength * yLength, false, drag, liftRatio, absorption, reflection));
        panels.add(new FixedPanel(Vector3D.PLUS_K, xLength * yLength, false, drag, liftRatio, absorption, reflection));
        return panels;
    }

    public static List<Panel> buildPanels(double xLength, double yLength, double zLength, ExtendedPVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double drag, double liftRatio, double absorption, double reflection) {
        List<Panel> panels = BoxAndSolarArraySpacecraft.buildBox(xLength, yLength, zLength, drag, liftRatio, absorption, reflection);
        panels.add(new PointingPanel(solarArrayAxis, sun, solarArrayArea, drag, liftRatio, absorption, reflection));
        return panels;
    }
}

