/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.stk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class STKEphemerisFile
implements EphemerisFile<TimeStampedPVCoordinates, STKEphemerisSegment> {
    private final String stkVersion;
    private final Map<String, STKEphemeris> satellites;

    public STKEphemerisFile(String stkVersion, String satelliteId, STKEphemeris ephemeris) {
        this.stkVersion = Objects.requireNonNull(stkVersion);
        HashMap<String, STKEphemeris> tempMap = new HashMap<String, STKEphemeris>();
        tempMap.put(satelliteId, ephemeris);
        this.satellites = Collections.unmodifiableMap(tempMap);
    }

    public String getSTKVersion() {
        return this.stkVersion;
    }

    @Override
    public Map<String, STKEphemeris> getSatellites() {
        return this.satellites;
    }

    public static enum STKCoordinateSystem {
        ICRF,
        J2000,
        INERTIAL,
        FIXED,
        TRUE_OF_DATE,
        MEAN_OF_DATE,
        TEME_OF_DATE;


        public static STKCoordinateSystem parse(String s) {
            String sUpper;
            switch (sUpper = s.toUpperCase(Locale.US)) {
                case "ICRF": {
                    return ICRF;
                }
                case "J2000": {
                    return J2000;
                }
                case "INERTIAL": {
                    return INERTIAL;
                }
                case "FIXED": {
                    return FIXED;
                }
                case "TRUEOFDATE": {
                    return TRUE_OF_DATE;
                }
                case "MEANOFDATE": {
                    return MEAN_OF_DATE;
                }
                case "TEMEOFDATE": {
                    return TEME_OF_DATE;
                }
            }
            throw new OrekitException((Localizable)OrekitMessages.STK_INVALID_OR_UNSUPPORTED_COORDINATE_SYSTEM, s);
        }
    }

    public static class STKEphemeris
    implements EphemerisFile.SatelliteEphemeris<TimeStampedPVCoordinates, STKEphemerisSegment> {
        private final String satelliteId;
        private final double mu;
        private final List<STKEphemerisSegment> segments;

        public STKEphemeris(String satelliteId, double mu, List<STKEphemerisSegment> segments) {
            this.satelliteId = Objects.requireNonNull(satelliteId);
            this.mu = mu;
            this.segments = Collections.unmodifiableList(new ArrayList<STKEphemerisSegment>(segments));
        }

        @Override
        public String getId() {
            return this.satelliteId;
        }

        @Override
        public double getMu() {
            return this.mu;
        }

        @Override
        public List<STKEphemerisSegment> getSegments() {
            return this.segments;
        }

        @Override
        public AbsoluteDate getStart() {
            return this.segments.get(0).getStart();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.segments.get(this.segments.size() - 1).getStop();
        }
    }

    public static class STKEphemerisSegment
    implements EphemerisFile.EphemerisSegment<TimeStampedPVCoordinates> {
        private final double mu;
        private final Frame frame;
        private final int interpolationSamples;
        private final CartesianDerivativesFilter cartesianDerivativesFilter;
        private final List<TimeStampedPVCoordinates> timeStampedPVCoordinates;

        public STKEphemerisSegment(double mu, Frame frame, int interpolationSamples, CartesianDerivativesFilter cartesianDerivativesFilter, List<TimeStampedPVCoordinates> timeStampedPVCoordinates) {
            this.mu = mu;
            this.frame = Objects.requireNonNull(frame);
            this.interpolationSamples = interpolationSamples;
            this.cartesianDerivativesFilter = Objects.requireNonNull(cartesianDerivativesFilter);
            this.timeStampedPVCoordinates = Collections.unmodifiableList(new ArrayList<TimeStampedPVCoordinates>(timeStampedPVCoordinates));
        }

        @Override
        public double getMu() {
            return this.mu;
        }

        @Override
        public Frame getFrame() {
            return this.frame;
        }

        @Override
        public int getInterpolationSamples() {
            return this.interpolationSamples;
        }

        @Override
        public CartesianDerivativesFilter getAvailableDerivatives() {
            return this.cartesianDerivativesFilter;
        }

        @Override
        public List<TimeStampedPVCoordinates> getCoordinates() {
            return this.timeStampedPVCoordinates;
        }

        @Override
        public AbsoluteDate getStart() {
            return this.timeStampedPVCoordinates.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.timeStampedPVCoordinates.get(this.timeStampedPVCoordinates.size() - 1).getDate();
        }
    }
}

