/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import org.hipparchus.util.FastMath;
import org.orekit.utils.units.Unit;

public class SP3Utils {
    public static final double DEFAULT_CLOCK_VALUE = 999999.999999;
    public static final double DEFAULT_CLOCK_RATE_VALUE = 999999.999999;
    public static final double POS_VEL_BASE_ACCURACY = 2.0;
    public static final Unit POSITION_UNIT = Unit.parse("km");
    public static final Unit POSITION_ACCURACY_UNIT = Unit.parse("mm");
    public static final Unit VELOCITY_UNIT = Unit.parse("dm/s");
    public static final Unit VELOCITY_ACCURACY_UNIT = Unit.parse("mm/s").scale("10\u207b\u2074mm/s", 1.0E-4);
    public static final String CLOCK_ADDITIONAL_STATE = "clock";
    public static final Unit CLOCK_UNIT = Unit.parse("\u00b5s");
    public static final Unit CLOCK_ACCURACY_UNIT = Unit.parse("ps");
    public static final Unit CLOCK_RATE_UNIT = Unit.parse("\u00b5s/s").scale("10\u207b\u2074\u00b5s/s", 1.0E-4);
    public static final Unit CLOCK_RATE_ACCURACY_UNIT = Unit.parse("ps/s").scale("10\u207b\u2074ps/s", 1.0E-4);

    private SP3Utils() {
    }

    public static double siAccuracy(Unit unit, double base, int accuracyIndex) {
        return unit.toSI(FastMath.pow((double)base, (int)accuracyIndex));
    }

    public static int indexAccuracy(Unit unit, double base, double accuracy) {
        return (int)FastMath.ceil((double)(FastMath.log((double)unit.fromSI(accuracy)) / FastMath.log((double)base)));
    }
}

