/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.general.EphemerisSegmentPropagator;
import org.orekit.files.sp3.SP3Coordinate;
import org.orekit.frames.Frame;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ClockModel;
import org.orekit.time.ClockOffset;
import org.orekit.time.SampledClockModel;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.SortedListTrimmer;

public class SP3Segment
implements EphemerisFile.EphemerisSegment<SP3Coordinate> {
    private final double mu;
    private final Frame frame;
    private final int interpolationSamples;
    private final CartesianDerivativesFilter filter;
    private final List<SP3Coordinate> coordinates;

    public SP3Segment(double mu, Frame frame, int interpolationSamples, CartesianDerivativesFilter filter) {
        this.mu = mu;
        this.frame = frame;
        this.interpolationSamples = interpolationSamples;
        this.filter = filter;
        this.coordinates = new ArrayList<SP3Coordinate>();
    }

    public ClockModel extractClockModel() {
        ArrayList<ClockOffset> sample = new ArrayList<ClockOffset>(this.coordinates.size());
        this.coordinates.forEach(c -> {
            AbsoluteDate date = c.getDate();
            double offset = c.getClockCorrection();
            if (!Double.isNaN(offset)) {
                double rate = this.filter.getMaxOrder() > 0 ? c.getClockRateChange() : Double.NaN;
                sample.add(new ClockOffset(date, offset, rate, Double.NaN));
            }
        });
        return new SampledClockModel(sample, this.interpolationSamples);
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public AbsoluteDate getStart() {
        return this.coordinates.get(0).getDate();
    }

    @Override
    public AbsoluteDate getStop() {
        return this.coordinates.get(this.coordinates.size() - 1).getDate();
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public int getInterpolationSamples() {
        return this.interpolationSamples;
    }

    @Override
    public CartesianDerivativesFilter getAvailableDerivatives() {
        return this.filter;
    }

    @Override
    public List<SP3Coordinate> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public void addCoordinate(SP3Coordinate coord) {
        this.coordinates.add(coord);
    }

    @Override
    public BoundedPropagator getPropagator() {
        return new PropagatorWithClock((AttitudeProvider)new FrameAlignedProvider(this.getInertialFrame()));
    }

    @Override
    public BoundedPropagator getPropagator(AttitudeProvider attitudeProvider) {
        return new PropagatorWithClock(attitudeProvider);
    }

    private class PropagatorWithClock
    extends EphemerisSegmentPropagator<SP3Coordinate> {
        private final SortedListTrimmer trimmer;

        PropagatorWithClock(AttitudeProvider attitudeProvider) {
            super(SP3Segment.this, attitudeProvider);
            this.trimmer = new SortedListTrimmer(SP3Segment.this.getInterpolationSamples());
        }

        @Override
        protected SpacecraftState updateAdditionalStates(SpacecraftState original) {
            HermiteInterpolator interpolator = new HermiteInterpolator();
            this.trimmer.getNeighborsSubList(original.getDate(), SP3Segment.this.coordinates).forEach(c -> {
                double deltaT = c.getDate().durationFrom(original.getDate());
                if (SP3Segment.this.filter.getMaxOrder() < 1) {
                    interpolator.addSamplePoint(deltaT, (double[][])new double[][]{{c.getClockCorrection()}});
                } else {
                    interpolator.addSamplePoint(deltaT, (double[][])new double[][]{{c.getClockCorrection()}, {c.getClockRateChange()}});
                }
            });
            double[][] derivatives = interpolator.derivatives(0.0, 1);
            return super.updateAdditionalStates(original).addAdditionalState("clock", derivatives[0]).addAdditionalStateDerivative("clock", derivatives[1]);
        }
    }
}

