/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFileParser;
import org.orekit.files.sp3.DataUsed;
import org.orekit.files.sp3.SP3;
import org.orekit.files.sp3.SP3Coordinate;
import org.orekit.files.sp3.SP3FileType;
import org.orekit.files.sp3.SP3Header;
import org.orekit.files.sp3.SP3Utils;
import org.orekit.frames.Frame;
import org.orekit.gnss.IGSUtils;
import org.orekit.gnss.TimeSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.utils.CartesianDerivativesFilter;

public class SP3Parser
implements EphemerisFileParser<SP3> {
    @Deprecated
    public static final String SP3_FRAME_CENTER_STRING = "EARTH";
    private static final String SPACES = "\\s+";
    private final double mu;
    private final int interpolationSamples;
    private final Function<? super String, ? extends Frame> frameBuilder;
    private final TimeScales timeScales;

    @DefaultDataContext
    public SP3Parser() {
        this(3.986004415E14, 7, IGSUtils::guessFrame);
    }

    @DefaultDataContext
    public SP3Parser(double mu, int interpolationSamples, Function<? super String, ? extends Frame> frameBuilder) {
        this(mu, interpolationSamples, frameBuilder, DataContext.getDefault().getTimeScales());
    }

    public SP3Parser(double mu, int interpolationSamples, Function<? super String, ? extends Frame> frameBuilder, TimeScales timeScales) {
        this.mu = mu;
        this.interpolationSamples = interpolationSamples;
        this.frameBuilder = frameBuilder;
        this.timeScales = timeScales;
    }

    @Deprecated
    @DefaultDataContext
    public static Frame guessFrame(String name) {
        return IGSUtils.guessFrame(name);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public SP3 parse(DataSource source) {
        try (Reader reader = source.getOpener().openReaderOnce();){
            SP3 sP3;
            block20: {
                BufferedReader br = reader == null ? null : new BufferedReader(reader);
                try {
                    if (br == null) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, source.getName());
                    }
                    ParseInfo pi = new ParseInfo(source.getName(), this);
                    int lineNumber = 0;
                    Iterable<LineParser> candidateParsers = Collections.singleton(LineParser.HEADER_VERSION);
                    String line = br.readLine();
                    block14: while (line != null) {
                        block19: {
                            ++lineNumber;
                            for (LineParser candidate : candidateParsers) {
                                if (!candidate.canHandle(line)) continue;
                                try {
                                    candidate.parse(line, pi);
                                    if (pi.done) break block14;
                                    candidateParsers = candidate.allowedNext();
                                    break block19;
                                }
                                catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                                    throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, pi.fileName, line);
                                }
                            }
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, pi.fileName, line);
                        }
                        line = br.readLine();
                    }
                    pi.file.validate(true, pi.fileName);
                    sP3 = pi.file;
                    if (br == null) break block20;
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                br.close();
            }
            return sP3;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getLocalizedMessage());
        }
    }

    private static enum LineParser {
        HEADER_VERSION("^#[a-z].*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                try (Scanner s1 = new Scanner(line);
                     Scanner s2 = s1.useDelimiter(SP3Parser.SPACES);
                     Scanner scanner = s2.useLocale(Locale.US);){
                    scanner.skip("#");
                    String v = scanner.next();
                    SP3Header header = new SP3Header();
                    header.setVersion(v.substring(0, 1).toLowerCase().charAt(0));
                    pi.hasVelocityEntries = "V".equals(v.substring(1, 2));
                    header.setFilter(pi.hasVelocityEntries ? CartesianDerivativesFilter.USE_PV : CartesianDerivativesFilter.USE_P);
                    int year = Integer.parseInt(v.substring(2));
                    int month = scanner.nextInt();
                    int day = scanner.nextInt();
                    int hour = scanner.nextInt();
                    int minute = scanner.nextInt();
                    double second = scanner.nextDouble();
                    pi.epoch = new DateTimeComponents(year, month, day, hour, minute, second);
                    int numEpochs = scanner.nextInt();
                    header.setNumberOfEpochs(numEpochs);
                    String fullSpec = scanner.next();
                    ArrayList<DataUsed> dataUsed = new ArrayList<DataUsed>();
                    for (String specifier : fullSpec.split("\\+")) {
                        dataUsed.add(DataUsed.parse(specifier, pi.fileName, header.getVersion()));
                    }
                    header.setDataUsed(dataUsed);
                    header.setCoordinateSystem(scanner.next());
                    header.setOrbitTypeKey(scanner.next());
                    header.setAgency(scanner.hasNext() ? scanner.next() : "");
                    pi.file = new SP3(header, pi.parser.mu, pi.parser.interpolationSamples, (Frame)pi.parser.frameBuilder.apply(header.getCoordinateSystem()));
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Collections.singleton(HEADER_DATE_TIME_REFERENCE);
            }
        }
        ,
        HEADER_DATE_TIME_REFERENCE("^##.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                try (Scanner s1 = new Scanner(line);
                     Scanner s2 = s1.useDelimiter(SP3Parser.SPACES);
                     Scanner scanner = s2.useLocale(Locale.US);){
                    scanner.skip("##");
                    pi.file.getHeader().setGpsWeek(scanner.nextInt());
                    pi.file.getHeader().setSecondsOfWeek(scanner.nextDouble());
                    pi.file.getHeader().setEpochInterval(scanner.nextDouble());
                    pi.file.getHeader().setModifiedJulianDay(scanner.nextInt());
                    pi.file.getHeader().setDayFraction(scanner.nextDouble());
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Collections.singleton(HEADER_SAT_IDS);
            }
        }
        ,
        HEADER_SAT_IDS("^\\+ .*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                if (pi.maxSatellites == 0) {
                    pi.maxSatellites = Integer.parseInt(line.substring(3, 6).trim());
                }
                int lineLength = line.length();
                int count = pi.file.getSatelliteCount();
                int startIdx = 9;
                while (count++ < pi.maxSatellites && startIdx + 3 <= lineLength) {
                    String satId = line.substring(startIdx, startIdx + 3).trim();
                    if (!satId.isEmpty()) {
                        pi.file.addSatellite(satId);
                    }
                    startIdx += 3;
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(HEADER_SAT_IDS, HEADER_ACCURACY);
            }
        }
        ,
        HEADER_ACCURACY("^\\+\\+.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                int lineLength = line.length();
                int startIdx = 9;
                while (pi.nbAccuracies < pi.maxSatellites && startIdx + 3 <= lineLength) {
                    String sub = line.substring(startIdx, startIdx + 3).trim();
                    if (!sub.isEmpty()) {
                        int exponent = Integer.parseInt(sub);
                        pi.file.getHeader().setAccuracy(pi.nbAccuracies++, SP3Utils.siAccuracy(SP3Utils.POSITION_ACCURACY_UNIT, 2.0, exponent));
                    }
                    startIdx += 3;
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(HEADER_ACCURACY, HEADER_TIME_SYSTEM);
            }
        }
        ,
        HEADER_TIME_SYSTEM("^%c.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                if (pi.file.getHeader().getType() == null) {
                    pi.file.getHeader().setType(SP3FileType.parse(line.substring(3, 5).trim()));
                    String tsStr = line.substring(9, 12).trim();
                    TimeSystem ts = tsStr.equalsIgnoreCase("ccc") ? TimeSystem.GPS : TimeSystem.parseTimeSystem(tsStr);
                    pi.file.getHeader().setTimeSystem(ts);
                    pi.timeScale = ts.getTimeScale(pi.parser.timeScales);
                    pi.file.getHeader().setEpoch(new AbsoluteDate(pi.epoch, pi.timeScale));
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(HEADER_TIME_SYSTEM, HEADER_STANDARD_DEVIATIONS);
            }
        }
        ,
        HEADER_STANDARD_DEVIATIONS("^%f.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                double clockBase;
                double posVelBase = Double.parseDouble(line.substring(3, 13).trim());
                if (posVelBase != 0.0) {
                    pi.file.getHeader().setPosVelBase(posVelBase);
                }
                if ((clockBase = Double.parseDouble(line.substring(14, 26).trim())) != 0.0) {
                    pi.file.getHeader().setClockBase(clockBase);
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(HEADER_STANDARD_DEVIATIONS, HEADER_CUSTOM_PARAMETERS);
            }
        }
        ,
        HEADER_CUSTOM_PARAMETERS("^%i.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(HEADER_CUSTOM_PARAMETERS, HEADER_COMMENTS);
            }
        }
        ,
        HEADER_COMMENTS("^[%]?/\\*.*|"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.file.getHeader().addComment(line.substring(line.indexOf(42) + 1).trim());
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(HEADER_COMMENTS, DATA_EPOCH);
            }
        }
        ,
        DATA_EPOCH("^\\* .*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                double second;
                int minute;
                int hour;
                int day;
                int month;
                int year;
                try (Scanner s1 = new Scanner(line);
                     Scanner s2 = s1.useDelimiter(SP3Parser.SPACES);
                     Scanner scanner = s2.useLocale(Locale.US);){
                    scanner.skip("\\*");
                    year = scanner.nextInt();
                    month = scanner.nextInt();
                    day = scanner.nextInt();
                    hour = scanner.nextInt();
                    minute = scanner.nextInt();
                    second = scanner.nextDouble();
                }
                DateComponents dc = day == 0 ? new DateComponents(new DateComponents(year, month, 1), -1) : new DateComponents(year, month, day);
                ArrayList<AbsoluteDate> candidates = new ArrayList<AbsoluteDate>();
                int h = hour;
                int m = minute;
                double s = second;
                if (s >= 60.0) {
                    this.addCandidate(candidates, dc, h, m, s -= 60.0, pi.timeScale);
                    ++m;
                }
                if (m > 59) {
                    m = 0;
                    this.addCandidate(candidates, dc, h, m, s, pi.timeScale);
                    ++h;
                }
                if (h > 23) {
                    h = 0;
                    this.addCandidate(candidates, dc, h, m, s, pi.timeScale);
                    dc = new DateComponents(dc, 1);
                }
                this.addCandidate(candidates, dc, h, m, s, pi.timeScale);
                AbsoluteDate expected = pi.latestEpoch == null ? pi.file.getHeader().getEpoch() : pi.latestEpoch.shiftedBy(pi.file.getHeader().getEpochInterval());
                pi.latestEpoch = null;
                for (AbsoluteDate candidate : candidates) {
                    if (!(FastMath.abs((double)candidate.durationFrom(expected)) < 0.01 * pi.file.getHeader().getEpochInterval())) continue;
                    pi.latestEpoch = candidate;
                }
                if (pi.latestEpoch == null) {
                    pi.latestEpoch = new AbsoluteDate(year, month, day, hour, minute, second, pi.timeScale);
                }
            }

            private void addCandidate(List<AbsoluteDate> candidates, DateComponents dc, int hour, int minute, double second, TimeScale timeScale) {
                try {
                    candidates.add(new AbsoluteDate(dc, new TimeComponents(hour, minute, second), timeScale));
                }
                catch (OrekitIllegalArgumentException orekitIllegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Collections.singleton(DATA_POSITION);
            }
        }
        ,
        DATA_POSITION("^P.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String satelliteId = line.substring(1, 4).trim();
                if (!pi.file.containsSatellite(satelliteId)) {
                    pi.latestPosition = Vector3D.ZERO;
                } else {
                    SP3Header header = pi.file.getHeader();
                    pi.latestPosition = new Vector3D(SP3Utils.POSITION_UNIT.toSI(Double.parseDouble(line.substring(4, 18).trim())), SP3Utils.POSITION_UNIT.toSI(Double.parseDouble(line.substring(18, 32).trim())), SP3Utils.POSITION_UNIT.toSI(Double.parseDouble(line.substring(32, 46).trim())));
                    double clockField = line.trim().length() <= 46 ? 999999.999999 : Double.parseDouble(line.substring(46, 60).trim());
                    pi.latestClock = FastMath.abs((double)(clockField - 999999.999999)) < 1.0E-6 ? Double.NaN : SP3Utils.CLOCK_UNIT.toSI(clockField);
                    if (pi.latestPosition.getNorm() > 0.0) {
                        if (line.length() < 69 || line.substring(61, 63).trim().isEmpty() || line.substring(64, 66).trim().isEmpty() || line.substring(67, 69).trim().isEmpty()) {
                            pi.latestPositionAccuracy = null;
                        } else {
                            pi.latestPositionAccuracy = new Vector3D(SP3Utils.siAccuracy(SP3Utils.POSITION_ACCURACY_UNIT, header.getPosVelBase(), Integer.parseInt(line.substring(61, 63).trim())), SP3Utils.siAccuracy(SP3Utils.POSITION_ACCURACY_UNIT, header.getPosVelBase(), Integer.parseInt(line.substring(64, 66).trim())), SP3Utils.siAccuracy(SP3Utils.POSITION_ACCURACY_UNIT, header.getPosVelBase(), Integer.parseInt(line.substring(67, 69).trim())));
                        }
                        if (line.length() < 73 || line.substring(70, 73).trim().isEmpty()) {
                            pi.latestClockAccuracy = Double.NaN;
                        } else {
                            pi.latestClockAccuracy = SP3Utils.siAccuracy(SP3Utils.CLOCK_ACCURACY_UNIT, header.getClockBase(), Integer.parseInt(line.substring(70, 73).trim()));
                        }
                        pi.latestClockEvent = line.length() >= 75 && line.charAt(74) == 'E';
                        pi.latestClockPrediction = line.length() >= 76 && line.charAt(75) == 'P';
                        pi.latestOrbitManeuverEvent = line.length() >= 79 && line.charAt(78) == 'M';
                        pi.latestOrbitPrediction = line.length() >= 80 && line.charAt(79) == 'P';
                        if (!pi.hasVelocityEntries) {
                            SP3Coordinate coord = new SP3Coordinate(pi.latestEpoch, pi.latestPosition, pi.latestPositionAccuracy, Vector3D.ZERO, null, pi.latestClock, pi.latestClockAccuracy, 0.0, Double.NaN, pi.latestClockEvent, pi.latestClockPrediction, pi.latestOrbitManeuverEvent, pi.latestOrbitPrediction);
                            pi.file.getEphemeris(satelliteId).addCoordinate(coord, header.getEpochInterval());
                        }
                    }
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(DATA_EPOCH, DATA_POSITION, DATA_POSITION_CORRELATION, DATA_VELOCITY, EOF);
            }
        }
        ,
        DATA_POSITION_CORRELATION("^EP.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(DATA_EPOCH, DATA_POSITION, DATA_VELOCITY, EOF);
            }
        }
        ,
        DATA_VELOCITY("^V.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String satelliteId = line.substring(1, 4).trim();
                if (pi.file.containsSatellite(satelliteId) && pi.latestPosition.getNorm() > 0.0) {
                    SP3Header header = pi.file.getHeader();
                    Vector3D velocity = new Vector3D(SP3Utils.VELOCITY_UNIT.toSI(Double.parseDouble(line.substring(4, 18).trim())), SP3Utils.VELOCITY_UNIT.toSI(Double.parseDouble(line.substring(18, 32).trim())), SP3Utils.VELOCITY_UNIT.toSI(Double.parseDouble(line.substring(32, 46).trim())));
                    double clockRateField = line.trim().length() <= 46 ? 999999.999999 : Double.parseDouble(line.substring(46, 60).trim());
                    double clockRateChange = FastMath.abs((double)(clockRateField - 999999.999999)) < 1.0E-6 ? Double.NaN : SP3Utils.CLOCK_RATE_UNIT.toSI(clockRateField);
                    Vector3D velocityAccuracy = line.length() < 69 || line.substring(61, 63).trim().isEmpty() || line.substring(64, 66).trim().isEmpty() || line.substring(67, 69).trim().isEmpty() ? null : new Vector3D(SP3Utils.siAccuracy(SP3Utils.VELOCITY_ACCURACY_UNIT, header.getPosVelBase(), Integer.parseInt(line.substring(61, 63).trim())), SP3Utils.siAccuracy(SP3Utils.VELOCITY_ACCURACY_UNIT, header.getPosVelBase(), Integer.parseInt(line.substring(64, 66).trim())), SP3Utils.siAccuracy(SP3Utils.VELOCITY_ACCURACY_UNIT, header.getPosVelBase(), Integer.parseInt(line.substring(67, 69).trim())));
                    double clockRateAccuracy = line.length() < 73 || line.substring(70, 73).trim().isEmpty() ? Double.NaN : SP3Utils.siAccuracy(SP3Utils.CLOCK_RATE_ACCURACY_UNIT, header.getClockBase(), Integer.parseInt(line.substring(70, 73).trim()));
                    SP3Coordinate coord = new SP3Coordinate(pi.latestEpoch, pi.latestPosition, pi.latestPositionAccuracy, velocity, velocityAccuracy, pi.latestClock, pi.latestClockAccuracy, clockRateChange, clockRateAccuracy, pi.latestClockEvent, pi.latestClockPrediction, pi.latestOrbitManeuverEvent, pi.latestOrbitPrediction);
                    pi.file.getEphemeris(satelliteId).addCoordinate(coord, header.getEpochInterval());
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(DATA_EPOCH, DATA_POSITION, DATA_VELOCITY_CORRELATION, EOF);
            }
        }
        ,
        DATA_VELOCITY_CORRELATION("^EV.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(DATA_EPOCH, DATA_POSITION, EOF);
            }
        }
        ,
        EOF("^[eE][oO][fF]\\s*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.done = true;
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Collections.singleton(EOF);
            }
        };

        private final Pattern pattern;

        private LineParser(String lineRegexp) {
            this.pattern = Pattern.compile(lineRegexp);
        }

        public abstract void parse(String var1, ParseInfo var2);

        public abstract Iterable<LineParser> allowedNext();

        public boolean canHandle(String line) {
            return this.pattern.matcher(line).matches();
        }
    }

    private static class ParseInfo {
        private final String fileName;
        private final SP3Parser parser;
        private SP3 file;
        private AbsoluteDate latestEpoch;
        private Vector3D latestPosition;
        private Vector3D latestPositionAccuracy;
        private double latestClock;
        private double latestClockAccuracy;
        private boolean latestClockEvent;
        private boolean latestClockPrediction;
        private boolean latestOrbitManeuverEvent;
        private boolean latestOrbitPrediction;
        private boolean hasVelocityEntries;
        private TimeScale timeScale;
        private DateTimeComponents epoch;
        private int maxSatellites;
        private int nbAccuracies;
        private boolean done;

        protected ParseInfo(String fileName, SP3Parser parser) {
            this.fileName = fileName;
            this.parser = parser;
            this.latestEpoch = null;
            this.latestPosition = null;
            this.latestClock = 0.0;
            this.hasVelocityEntries = false;
            this.epoch = DateTimeComponents.JULIAN_EPOCH;
            this.timeScale = parser.timeScales.getGPS();
            this.maxSatellites = 0;
            this.nbAccuracies = 0;
            this.done = false;
        }
    }
}

