/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.sp3.DataUsed;
import org.orekit.files.sp3.SP3FileType;
import org.orekit.files.sp3.SP3OrbitType;
import org.orekit.gnss.TimeSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;

public class SP3Header {
    public static final String SP3_FRAME_CENTER_STRING = "EARTH";
    private static final String POS_VEL_ACCURACY_BASE = "pos/vel accuracy base";
    private static final String CLOCK_ACCURACY_BASE = "clock accuracy base";
    private static final String COMMENTS = "comments";
    private char version = (char)63;
    private SP3FileType type;
    private TimeSystem timeSystem;
    private AbsoluteDate epoch;
    private int gpsWeek;
    private double secondsOfWeek;
    private int modifiedJulianDay;
    private double dayFraction;
    private double epochInterval;
    private int numberOfEpochs;
    private String coordinateSystem;
    private List<DataUsed> dataUsed;
    private SP3OrbitType orbitType;
    private String orbitTypeKey;
    private String agency;
    private CartesianDerivativesFilter filter;
    private double posVelBase;
    private double clockBase;
    private List<String> satIds = new ArrayList<String>();
    private double[] accuracies = null;
    private final List<String> comments = new ArrayList<String>();

    void validate(boolean parsing, boolean hasAccuracy, String fileName) throws OrekitException {
        if ("abcd".indexOf(this.getVersion()) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.SP3_UNSUPPORTED_VERSION, Character.valueOf(this.getVersion()));
        }
        if (this.getVersion() == 'a') {
            if (this.getPosVelBase() != 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SP3_INVALID_HEADER_ENTRY, POS_VEL_ACCURACY_BASE, this.getPosVelBase(), fileName, Character.valueOf(this.getVersion()));
            }
            if (this.getClockBase() != 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SP3_INVALID_HEADER_ENTRY, CLOCK_ACCURACY_BASE, this.getClockBase(), fileName, Character.valueOf(this.getVersion()));
            }
        } else if (hasAccuracy) {
            if (this.getPosVelBase() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SP3_INVALID_HEADER_ENTRY, POS_VEL_ACCURACY_BASE, this.getPosVelBase(), fileName, Character.valueOf(this.getVersion()));
            }
            if (this.getClockBase() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SP3_INVALID_HEADER_ENTRY, CLOCK_ACCURACY_BASE, this.getClockBase(), fileName, Character.valueOf(this.getVersion()));
            }
        }
        if (this.getVersion() < 'd') {
            if (this.comments.size() != 4 || this.comments.get(0).length() > 57 || this.comments.get(1).length() > 57 || this.comments.get(2).length() > 57 || this.comments.get(3).length() > 57) {
                throw new OrekitException((Localizable)OrekitMessages.SP3_INVALID_HEADER_ENTRY, COMMENTS, "/* \u2026", fileName, Character.valueOf(this.getVersion()));
            }
        } else {
            for (String c : this.comments) {
                if (c.length() <= 77) continue;
                throw new OrekitException((Localizable)OrekitMessages.SP3_INVALID_HEADER_ENTRY, COMMENTS, c, fileName, Character.valueOf(this.getVersion()));
            }
        }
    }

    public void setVersion(char version) {
        this.version = version;
    }

    public char getVersion() {
        return this.version;
    }

    public void setFilter(CartesianDerivativesFilter filter) {
        this.filter = filter;
    }

    public CartesianDerivativesFilter getFilter() {
        return this.filter;
    }

    public SP3FileType getType() {
        return this.type;
    }

    public void setType(SP3FileType fileType) {
        this.type = fileType;
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public void setTimeSystem(TimeSystem system) {
        this.timeSystem = system;
    }

    public List<DataUsed> getDataUsed() {
        return this.dataUsed;
    }

    public void setDataUsed(List<DataUsed> dataUsed) {
        this.dataUsed = dataUsed;
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate time) {
        this.epoch = time;
    }

    public int getGpsWeek() {
        return this.gpsWeek;
    }

    public void setGpsWeek(int week) {
        this.gpsWeek = week;
    }

    public double getSecondsOfWeek() {
        return this.secondsOfWeek;
    }

    public void setSecondsOfWeek(double seconds) {
        this.secondsOfWeek = seconds;
    }

    public int getModifiedJulianDay() {
        return this.modifiedJulianDay;
    }

    public void setModifiedJulianDay(int day) {
        this.modifiedJulianDay = day;
    }

    public double getDayFraction() {
        return this.dayFraction;
    }

    public void setDayFraction(double fraction) {
        this.dayFraction = fraction;
    }

    public double getEpochInterval() {
        return this.epochInterval;
    }

    public void setEpochInterval(double interval) {
        this.epochInterval = interval;
    }

    public int getNumberOfEpochs() {
        return this.numberOfEpochs;
    }

    public void setNumberOfEpochs(int epochCount) {
        this.numberOfEpochs = epochCount;
    }

    public String getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(String system) {
        this.coordinateSystem = system;
    }

    public SP3OrbitType getOrbitType() {
        return this.orbitType;
    }

    public String getOrbitTypeKey() {
        return this.orbitTypeKey;
    }

    public void setOrbitTypeKey(String oTypeKey) {
        this.orbitTypeKey = oTypeKey;
        this.orbitType = SP3OrbitType.parseType(oTypeKey);
    }

    public String getAgency() {
        return this.agency;
    }

    public void setAgency(String agencyStr) {
        this.agency = agencyStr;
    }

    public void setPosVelBase(double posVelBase) {
        this.posVelBase = posVelBase;
    }

    public double getPosVelBase() {
        return this.posVelBase;
    }

    public void setClockBase(double clockBase) {
        this.clockBase = clockBase;
    }

    public double getClockBase() {
        return this.clockBase;
    }

    public void addSatId(String satId) {
        this.satIds.add(satId);
    }

    public List<String> getSatIds() {
        return Collections.unmodifiableList(this.satIds);
    }

    public void setAccuracy(int index, double accuracy) {
        if (this.accuracies == null) {
            this.accuracies = new double[this.satIds.size()];
        }
        this.accuracies[index] = accuracy;
    }

    public double getAccuracy(String satId) {
        for (int i = 0; i < this.satIds.size(); ++i) {
            if (!this.satIds.get(i).equals(satId)) continue;
            return this.accuracies[i];
        }
        return Double.NaN;
    }

    public List<String> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }
}

