/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.HashMap;
import java.util.Map;

public enum SP3FileType {
    GPS("G"),
    MIXED("M"),
    GLONASS("R"),
    LEO("L"),
    GALILEO("E"),
    SBAS("S"),
    IRNSS("I"),
    COMPASS("C"),
    QZSS("J"),
    UNDEFINED("?");

    private static final Map<String, SP3FileType> MAP;
    private final String key;

    private SP3FileType(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static SP3FileType parse(String s) {
        SP3FileType type = MAP.get(s.toUpperCase());
        return type == null ? UNDEFINED : type;
    }

    static {
        MAP = new HashMap<String, SP3FileType>();
        for (SP3FileType type : SP3FileType.values()) {
            MAP.put(type.getKey(), type);
        }
    }
}

