/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.sp3.SP3Coordinate;
import org.orekit.files.sp3.SP3Segment;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AggregatedClockModel;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeSpanMap;

public class SP3Ephemeris
implements EphemerisFile.SatelliteEphemeris<SP3Coordinate, SP3Segment> {
    private final String id;
    private final double mu;
    private final Frame frame;
    private final int interpolationSamples;
    private final CartesianDerivativesFilter filter;
    private final List<SP3Segment> segments;

    public SP3Ephemeris(String id, double mu, Frame frame, int interpolationSamples, CartesianDerivativesFilter filter) {
        this.id = id;
        this.mu = mu;
        this.frame = frame;
        this.interpolationSamples = interpolationSamples;
        this.filter = filter;
        this.segments = new ArrayList<SP3Segment>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public List<SP3Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    @Override
    public AbsoluteDate getStart() {
        return this.segments.isEmpty() ? null : this.segments.get(0).getStart();
    }

    @Override
    public AbsoluteDate getStop() {
        return this.segments.isEmpty() ? null : this.segments.get(this.segments.size() - 1).getStop();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public int getInterpolationSamples() {
        return this.interpolationSamples;
    }

    public CartesianDerivativesFilter getAvailableDerivatives() {
        return this.filter;
    }

    public void addCoordinate(SP3Coordinate coord, double maxGap) {
        SP3Segment segment;
        AbsoluteDate lastDate = this.getStop();
        if (lastDate == null || coord.getDate().durationFrom(lastDate) > maxGap) {
            segment = new SP3Segment(this.mu, this.frame, this.interpolationSamples, this.filter);
            this.segments.add(segment);
        } else {
            segment = this.segments.get(this.segments.size() - 1);
        }
        segment.addCoordinate(coord);
    }

    public AggregatedClockModel extractClockModel() {
        TimeSpanMap<Object> models = new TimeSpanMap<Object>(null);
        this.segments.forEach(segment -> models.addValidBetween(segment.extractClockModel(), segment.getStart(), segment.getStop()));
        return new AggregatedClockModel(models);
    }
}

