/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.stream.Stream;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.sp3.SP3Coordinate;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;

public class SP3CoordinateHermiteInterpolator
extends AbstractTimeInterpolator<SP3Coordinate> {
    private final boolean useRates;

    public SP3CoordinateHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, boolean useRates) {
        super(interpolationPoints, extrapolationThreshold);
        this.useRates = useRates;
    }

    @Override
    protected SP3Coordinate interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        AbsoluteDate date = interpolationData.getInterpolationDate();
        Stream sample = interpolationData.getNeighborList().stream();
        HermiteInterpolator interpolator = new HermiteInterpolator();
        if (this.useRates) {
            sample.forEach(c -> interpolator.addSamplePoint(c.getDate().durationFrom(date), (double[][])new double[][]{{c.getPosition().getX(), c.getPosition().getY(), c.getPosition().getZ(), c.getClockCorrection()}, {c.getVelocity().getX(), c.getVelocity().getY(), c.getVelocity().getZ(), c.getClockRateChange()}}));
        } else {
            sample.forEach(c -> interpolator.addSamplePoint(c.getDate().durationFrom(date), (double[][])new double[][]{{c.getPosition().getX(), c.getPosition().getY(), c.getPosition().getZ(), c.getClockCorrection()}}));
        }
        double[][] interpolated = interpolator.derivatives(0.0, 1);
        return new SP3Coordinate(date, new Vector3D(interpolated[0][0], interpolated[0][1], interpolated[0][2]), null, new Vector3D(interpolated[1][0], interpolated[1][1], interpolated[1][2]), null, interpolated[0][3], Double.NaN, interpolated[1][3], Double.NaN, false, false, false, false);
    }
}

