/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.sp3.SP3Utils;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SP3Coordinate
extends TimeStampedPVCoordinates {
    public static final SP3Coordinate DUMMY = new SP3Coordinate(AbsoluteDate.ARBITRARY_EPOCH, Vector3D.ZERO, null, Vector3D.ZERO, null, SP3Utils.CLOCK_UNIT.toSI(999999.999999), Double.NaN, SP3Utils.CLOCK_RATE_UNIT.toSI(999999.999999), Double.NaN, false, false, false, false);
    private static final long serialVersionUID = 20230903L;
    private final double clock;
    private final double clockRate;
    private final Vector3D positionAccuracy;
    private final Vector3D velocityAccuracy;
    private final double clockAccuracy;
    private final double clockRateAccuracy;
    private final boolean clockEvent;
    private final boolean clockPrediction;
    private final boolean orbitManeuverEvent;
    private final boolean orbitPrediction;

    public SP3Coordinate(AbsoluteDate date, Vector3D position, Vector3D positionAccuracy, Vector3D velocity, Vector3D velocityAccuracy, double clock, double clockAccuracy, double clockRate, double clockRateAccuracy, boolean clockEvent, boolean clockPrediction, boolean orbitManeuverEvent, boolean orbitPrediction) {
        super(date, position, velocity, Vector3D.ZERO);
        this.clock = clock;
        this.clockRate = clockRate;
        this.positionAccuracy = positionAccuracy;
        this.velocityAccuracy = velocityAccuracy;
        this.clockAccuracy = clockAccuracy;
        this.clockRateAccuracy = clockRateAccuracy;
        this.clockEvent = clockEvent;
        this.clockPrediction = clockPrediction;
        this.orbitManeuverEvent = orbitManeuverEvent;
        this.orbitPrediction = orbitPrediction;
    }

    public double getClockCorrection() {
        return this.clock;
    }

    public double getClockRateChange() {
        return this.clockRate;
    }

    public Vector3D getPositionAccuracy() {
        return this.positionAccuracy;
    }

    public Vector3D getVelocityAccuracy() {
        return this.velocityAccuracy;
    }

    public double getClockAccuracy() {
        return this.clockAccuracy;
    }

    public double getClockRateAccuracy() {
        return this.clockRateAccuracy;
    }

    public boolean hasClockEvent() {
        return this.clockEvent;
    }

    public boolean hasClockPrediction() {
        return this.clockPrediction;
    }

    public boolean hasOrbitManeuverEvent() {
        return this.orbitManeuverEvent;
    }

    public boolean hasOrbitPrediction() {
        return this.orbitPrediction;
    }
}

