/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.sp3.SP3Coordinate;
import org.orekit.files.sp3.SP3Ephemeris;
import org.orekit.files.sp3.SP3Header;
import org.orekit.files.sp3.SP3Segment;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.gnss.IGSUtils;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeStamped;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SP3
implements EphemerisFile<SP3Coordinate, SP3Segment> {
    private final SP3Header header;
    private final double mu;
    private final int interpolationSamples;
    private final Frame frame;
    private final Map<String, SP3Ephemeris> satellites;

    public SP3(double mu, int interpolationSamples, Frame frame) {
        this(new SP3Header(), mu, interpolationSamples, frame);
    }

    public SP3(SP3Header header, double mu, int interpolationSamples, Frame frame) {
        this.header = header;
        this.mu = mu;
        this.interpolationSamples = interpolationSamples;
        this.frame = frame;
        this.satellites = new LinkedHashMap<String, SP3Ephemeris>();
    }

    public void validate(boolean parsing, String fileName) throws OrekitException {
        TreeSet<TimeStamped> epochs = new TreeSet<TimeStamped>(new ChronologicalComparator());
        boolean hasAccuracy = false;
        for (Map.Entry<String, SP3Ephemeris> entry : this.satellites.entrySet()) {
            TimeStampedPVCoordinates previous = null;
            for (SP3Segment segment : entry.getValue().getSegments()) {
                for (SP3Coordinate coordinate : segment.getCoordinates()) {
                    AbsoluteDate previousDate = previous == null ? this.header.getEpoch() : previous.getDate();
                    double nbSteps = coordinate.getDate().durationFrom(previousDate) / this.header.getEpochInterval();
                    if (FastMath.abs((double)(nbSteps - FastMath.rint((double)nbSteps))) > 0.001) {
                        throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_SAMPLING_DATE, previousDate.shiftedBy(FastMath.rint((double)nbSteps) * this.header.getEpochInterval()), coordinate.getDate());
                    }
                    epochs.add(coordinate.getDate());
                    previous = coordinate;
                    hasAccuracy |= coordinate.getPositionAccuracy() != null || coordinate.getVelocityAccuracy() != null || !Double.isNaN(coordinate.getClockAccuracy()) || !Double.isNaN(coordinate.getClockRateAccuracy());
                }
            }
        }
        if (this.getSatelliteCount() > this.getMaxAllowedSatCount(parsing)) {
            throw new OrekitException((Localizable)OrekitMessages.SP3_TOO_MANY_SATELLITES_FOR_VERSION, Character.valueOf(this.header.getVersion()), this.getMaxAllowedSatCount(parsing), this.getSatelliteCount(), fileName);
        }
        this.header.validate(parsing, hasAccuracy, fileName);
        if (epochs.size() != this.header.getNumberOfEpochs()) {
            throw new OrekitException((Localizable)OrekitMessages.SP3_NUMBER_OF_EPOCH_MISMATCH, epochs.size(), fileName, this.header.getNumberOfEpochs());
        }
    }

    public SP3Header getHeader() {
        return this.header;
    }

    private int getMaxAllowedSatCount(boolean parsing) {
        return this.header.getVersion() < 'd' ? (parsing ? 99 : 85) : 999;
    }

    public static SP3 splice(Collection<SP3> sp3) {
        ChronologicalComparator comparator = new ChronologicalComparator();
        TreeSet<SP3> sorted = new TreeSet<SP3>((s1, s2) -> comparator.compare(s1.header.getEpoch(), s2.header.getEpoch()));
        sorted.addAll(sp3);
        SP3 first = (SP3)sorted.first();
        SP3 spliced = new SP3(first.mu, first.interpolationSamples, first.frame);
        spliced.header.setVersion(first.header.getVersion());
        spliced.header.setFilter(first.header.getFilter());
        spliced.header.setType(first.header.getType());
        spliced.header.setTimeSystem(first.header.getTimeSystem());
        spliced.header.setDataUsed(first.header.getDataUsed());
        spliced.header.setEpoch(first.header.getEpoch());
        spliced.header.setGpsWeek(first.header.getGpsWeek());
        spliced.header.setSecondsOfWeek(first.header.getSecondsOfWeek());
        spliced.header.setModifiedJulianDay(first.header.getModifiedJulianDay());
        spliced.header.setDayFraction(first.header.getDayFraction());
        spliced.header.setEpochInterval(first.header.getEpochInterval());
        spliced.header.setCoordinateSystem(first.header.getCoordinateSystem());
        spliced.header.setOrbitTypeKey(first.header.getOrbitTypeKey());
        spliced.header.setAgency(first.header.getAgency());
        spliced.header.setPosVelBase(first.header.getPosVelBase());
        spliced.header.setClockBase(first.header.getClockBase());
        first.header.getComments().forEach(spliced.header::addComment);
        ArrayList<String> commonSats = new ArrayList<String>(first.header.getSatIds());
        block0: for (SP3 current : sorted) {
            Iterator iter = commonSats.iterator();
            while (iter.hasNext()) {
                String string = (String)iter.next();
                if (current.containsSatellite(string)) continue;
                iter.remove();
                continue block0;
            }
        }
        for (String sat : commonSats) {
            spliced.addSatellite(sat);
        }
        for (int i = 0; i < commonSats.size(); ++i) {
            String sat;
            sat = (String)commonSats.get(i);
            double accuracy = 0.0;
            for (SP3 current : sorted) {
                accuracy = FastMath.max((double)accuracy, (double)current.header.getAccuracy(sat));
            }
            spliced.header.setAccuracy(i, accuracy);
        }
        SP3 previous = null;
        int epochCount = 0;
        for (SP3 sP3 : sorted) {
            epochCount += sP3.header.getNumberOfEpochs();
            if (previous != null) {
                boolean dropLast = sP3.checkSplice(previous);
                if (dropLast) {
                    --epochCount;
                }
                for (Map.Entry<String, SP3Ephemeris> entry : previous.satellites.entrySet()) {
                    if (!commonSats.contains(entry.getKey())) continue;
                    SP3Ephemeris splicedEphemeris = spliced.getEphemeris(entry.getKey());
                    for (SP3Segment segment : entry.getValue().getSegments()) {
                        List<SP3Coordinate> coordinates = segment.getCoordinates();
                        for (int i = 0; i < coordinates.size() - (dropLast ? 1 : 0); ++i) {
                            splicedEphemeris.addCoordinate(coordinates.get(i), spliced.header.getEpochInterval());
                        }
                    }
                }
            }
            previous = sP3;
        }
        spliced.header.setNumberOfEpochs(epochCount);
        for (Map.Entry entry : previous.satellites.entrySet()) {
            if (!commonSats.contains(entry.getKey())) continue;
            SP3Ephemeris splicedEphemeris = spliced.getEphemeris((String)entry.getKey());
            for (SP3Segment segment : ((SP3Ephemeris)entry.getValue()).getSegments()) {
                for (SP3Coordinate coordinate : segment.getCoordinates()) {
                    splicedEphemeris.addCoordinate(coordinate, spliced.header.getEpochInterval());
                }
            }
        }
        return spliced;
    }

    public static SP3 changeFrame(SP3 original, Frame newFrame) {
        SP3Header header = new SP3Header();
        SP3Header originalHeader = original.header;
        header.setVersion(originalHeader.getVersion());
        header.setFilter(originalHeader.getFilter());
        header.setType(originalHeader.getType());
        header.setTimeSystem(originalHeader.getTimeSystem());
        header.setDataUsed(originalHeader.getDataUsed());
        header.setEpoch(originalHeader.getEpoch());
        header.setGpsWeek(originalHeader.getGpsWeek());
        header.setSecondsOfWeek(originalHeader.getSecondsOfWeek());
        header.setModifiedJulianDay(originalHeader.getModifiedJulianDay());
        header.setDayFraction(originalHeader.getDayFraction());
        header.setEpochInterval(originalHeader.getEpochInterval());
        header.setOrbitTypeKey(originalHeader.getOrbitTypeKey());
        header.setAgency(originalHeader.getAgency());
        header.setPosVelBase(originalHeader.getPosVelBase());
        header.setClockBase(originalHeader.getClockBase());
        header.setNumberOfEpochs(originalHeader.getNumberOfEpochs());
        originalHeader.getComments().forEach(header::addComment);
        header.setCoordinateSystem(IGSUtils.frameName(newFrame));
        SP3 changed = new SP3(header, original.mu, original.interpolationSamples, newFrame);
        List<String> ids = originalHeader.getSatIds();
        ids.forEach(changed::addSatellite);
        for (int i = 0; i < ids.size(); ++i) {
            header.setAccuracy(i, originalHeader.getAccuracy(ids.get(i)));
        }
        for (Map.Entry<String, SP3Ephemeris> entry : original.satellites.entrySet()) {
            SP3Ephemeris originalEphemeris = original.getEphemeris(entry.getKey());
            SP3Ephemeris changedEphemeris = changed.getEphemeris(entry.getKey());
            for (SP3Segment segment : originalEphemeris.getSegments()) {
                for (SP3Coordinate c : segment.getCoordinates()) {
                    Transform t = originalEphemeris.getFrame().getTransformTo(newFrame, c.getDate());
                    TimeStampedPVCoordinates newPV = t.transformPVCoordinates(c);
                    Vector3D newP = newPV.getPosition();
                    Vector3D newPA = c.getPositionAccuracy() == null ? null : t.transformVector(c.getPositionAccuracy());
                    Vector3D newV = c.getVelocity() == null ? Vector3D.ZERO : newPV.getVelocity();
                    Vector3D newVA = c.getVelocityAccuracy() == null ? null : t.transformVector(c.getVelocityAccuracy());
                    SP3Coordinate newC = new SP3Coordinate(c.getDate(), newP, newPA, newV, newVA, c.getClockCorrection(), c.getClockAccuracy(), c.getClockRateChange(), c.getClockRateAccuracy(), c.hasClockEvent(), c.hasClockPrediction(), c.hasOrbitManeuverEvent(), c.hasOrbitPrediction());
                    changedEphemeris.addCoordinate(newC, originalHeader.getEpochInterval());
                }
            }
        }
        return changed;
    }

    private boolean checkSplice(SP3 previous) throws OrekitException {
        if (!(previous.header.getType() == this.header.getType() && previous.header.getTimeSystem() == this.header.getTimeSystem() && previous.header.getOrbitType() == this.header.getOrbitType() && previous.header.getCoordinateSystem().equals(this.header.getCoordinateSystem()) && previous.header.getDataUsed().equals(this.header.getDataUsed()) && previous.header.getAgency().equals(this.header.getAgency()))) {
            throw new OrekitException((Localizable)OrekitMessages.SP3_INCOMPATIBLE_FILE_METADATA, new Object[0]);
        }
        boolean dropLast = false;
        for (Map.Entry<String, SP3Ephemeris> entry : previous.satellites.entrySet()) {
            SP3Ephemeris previousEphem = entry.getValue();
            SP3Ephemeris currentEphem = this.satellites.get(entry.getKey());
            if (currentEphem == null) continue;
            if (previousEphem.getAvailableDerivatives() != currentEphem.getAvailableDerivatives() || previousEphem.getFrame() != currentEphem.getFrame() || previousEphem.getInterpolationSamples() != currentEphem.getInterpolationSamples() || !Precision.equals((double)previousEphem.getMu(), (double)currentEphem.getMu(), (int)2)) {
                throw new OrekitException((Localizable)OrekitMessages.SP3_INCOMPATIBLE_SATELLITE_MEDATADA, entry.getKey());
            }
            double dt = currentEphem.getStart().durationFrom(previousEphem.getStop());
            dropLast = dt < 0.001 * this.header.getEpochInterval();
        }
        return dropLast;
    }

    public void addSatellite(String satId) {
        this.header.addSatId(satId);
        this.satellites.putIfAbsent(satId, new SP3Ephemeris(satId, this.mu, this.frame, this.interpolationSamples, this.header.getFilter()));
    }

    @Override
    public Map<String, SP3Ephemeris> getSatellites() {
        return Collections.unmodifiableMap(this.satellites);
    }

    public SP3Ephemeris getEphemeris(int index) {
        int n = index;
        for (Map.Entry<String, SP3Ephemeris> entry : this.satellites.entrySet()) {
            if (n == 0) {
                return entry.getValue();
            }
            --n;
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_SATELLITE_ID, index);
    }

    public SP3Ephemeris getEphemeris(String satId) {
        SP3Ephemeris ephemeris = this.satellites.get(satId);
        if (ephemeris == null) {
            throw new OrekitException((Localizable)OrekitMessages.INVALID_SATELLITE_ID, satId);
        }
        return ephemeris;
    }

    public int getSatelliteCount() {
        return this.satellites.size();
    }

    public boolean containsSatellite(String satId) {
        return this.header.getSatIds().contains(satId);
    }
}

