/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.io.IOException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.orekit.data.DataFilter;
import org.orekit.data.DataSource;
import org.orekit.data.LineOrientedFilteringReader;

public class NsgfV00Filter
implements DataFilter {
    public static final String DEFAULT_V00_PATTERN = ".*nsgf\\.orb\\.[^.]+\\.v00\\.sp3$";
    private final Pattern pattern;
    private final Function<String, String> renaming;

    public NsgfV00Filter(String nameRegexp, Function<String, String> renaming) {
        this.pattern = Pattern.compile(nameRegexp);
        this.renaming = renaming;
    }

    public NsgfV00Filter() {
        this(DEFAULT_V00_PATTERN, s -> s.replace("v00", "v70"));
    }

    @Override
    public DataSource filter(DataSource original) throws IOException {
        Matcher matcher = this.pattern.matcher(original.getName());
        if (matcher.matches()) {
            String oName = original.getName();
            String fName = this.renaming.apply(oName);
            return new DataSource(fName, () -> new LineOrientedFilteringReader(oName, original.getOpener().openReaderOnce()){

                @Override
                protected CharSequence filterLine(int lineNumber, String originalLine) {
                    if (lineNumber == 1 && originalLine.startsWith("#c")) {
                        return "#d" + originalLine.substring(2);
                    }
                    return originalLine;
                }
            });
        }
        return original;
    }
}

