/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.HashMap;
import java.util.Map;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public enum DataUsed {
    UNDIFFERENTIATED_CARRIER_PHASE("u"),
    CHANGE_IN_UNDIFFERENTIATED_CARRIER_PHASE("du"),
    TWO_RECEIVER_ONE_SATELLITE_CARRIER_PHASE("s"),
    CHANGE_IN_TWO_RECEIVER_ONE_SATELLITE_CARRIER_PHASE("ds"),
    TWO_RECEIVER_TWO_SATELLITE_CARRIER_PHASE("d"),
    CHANGE_IN_TWO_RECEIVER_TWO_SATELLITE_CARRIER_PHASE("dd"),
    UNDIFFERENTIATED_CODE_PHASE("U"),
    CHANGE_IN_UNDIFFERENTIATED_CODE_PHASE("dU"),
    TWO_RECEIVER_ONE_SATELLITE_CODE_PHASE("S"),
    CHANGE_IN_TWO_RECEIVER_ONE_SATELLITE_CODE_PHASE("dS"),
    TWO_RECEIVER_TWO_SATELLITE_CODE_PHASE("D"),
    CHANGE_IN_TWO_RECEIVER_TWO_SATELLITE_CODE_PHASE("dD"),
    SATELLITE_LASER_RANGING("SLR"),
    MIXED("mixed"),
    ORBIT("ORBIT");

    private static final Map<String, DataUsed> MAP;
    private final String key;

    private DataUsed(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static DataUsed parse(String s, String fileName, char version) {
        DataUsed dataUsed = MAP.get(s);
        if (dataUsed == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.SP3_INVALID_HEADER_ENTRY, "data used", s, fileName, Character.valueOf(version));
        }
        return dataUsed;
    }

    static {
        MAP = new HashMap<String, DataUsed>();
        for (DataUsed dataUsed : DataUsed.values()) {
            MAP.put(dataUsed.getKey(), dataUsed);
        }
    }
}

