/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sinex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.displacement.PsdCorrection;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class Station {
    private String siteCode;
    private String domes;
    private AbsoluteDate validFrom;
    private AbsoluteDate validUntil;
    private ReferenceSystem eccRefSystem;
    private final TimeSpanMap<Vector3D> eccentricitiesTimeSpanMap = new TimeSpanMap<Object>(null);
    private final TimeSpanMap<String> antennaTypesMap = new TimeSpanMap<Object>(null);
    private final TimeSpanMap<List<PsdCorrection>> psdMap = new TimeSpanMap<Object>(null);
    private Vector3D position = Vector3D.ZERO;
    private Vector3D velocity = Vector3D.ZERO;
    private AbsoluteDate epoch;

    public String getSiteCode() {
        return this.siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getDomes() {
        return this.domes;
    }

    public void setDomes(String domes) {
        this.domes = domes;
    }

    public AbsoluteDate getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(AbsoluteDate validFrom) {
        this.validFrom = validFrom;
    }

    public AbsoluteDate getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(AbsoluteDate validUntil) {
        this.validUntil = validUntil;
    }

    public ReferenceSystem getEccRefSystem() {
        return this.eccRefSystem;
    }

    public void setEccRefSystem(ReferenceSystem eccRefSystem) {
        this.eccRefSystem = eccRefSystem;
    }

    public Vector3D getEccentricities(AbsoluteDate date) {
        Vector3D eccAtEpoch = this.eccentricitiesTimeSpanMap.get(date);
        if (eccAtEpoch == null) {
            throw new OrekitException((Localizable)OrekitMessages.MISSING_STATION_DATA_FOR_EPOCH, date);
        }
        return eccAtEpoch;
    }

    public TimeSpanMap<Vector3D> getEccentricitiesTimeSpanMap() {
        return this.eccentricitiesTimeSpanMap;
    }

    public void addStationEccentricitiesValidBefore(Vector3D entry, AbsoluteDate latestValidityDate) {
        this.eccentricitiesTimeSpanMap.addValidBefore(entry, latestValidityDate, false);
    }

    public void addStationEccentricitiesValidAfter(Vector3D entry, AbsoluteDate earliestValidityDate) {
        this.eccentricitiesTimeSpanMap.addValidAfter(entry, earliestValidityDate, false);
    }

    public TimeSpanMap<List<PsdCorrection>> getPsdTimeSpanMap() {
        return this.psdMap;
    }

    public void addPsdCorrectionValidAfter(PsdCorrection entry, AbsoluteDate earliestValidityDate) {
        List<PsdCorrection> corrections = this.psdMap.get(earliestValidityDate.shiftedBy(0.001));
        if (corrections == null || earliestValidityDate.durationFrom(corrections.get(0).getEarthquakeDate()) > 0.001) {
            corrections = new ArrayList<PsdCorrection>();
            this.psdMap.addValidAfter(corrections, earliestValidityDate, false);
        }
        corrections.add(entry);
    }

    public String getAntennaType(AbsoluteDate date) {
        String typeAtEpoch = this.antennaTypesMap.get(date);
        if (typeAtEpoch == null) {
            throw new OrekitException((Localizable)OrekitMessages.MISSING_STATION_DATA_FOR_EPOCH, date);
        }
        return typeAtEpoch;
    }

    public TimeSpanMap<String> getAntennaTypeTimeSpanMap() {
        return this.antennaTypesMap;
    }

    public void addAntennaTypeValidBefore(String entry, AbsoluteDate latestValidityDate) {
        this.antennaTypesMap.addValidBefore(entry, latestValidityDate, false);
    }

    public void addAntennaTypeValidAfter(String entry, AbsoluteDate earliestValidityDate) {
        this.antennaTypesMap.addValidAfter(entry, earliestValidityDate, false);
    }

    public Vector3D getPosition() {
        return this.position;
    }

    public void setPosition(Vector3D position) {
        this.position = position;
    }

    public Vector3D getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3D velocity) {
        this.velocity = velocity;
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    public static enum ReferenceSystem {
        UNE("UNE"),
        XYZ("XYZ");

        private static final Map<String, ReferenceSystem> CODES_MAP;
        private final String name;

        private ReferenceSystem(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ReferenceSystem getEccRefSystem(String value) {
            return CODES_MAP.get(value);
        }

        static {
            CODES_MAP = new HashMap<String, ReferenceSystem>();
            for (ReferenceSystem type : ReferenceSystem.values()) {
                CODES_MAP.put(type.getName(), type);
            }
        }
    }
}

