/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sinex;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.sinex.Dcb;
import org.orekit.files.sinex.DcbDescription;
import org.orekit.files.sinex.DcbSatellite;
import org.orekit.files.sinex.DcbStation;
import org.orekit.files.sinex.SinexEopEntry;
import org.orekit.files.sinex.Station;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EopHistoryLoader;
import org.orekit.frames.ITRFVersion;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.TimeSystem;
import org.orekit.models.earth.displacement.PsdCorrection;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeStamped;
import org.orekit.time.UTCScale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.Unit;

public class SinexLoader
implements EopHistoryLoader {
    private static final String STAX = "STAX";
    private static final String STAY = "STAY";
    private static final String STAZ = "STAZ";
    private static final String VELX = "VELX";
    private static final String VELY = "VELY";
    private static final String VELZ = "VELZ";
    private static final String AEXP_E = "AEXP_E";
    private static final String TEXP_E = "TEXP_E";
    private static final String ALOG_E = "ALOG_E";
    private static final String TLOG_E = "TLOG_E";
    private static final String AEXP_N = "AEXP_N";
    private static final String TEXP_N = "TEXP_N";
    private static final String ALOG_N = "ALOG_N";
    private static final String TLOG_N = "TLOG_N";
    private static final String AEXP_U = "AEXP_U";
    private static final String TEXP_U = "TEXP_U";
    private static final String ALOG_U = "ALOG_U";
    private static final String TLOG_U = "TLOG_U";
    private static final String LOD = "LOD";
    private static final String UT = "UT";
    private static final String XPO = "XPO";
    private static final String YPO = "YPO";
    private static final String NUT_LN = "NUT_LN";
    private static final String NUT_OB = "NUT_OB";
    private static final String NUT_X = "NUT_X";
    private static final String NUT_Y = "NUT_Y";
    private static final String DEFAULT_EPOCH_TWO_DIGITS = "00:000:00000";
    private static final String DEFAULT_EPOCH_FOUR_DIGITS = "0000:000:00000";
    private static final Pattern SEPARATOR = Pattern.compile(":");
    private static final Pattern PATTERN_SPACE = Pattern.compile("\\s+");
    private static final Pattern PATTERN_BEGIN = Pattern.compile("%=(?:SNX|BIA) \\d\\.\\d\\d ... (\\d{2,4}:\\d{3}:\\d{5}) ... (\\d{2,4}:\\d{3}:\\d{5}) (\\d{2,4}:\\d{3}:\\d{5}) . .*");
    private static final List<String> EOP_TYPES = Arrays.asList("LOD", "UT", "XPO", "YPO", "NUT_LN", "NUT_OB", "NUT_X", "NUT_Y");
    private AbsoluteDate startDate;
    private AbsoluteDate endDate;
    private AbsoluteDate creationDate;
    private final Map<String, Station> stations;
    private final Map<String, DcbStation> dcbStations;
    private final Map<String, DcbSatellite> dcbSatellites;
    private final DcbDescription dcbDescription;
    private final Map<AbsoluteDate, SinexEopEntry> eop;
    private ITRFVersion itrfVersionEop;
    private final TimeScales scales;

    @DefaultDataContext
    public SinexLoader(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales());
    }

    public SinexLoader(String supportedNames, DataProvidersManager dataProvidersManager, TimeScales scales) {
        this.scales = scales;
        this.creationDate = AbsoluteDate.FUTURE_INFINITY;
        this.dcbDescription = new DcbDescription();
        this.dcbStations = new HashMap<String, DcbStation>();
        this.dcbSatellites = new HashMap<String, DcbSatellite>();
        this.eop = new HashMap<AbsoluteDate, SinexEopEntry>();
        this.itrfVersionEop = ITRFVersion.ITRF_2014;
        this.stations = new HashMap<String, Station>();
        dataProvidersManager.feed(supportedNames, new Parser());
    }

    @DefaultDataContext
    public SinexLoader(DataSource source) {
        this(source, DataContext.getDefault().getTimeScales());
    }

    public SinexLoader(DataSource source, TimeScales scales) {
        try {
            this.scales = scales;
            this.creationDate = AbsoluteDate.FUTURE_INFINITY;
            this.itrfVersionEop = ITRFVersion.ITRF_2014;
            this.eop = new HashMap<AbsoluteDate, SinexEopEntry>();
            this.dcbStations = new HashMap<String, DcbStation>();
            this.dcbSatellites = new HashMap<String, DcbSatellite>();
            this.dcbDescription = new DcbDescription();
            this.stations = new HashMap<String, Station>();
            try (InputStream is = source.getOpener().openStreamOnce();
                 BufferedInputStream bis = new BufferedInputStream(is);){
                new Parser().loadData(bis, source.getName());
            }
        }
        catch (IOException | ParseException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    public void setITRFVersion(int year) {
        this.itrfVersionEop = ITRFVersion.getITRFVersion(year);
    }

    public ITRFVersion getITRFVersion() {
        return this.itrfVersionEop;
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    public AbsoluteDate getFileEpochStartTime() {
        return this.startDate;
    }

    public AbsoluteDate getFileEpochEndTime() {
        return this.endDate;
    }

    public Map<String, Station> getStations() {
        return Collections.unmodifiableMap(this.stations);
    }

    public Map<AbsoluteDate, SinexEopEntry> getParsedEop() {
        return Collections.unmodifiableMap(this.eop);
    }

    public Station getStation(String siteCode) {
        return this.stations.get(siteCode);
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        history.addAll(this.getEopList(converter, this.scales.getUTC()));
    }

    public DcbStation getDcbStation(String siteCode) {
        return this.dcbStations.get(siteCode);
    }

    public DcbSatellite getDcbSatellite(String prn) {
        return this.dcbSatellites.get(prn);
    }

    private AbsoluteDate stringEpochToAbsoluteDate(String stringDate, boolean isStart, TimeScale scale) {
        if (DEFAULT_EPOCH_TWO_DIGITS.equals(stringDate) || DEFAULT_EPOCH_FOUR_DIGITS.equals(stringDate)) {
            return isStart ? this.startDate : AbsoluteDate.FUTURE_INFINITY;
        }
        String[] fields = SEPARATOR.split(stringDate);
        int digitsYear = Integer.parseInt(fields[0]);
        int day = Integer.parseInt(fields[1]);
        int secInDay = Integer.parseInt(fields[2]);
        int year = digitsYear > 50 && digitsYear < 100 ? 1900 + digitsYear : (digitsYear < 100 ? 2000 + digitsYear : digitsYear);
        return new AbsoluteDate(new DateComponents(year, 1, 1), scale).shiftedBy(86400.0 * (double)(day - 1)).shiftedBy(secInDay);
    }

    private void addStation(Station station) {
        this.stations.putIfAbsent(station.getSiteCode(), station);
    }

    private void addDcbStation(DcbStation dcb, String siteCode) {
        this.dcbStations.putIfAbsent(siteCode, dcb);
    }

    private void addDcbSatellite(DcbSatellite dcb, String prn) {
        this.dcbSatellites.putIfAbsent(prn, dcb);
    }

    private SinexEopEntry getSinexEopEntry(AbsoluteDate date) {
        this.eop.putIfAbsent(date, new SinexEopEntry(date));
        return this.eop.get(date);
    }

    private List<EOPEntry> getEopList(IERSConventions.NutationCorrectionConverter converter, TimeScale scale) {
        ArrayList<EOPEntry> eopEntries = new ArrayList<EOPEntry>();
        SortedSet<SinexEopEntry> set = this.mapToSortedSet(this.eop);
        for (SinexEopEntry entry : set) {
            eopEntries.add(entry.toEopEntry(converter, this.itrfVersionEop, scale));
        }
        eopEntries.add(this.copyEopEntry(this.startDate, set.first()).toEopEntry(converter, this.itrfVersionEop, scale));
        eopEntries.add(this.copyEopEntry(this.endDate, set.last()).toEopEntry(converter, this.itrfVersionEop, scale));
        if (set.size() < 2) {
            eopEntries.add(this.copyEopEntry(this.startDate.shiftedBy(1.0), set.first()).toEopEntry(converter, this.itrfVersionEop, scale));
            eopEntries.add(this.copyEopEntry(this.endDate.shiftedBy(-1.0), set.last()).toEopEntry(converter, this.itrfVersionEop, scale));
        }
        eopEntries.sort(new ChronologicalComparator());
        return eopEntries;
    }

    private <T extends TimeStamped> SortedSet<T> mapToSortedSet(Map<AbsoluteDate, T> inputMap) {
        TreeSet<TimeStamped> set = new TreeSet<TimeStamped>(new ChronologicalComparator());
        for (Map.Entry<AbsoluteDate, T> entry : inputMap.entrySet()) {
            set.add((TimeStamped)entry.getValue());
        }
        return set;
    }

    private SinexEopEntry copyEopEntry(AbsoluteDate date, SinexEopEntry reference) {
        SinexEopEntry newEntry = new SinexEopEntry(date);
        newEntry.setLod(reference.getLod());
        newEntry.setUt1MinusUtc(reference.getUt1MinusUtc());
        newEntry.setxPo(reference.getXPo());
        newEntry.setyPo(reference.getYPo());
        newEntry.setNutX(reference.getNutX());
        newEntry.setNutY(reference.getNutY());
        newEntry.setNutLn(reference.getNutLn());
        newEntry.setNutOb(reference.getNutOb());
        return newEntry;
    }

    private class Parser
    implements DataLoader {
        private static final String COMMENT = "*";
        private double px;
        private double py;
        private double pz;
        private double vx;
        private double vy;
        private double vz;
        private PsdCorrection.Axis axis;
        private PsdCorrection.TimeEvolution evolution;
        private double amplitude;
        private double relaxationTime;

        Parser() {
            this.resetPosition();
            this.resetVelocity();
            this.resetPsdCorrection();
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void loadData(InputStream input, String name) throws IOException, ParseException {
            int lineNumber = 0;
            String line = null;
            boolean inDcbDesc = false;
            boolean inDcbSol = false;
            boolean inId = false;
            boolean inAntenna = false;
            boolean inEcc = false;
            boolean inEpoch = false;
            boolean inEstimate = false;
            String startDateString = "";
            String endDateString = "";
            String creationDateString = "";
            UTCScale uTCScale = SinexLoader.this.scales.getUTC();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                line = reader.readLine();
                while (line != null) {
                    void var15_16;
                    if (++lineNumber == 1) {
                        Matcher matcher = PATTERN_BEGIN.matcher(line);
                        if (!matcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        creationDateString = matcher.group(1);
                        startDateString = matcher.group(2);
                        endDateString = matcher.group(3);
                        SinexLoader.this.creationDate = SinexLoader.this.stringEpochToAbsoluteDate(creationDateString, false, (TimeScale)var15_16);
                        if (SinexLoader.this.startDate == null) {
                            SinexLoader.this.startDate = SinexLoader.this.stringEpochToAbsoluteDate(startDateString, true, (TimeScale)var15_16);
                            SinexLoader.this.endDate = SinexLoader.this.stringEpochToAbsoluteDate(endDateString, false, (TimeScale)var15_16);
                        }
                    } else {
                        block19 : switch (line.trim()) {
                            case "+SITE/ID": {
                                inId = true;
                                break;
                            }
                            case "-SITE/ID": {
                                inId = false;
                                break;
                            }
                            case "+SITE/ANTENNA": {
                                inAntenna = true;
                                break;
                            }
                            case "-SITE/ANTENNA": {
                                inAntenna = false;
                                break;
                            }
                            case "+SITE/ECCENTRICITY": {
                                inEcc = true;
                                break;
                            }
                            case "-SITE/ECCENTRICITY": {
                                inEcc = false;
                                break;
                            }
                            case "+SOLUTION/EPOCHS": {
                                inEpoch = true;
                                break;
                            }
                            case "-SOLUTION/EPOCHS": {
                                inEpoch = false;
                                break;
                            }
                            case "+SOLUTION/ESTIMATE": {
                                inEstimate = true;
                                break;
                            }
                            case "-SOLUTION/ESTIMATE": {
                                inEstimate = false;
                                break;
                            }
                            case "+BIAS/DESCRIPTION": {
                                inDcbDesc = true;
                                break;
                            }
                            case "-BIAS/DESCRIPTION": {
                                inDcbDesc = false;
                                break;
                            }
                            case "+BIAS/SOLUTION": {
                                inDcbSol = true;
                                break;
                            }
                            case "-BIAS/SOLUTION": {
                                inDcbSol = false;
                                break;
                            }
                            default: {
                                SatelliteSystem satSystem;
                                Dcb dcb;
                                AbsoluteDate end;
                                AbsoluteDate start;
                                Station station;
                                if (line.startsWith(COMMENT)) break;
                                if (inId) {
                                    station = new Station();
                                    station.setSiteCode(this.parseString(line, 1, 4));
                                    station.setDomes(this.parseString(line, 9, 9));
                                    SinexLoader.this.addStation(station);
                                    break;
                                }
                                if (inAntenna) {
                                    station = SinexLoader.this.getStation(this.parseString(line, 1, 4));
                                    start = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 16, 12), true, (TimeScale)var15_16);
                                    end = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 29, 12), false, (TimeScale)var15_16);
                                    String type = this.parseString(line, 42, 20);
                                    if (station.getAntennaTypeTimeSpanMap().getSpansNumber() == 1) {
                                        station.addAntennaTypeValidBefore(type, end);
                                        station.addAntennaTypeValidBefore(null, start);
                                        break;
                                    }
                                    station.addAntennaTypeValidBefore(type, end);
                                    break;
                                }
                                if (inEcc) {
                                    station = SinexLoader.this.getStation(this.parseString(line, 1, 4));
                                    start = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 16, 12), true, (TimeScale)var15_16);
                                    end = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 29, 12), false, (TimeScale)var15_16);
                                    station.setEccRefSystem(Station.ReferenceSystem.getEccRefSystem(this.parseString(line, 42, 3)));
                                    String eccStation = new Vector3D(this.parseDouble(line, 46, 8), this.parseDouble(line, 55, 8), this.parseDouble(line, 64, 8));
                                    if (station.getEccentricitiesTimeSpanMap().getSpansNumber() == 1) {
                                        station.addStationEccentricitiesValidBefore((Vector3D)eccStation, end);
                                        station.addStationEccentricitiesValidBefore(null, start);
                                        break;
                                    }
                                    station.addStationEccentricitiesValidBefore((Vector3D)eccStation, end);
                                    break;
                                }
                                if (inEpoch) {
                                    station = SinexLoader.this.getStation(this.parseString(line, 1, 4));
                                    station.setValidFrom(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 16, 12), true, (TimeScale)var15_16));
                                    station.setValidUntil(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 29, 12), false, (TimeScale)var15_16));
                                    break;
                                }
                                if (inEstimate) {
                                    station = SinexLoader.this.getStation(this.parseString(line, 14, 4));
                                    AbsoluteDate currentDate = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 27, 12), false, (TimeScale)var15_16);
                                    String dataType = this.parseString(line, 7, 6);
                                    if (station == null && !EOP_TYPES.contains(dataType)) break;
                                    switch (dataType) {
                                        case "STAX": {
                                            this.px = this.parseDouble(line, 47, 22);
                                            this.finalizePositionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "STAY": {
                                            this.py = this.parseDouble(line, 47, 22);
                                            this.finalizePositionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "STAZ": {
                                            this.pz = this.parseDouble(line, 47, 22);
                                            this.finalizePositionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "VELX": {
                                            this.vx = this.parseDouble(line, 47, 22) / 3.15576E7;
                                            this.finalizeVelocityIfComplete(station);
                                            break block19;
                                        }
                                        case "VELY": {
                                            this.vy = this.parseDouble(line, 47, 22) / 3.15576E7;
                                            this.finalizeVelocityIfComplete(station);
                                            break block19;
                                        }
                                        case "VELZ": {
                                            this.vz = this.parseDouble(line, 47, 22) / 3.15576E7;
                                            this.finalizeVelocityIfComplete(station);
                                            break block19;
                                        }
                                        case "AEXP_E": {
                                            this.evolution = PsdCorrection.TimeEvolution.EXP;
                                            this.axis = PsdCorrection.Axis.EAST;
                                            this.amplitude = this.parseDouble(line, 47, 22);
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "TEXP_E": {
                                            this.evolution = PsdCorrection.TimeEvolution.EXP;
                                            this.axis = PsdCorrection.Axis.EAST;
                                            this.relaxationTime = this.parseDouble(line, 47, 22) * 3.15576E7;
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "ALOG_E": {
                                            this.evolution = PsdCorrection.TimeEvolution.LOG;
                                            this.axis = PsdCorrection.Axis.EAST;
                                            this.amplitude = this.parseDouble(line, 47, 22);
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "TLOG_E": {
                                            this.evolution = PsdCorrection.TimeEvolution.LOG;
                                            this.axis = PsdCorrection.Axis.EAST;
                                            this.relaxationTime = this.parseDouble(line, 47, 22) * 3.15576E7;
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "AEXP_N": {
                                            this.evolution = PsdCorrection.TimeEvolution.EXP;
                                            this.axis = PsdCorrection.Axis.NORTH;
                                            this.amplitude = this.parseDouble(line, 47, 22);
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "TEXP_N": {
                                            this.evolution = PsdCorrection.TimeEvolution.EXP;
                                            this.axis = PsdCorrection.Axis.NORTH;
                                            this.relaxationTime = this.parseDouble(line, 47, 22) * 3.15576E7;
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "ALOG_N": {
                                            this.evolution = PsdCorrection.TimeEvolution.LOG;
                                            this.axis = PsdCorrection.Axis.NORTH;
                                            this.amplitude = this.parseDouble(line, 47, 22);
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "TLOG_N": {
                                            this.evolution = PsdCorrection.TimeEvolution.LOG;
                                            this.axis = PsdCorrection.Axis.NORTH;
                                            this.relaxationTime = this.parseDouble(line, 47, 22) * 3.15576E7;
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "AEXP_U": {
                                            this.evolution = PsdCorrection.TimeEvolution.EXP;
                                            this.axis = PsdCorrection.Axis.UP;
                                            this.amplitude = this.parseDouble(line, 47, 22);
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "TEXP_U": {
                                            this.evolution = PsdCorrection.TimeEvolution.EXP;
                                            this.axis = PsdCorrection.Axis.UP;
                                            this.relaxationTime = this.parseDouble(line, 47, 22) * 3.15576E7;
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "ALOG_U": {
                                            this.evolution = PsdCorrection.TimeEvolution.LOG;
                                            this.axis = PsdCorrection.Axis.UP;
                                            this.amplitude = this.parseDouble(line, 47, 22);
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "TLOG_U": {
                                            this.evolution = PsdCorrection.TimeEvolution.LOG;
                                            this.axis = PsdCorrection.Axis.UP;
                                            this.relaxationTime = this.parseDouble(line, 47, 22) * 3.15576E7;
                                            this.finalizePsdCorrectionIfComplete(station, currentDate);
                                            break block19;
                                        }
                                        case "XPO": {
                                            double xPo = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                            SinexLoader.this.getSinexEopEntry(currentDate).setxPo(xPo);
                                            break block19;
                                        }
                                        case "YPO": {
                                            double yPo = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                            SinexLoader.this.getSinexEopEntry(currentDate).setyPo(yPo);
                                            break block19;
                                        }
                                        case "LOD": {
                                            double lod = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                            SinexLoader.this.getSinexEopEntry(currentDate).setLod(lod);
                                            break block19;
                                        }
                                        case "UT": {
                                            double dt = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                            SinexLoader.this.getSinexEopEntry(currentDate).setUt1MinusUtc(dt);
                                            break block19;
                                        }
                                        case "NUT_LN": {
                                            double nutLn = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                            SinexLoader.this.getSinexEopEntry(currentDate).setNutLn(nutLn);
                                            break block19;
                                        }
                                        case "NUT_OB": {
                                            double nutOb = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                            SinexLoader.this.getSinexEopEntry(currentDate).setNutOb(nutOb);
                                            break block19;
                                        }
                                        case "NUT_X": {
                                            double nutX = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                            SinexLoader.this.getSinexEopEntry(currentDate).setNutX(nutX);
                                            break block19;
                                        }
                                        case "NUT_Y": {
                                            double nutY = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                            SinexLoader.this.getSinexEopEntry(currentDate).setNutY(nutY);
                                            break block19;
                                        }
                                    }
                                    break;
                                }
                                if (inDcbDesc) {
                                    String[] splitLine = PATTERN_SPACE.split(line.trim());
                                    String dataType = splitLine[0];
                                    String data = splitLine[1];
                                    switch (dataType) {
                                        case "OBSERVATION_SAMPLING": {
                                            SinexLoader.this.dcbDescription.setObservationSampling(Integer.parseInt(data));
                                            break block19;
                                        }
                                        case "PARAMETER_SPACING": {
                                            SinexLoader.this.dcbDescription.setParameterSpacing(Integer.parseInt(data));
                                            break block19;
                                        }
                                        case "DETERMINATION_METHOD": {
                                            SinexLoader.this.dcbDescription.setDeterminationMethod(data);
                                            break block19;
                                        }
                                        case "BIAS_MODE": {
                                            SinexLoader.this.dcbDescription.setBiasMode(data);
                                            break block19;
                                        }
                                        case "TIME_SYSTEM": {
                                            if ("UTC".equals(data)) {
                                                SinexLoader.this.dcbDescription.setTimeSystem(TimeSystem.UTC);
                                            } else if ("TAI".equals(data)) {
                                                SinexLoader.this.dcbDescription.setTimeSystem(TimeSystem.TAI);
                                            } else {
                                                SinexLoader.this.dcbDescription.setTimeSystem(TimeSystem.parseOneLetterCode(data));
                                            }
                                            TimeScale timeScale = SinexLoader.this.dcbDescription.getTimeSystem().getTimeScale(SinexLoader.this.scales);
                                            SinexLoader.this.startDate = SinexLoader.this.stringEpochToAbsoluteDate(startDateString, true, timeScale);
                                            SinexLoader.this.endDate = SinexLoader.this.stringEpochToAbsoluteDate(endDateString, false, timeScale);
                                            SinexLoader.this.creationDate = SinexLoader.this.stringEpochToAbsoluteDate(creationDateString, false, timeScale);
                                            break block19;
                                        }
                                    }
                                    break;
                                }
                                if (!inDcbSol) break;
                                String satellitePrn = this.parseString(line, 11, 3);
                                String siteCode = this.parseString(line, 15, 9);
                                String obs1 = this.parseString(line, 25, 4);
                                String obs2 = this.parseString(line, 30, 4);
                                AbsoluteDate beginDate = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 35, 14), true, (TimeScale)var15_16);
                                AbsoluteDate finalDate = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 50, 14), false, (TimeScale)var15_16);
                                Unit unitDcb = Unit.parse(this.parseString(line, 65, 4));
                                double valueDcb = unitDcb.toSI(Double.parseDouble(this.parseString(line, 70, 21)));
                                if (siteCode.isEmpty()) {
                                    DcbSatellite dcbSatellite = SinexLoader.this.getDcbSatellite(satellitePrn);
                                    if (dcbSatellite == null) {
                                        dcbSatellite = new DcbSatellite(satellitePrn);
                                        dcbSatellite.setDescription(SinexLoader.this.dcbDescription);
                                    }
                                    Dcb dcb2 = dcbSatellite.getDcbData();
                                    dcb2.addDcbLine(obs1, obs2, beginDate, finalDate, valueDcb);
                                    SinexLoader.this.addDcbSatellite(dcbSatellite, satellitePrn);
                                    break;
                                }
                                DcbStation dcbStation = SinexLoader.this.getDcbStation(siteCode);
                                if (dcbStation == null) {
                                    dcbStation = new DcbStation(siteCode);
                                    dcbStation.setDescription(SinexLoader.this.dcbDescription);
                                }
                                if ((dcb = dcbStation.getDcbData(satSystem = SatelliteSystem.parseSatelliteSystem(satellitePrn))) == null) {
                                    dcbStation.addDcb(satSystem, new Dcb());
                                }
                                dcbStation.getDcbData(satSystem).addDcbLine(obs1, obs2, beginDate, finalDate, valueDcb);
                                SinexLoader.this.addDcbStation(dcbStation, siteCode);
                            }
                        }
                    }
                    line = reader.readLine();
                }
                return;
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
        }

        private String parseString(String line, int start, int length) {
            return line.substring(start, FastMath.min((int)line.length(), (int)(start + length))).trim();
        }

        private double parseDouble(String line, int start, int length) {
            return Double.parseDouble(this.parseString(line, start, length));
        }

        private double parseDoubleWithUnit(String line, int startUnit, int lengthUnit, int startDouble, int lengthDouble) {
            Unit unit = Unit.parse(this.parseString(line, startUnit, lengthUnit));
            return unit.toSI(this.parseDouble(line, startDouble, lengthDouble));
        }

        private void finalizePositionIfComplete(Station station, AbsoluteDate epoch) {
            if (!Double.isNaN(this.px + this.py + this.pz)) {
                station.setPosition(new Vector3D(this.px, this.py, this.pz));
                station.setEpoch(epoch);
                this.resetPosition();
            }
        }

        private void resetPosition() {
            this.px = Double.NaN;
            this.py = Double.NaN;
            this.pz = Double.NaN;
        }

        private void finalizeVelocityIfComplete(Station station) {
            if (!Double.isNaN(this.vx + this.vy + this.vz)) {
                station.setVelocity(new Vector3D(this.vx, this.vy, this.vz));
                this.resetVelocity();
            }
        }

        private void resetVelocity() {
            this.vx = Double.NaN;
            this.vy = Double.NaN;
            this.vz = Double.NaN;
        }

        private void finalizePsdCorrectionIfComplete(Station station, AbsoluteDate epoch) {
            if (!Double.isNaN(this.amplitude + this.relaxationTime)) {
                PsdCorrection correction = new PsdCorrection(this.axis, this.evolution, epoch, this.amplitude, this.relaxationTime);
                station.addPsdCorrectionValidAfter(correction, epoch);
                this.resetPsdCorrection();
            }
        }

        private void resetPsdCorrection() {
            this.axis = null;
            this.evolution = null;
            this.amplitude = Double.NaN;
            this.relaxationTime = Double.NaN;
        }
    }
}

