/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sinex;

import org.orekit.frames.EOPEntry;
import org.orekit.frames.ITRFVersion;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;
import org.orekit.utils.IERSConventions;

public class SinexEopEntry
implements TimeStamped {
    private double lod;
    private double ut1MinusUtc;
    private double xPo;
    private double yPo;
    private double nutLn;
    private double nutOb;
    private double nutX;
    private double nutY;
    private final AbsoluteDate epoch;

    public SinexEopEntry(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.epoch;
    }

    public double getLod() {
        return this.lod;
    }

    public void setLod(double lod) {
        this.lod = lod;
    }

    public double getUt1MinusUtc() {
        return this.ut1MinusUtc;
    }

    public void setUt1MinusUtc(double ut1MinusUtc) {
        this.ut1MinusUtc = ut1MinusUtc;
    }

    public double getXPo() {
        return this.xPo;
    }

    public void setxPo(double xPo) {
        this.xPo = xPo;
    }

    public double getYPo() {
        return this.yPo;
    }

    public void setyPo(double yPo) {
        this.yPo = yPo;
    }

    public double getNutLn() {
        return this.nutLn;
    }

    public void setNutLn(double nutLn) {
        this.nutLn = nutLn;
    }

    public double getNutOb() {
        return this.nutOb;
    }

    public void setNutOb(double nutOb) {
        this.nutOb = nutOb;
    }

    public double getNutX() {
        return this.nutX;
    }

    public void setNutX(double nutX) {
        this.nutX = nutX;
    }

    public double getNutY() {
        return this.nutY;
    }

    public void setNutY(double nutY) {
        this.nutY = nutY;
    }

    public EOPEntry toEopEntry(IERSConventions.NutationCorrectionConverter converter, ITRFVersion version, TimeScale scale) {
        double[] dArray;
        double[] nro;
        double[] dArray2;
        int mjd = this.epoch.getComponents(scale).getDate().getMJD();
        if (this.nutX != 0.0 && this.nutY != 0.0) {
            double[] dArray3 = new double[2];
            dArray3[0] = this.nutX;
            dArray2 = dArray3;
            dArray3[1] = this.nutY;
        } else {
            dArray2 = nro = converter.toNonRotating(this.epoch, this.nutLn, this.nutOb);
        }
        if (this.nutLn != 0.0 && this.nutOb != 0.0) {
            double[] dArray4 = new double[2];
            dArray4[0] = this.nutLn;
            dArray = dArray4;
            dArray4[1] = this.nutOb;
        } else {
            dArray = converter.toEquinox(this.epoch, this.nutX, this.nutY);
        }
        double[] equinox = dArray;
        return new EOPEntry(mjd, this.ut1MinusUtc, this.lod, this.xPo, this.yPo, Double.NaN, Double.NaN, equinox[0], equinox[1], nro[0], nro[1], version, this.epoch);
    }
}

