/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sinex;

import java.util.HashMap;
import java.util.HashSet;
import org.hipparchus.util.Pair;
import org.orekit.gnss.ObservationType;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class Dcb {
    private HashSet<Pair<ObservationType, ObservationType>> observationSets = new HashSet();
    private HashMap<Pair<ObservationType, ObservationType>, DcbCode> dcbCodeMap = new HashMap();

    public void addDcbLine(String obs1, String obs2, AbsoluteDate spanBegin, AbsoluteDate spanEnd, double biasValue) {
        Pair observationPair = new Pair((Object)ObservationType.valueOf(obs1), (Object)ObservationType.valueOf(obs2));
        if (this.observationSets.add((Pair<ObservationType, ObservationType>)observationPair)) {
            this.dcbCodeMap.put((Pair<ObservationType, ObservationType>)observationPair, new DcbCode());
        }
        this.dcbCodeMap.get(observationPair).getDcbTimeMap().addValidBetween(biasValue, spanBegin, spanEnd);
    }

    public double getDcb(String obs1, String obs2, AbsoluteDate date) {
        return this.getDcb(ObservationType.valueOf(obs1), ObservationType.valueOf(obs2), date);
    }

    public double getDcb(ObservationType obs1, ObservationType obs2, AbsoluteDate date) {
        return this.getTimeSpanMap(obs1, obs2).get(date);
    }

    public HashSet<Pair<ObservationType, ObservationType>> getAvailableObservationPairs() {
        return this.observationSets;
    }

    public AbsoluteDate getMinimumValidDateForObservationPair(String obs1, String obs2) {
        return this.getMinimumValidDateForObservationPair(ObservationType.valueOf(obs1), ObservationType.valueOf(obs2));
    }

    public AbsoluteDate getMinimumValidDateForObservationPair(ObservationType obs1, ObservationType obs2) {
        return this.getTimeSpanMap(obs1, obs2).getFirstTransition().getDate();
    }

    public AbsoluteDate getMaximumValidDateForObservationPair(String obs1, String obs2) {
        return this.getMaximumValidDateForObservationPair(ObservationType.valueOf(obs1), ObservationType.valueOf(obs2));
    }

    public AbsoluteDate getMaximumValidDateForObservationPair(ObservationType obs1, ObservationType obs2) {
        return this.getTimeSpanMap(obs1, obs2).getLastTransition().getDate();
    }

    private TimeSpanMap<Double> getTimeSpanMap(ObservationType obs1, ObservationType obs2) {
        return this.dcbCodeMap.get(new Pair((Object)obs1, (Object)obs2)).getDcbTimeMap();
    }

    private static class DcbCode {
        private TimeSpanMap<Double> dcbMap = new TimeSpanMap<Object>(null);

        DcbCode() {
        }

        public TimeSpanMap<Double> getDcbTimeMap() {
            return this.dcbMap;
        }
    }
}

