/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.utils.parsing;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.rinex.RinexFile;
import org.orekit.files.rinex.section.RinexBaseHeader;
import org.orekit.files.rinex.section.RinexComment;
import org.orekit.files.rinex.utils.RinexFileType;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.TimeSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.UTCScale;

public class RinexUtils {
    public static final int LABEL_INDEX = 60;
    private static final Pattern SPLITTING_PATTERN = Pattern.compile("([0-9A-Za-z/-]+) *([0-9:]+) *([A-Z][A-Z0-9_-]*)?");
    private static final Pattern DATE_DD_MMM_YY_PATTERN = Pattern.compile("([0-9]{2})-([A-Za-z]{3})-([0-9]{2})");
    private static final Pattern DATE_ISO_8601_PATTERN = Pattern.compile("([0-9]{4})-?([0-9]{2})-?([0-9]{2})");
    private static final Pattern DATE_EUROPEAN_PATTERN = Pattern.compile("([0-9]{2})/([0-9]{2})/([0-9]{2})");
    private static final Pattern TIME_PATTERN = Pattern.compile("([0-9]{2}):?([0-9]{2})(?::?([0-9]{2}))?");

    private RinexUtils() {
    }

    public static String getLabel(String line) {
        return line.length() < 60 ? "" : line.substring(60).trim();
    }

    public static boolean matchesLabel(String line, String label) {
        return RinexUtils.getLabel(line).equals(label);
    }

    public static void parseVersionFileTypeSatelliteSystem(String line, String name, RinexBaseHeader header, double ... supportedVersions) {
        double parsedVersion = RinexUtils.parseDouble(line, 0, 9);
        boolean found = false;
        for (double supported : supportedVersions) {
            if (!(FastMath.abs((double)(parsedVersion - supported)) < 1.0E-4)) continue;
            found = true;
            break;
        }
        if (!found) {
            StringBuilder builder = new StringBuilder();
            for (double supported : supportedVersions) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(supported);
            }
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT_VERSION, parsedVersion, name, builder.toString());
        }
        header.setFormatVersion(parsedVersion);
        if (header.getFileType() != RinexFileType.parseRinexFileType(RinexUtils.parseString(line, 20, 1))) {
            throw new OrekitException((Localizable)OrekitMessages.WRONG_PARSING_TYPE, name);
        }
        block0 : switch (header.getFileType()) {
            case OBSERVATION: {
                header.setSatelliteSystem(SatelliteSystem.parseSatelliteSystemWithGPSDefault(RinexUtils.parseString(line, 40, 1)));
                break;
            }
            case NAVIGATION: {
                if (header.getFormatVersion() < 3.0) {
                    header.setSatelliteSystem(SatelliteSystem.GPS);
                    String entry = RinexUtils.parseString(line, 0, 60).toUpperCase();
                    for (SatelliteSystem satelliteSystem : SatelliteSystem.values()) {
                        if (!entry.contains(satelliteSystem.name())) continue;
                        header.setSatelliteSystem(satelliteSystem);
                        break block0;
                    }
                    break;
                }
                header.setSatelliteSystem(SatelliteSystem.parseSatelliteSystemWithGPSDefault(RinexUtils.parseString(line, 40, 1)));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public static void parseProgramRunByDate(String line, int lineNumber, String name, TimeScales timeScales, RinexBaseHeader header) {
        header.setProgramName(RinexUtils.parseString(line, 0, 20));
        header.setRunByName(RinexUtils.parseString(line, 20, 20));
        Matcher splittingMatcher = SPLITTING_PATTERN.matcher(RinexUtils.parseString(line, 40, 20));
        if (splittingMatcher.matches()) {
            String zone;
            Matcher europeanMatcher;
            Matcher isoMatcher;
            Matcher abbrevMatcher = DATE_DD_MMM_YY_PATTERN.matcher(splittingMatcher.group(1));
            DateComponents dc = abbrevMatcher.matches() ? new DateComponents(RinexUtils.convert2DigitsYear(Integer.parseInt(abbrevMatcher.group(3))), Month.parseMonth(abbrevMatcher.group(2)).getNumber(), Integer.parseInt(abbrevMatcher.group(1))) : ((isoMatcher = DATE_ISO_8601_PATTERN.matcher(splittingMatcher.group(1))).matches() ? new DateComponents(Integer.parseInt(isoMatcher.group(1)), Integer.parseInt(isoMatcher.group(2)), Integer.parseInt(isoMatcher.group(3))) : ((europeanMatcher = DATE_EUROPEAN_PATTERN.matcher(splittingMatcher.group(1))).matches() ? new DateComponents(RinexUtils.convert2DigitsYear(Integer.parseInt(europeanMatcher.group(3))), Integer.parseInt(europeanMatcher.group(2)), Integer.parseInt(europeanMatcher.group(1))) : null));
            Matcher timeMatcher = TIME_PATTERN.matcher(splittingMatcher.group(2));
            TimeComponents tc = timeMatcher.matches() ? new TimeComponents(Integer.parseInt(timeMatcher.group(1)), Integer.parseInt(timeMatcher.group(2)), timeMatcher.group(3) != null ? (double)Integer.parseInt(timeMatcher.group(3)) : 0.0) : null;
            String string = zone = splittingMatcher.groupCount() > 2 ? splittingMatcher.group(3) : "";
            if (dc != null && tc != null) {
                DateTimeComponents dtc = new DateTimeComponents(dc, tc);
                header.setCreationDateComponents(dtc);
                UTCScale timeScale = zone == null ? timeScales.getUTC() : TimeSystem.parseTimeSystem(zone).getTimeScale(timeScales);
                header.setCreationDate(new AbsoluteDate(dtc, (TimeScale)timeScale));
                header.setCreationTimeZone(zone);
                return;
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
    }

    public static void parseComment(int lineNumber, String line, RinexFile<?> rinexFile) {
        rinexFile.addComment(new RinexComment(lineNumber, RinexUtils.parseString(line, 0, 60)));
    }

    public static double parseDouble(String line, int startIndex, int size) {
        String subString = RinexUtils.parseString(line, startIndex, size);
        if (subString == null || subString.isEmpty()) {
            return Double.NaN;
        }
        return Double.parseDouble(subString.replace('D', 'E').trim());
    }

    public static int parseInt(String line, int startIndex, int size) {
        String subString = RinexUtils.parseString(line, startIndex, size);
        if (subString == null || subString.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(subString.trim());
    }

    public static String parseString(String line, int startIndex, int size) {
        if (line.length() > startIndex) {
            return line.substring(startIndex, FastMath.min((int)line.length(), (int)(startIndex + size))).trim();
        }
        return null;
    }

    public static int convert2DigitsYear(int yy) {
        return yy >= 80 ? yy + 1900 : yy + 2000;
    }
}

