/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.utils;

import java.util.HashMap;
import java.util.Map;

public enum RinexFileType {
    OBSERVATION("O"),
    NAVIGATION("N", "G");

    private static final Map<String, RinexFileType> KEYS_MAP;
    private final String[] keys;

    private RinexFileType(String ... keys) {
        this.keys = (String[])keys.clone();
    }

    public static RinexFileType parseRinexFileType(String s) {
        return KEYS_MAP.get(s);
    }

    static {
        KEYS_MAP = new HashMap<String, RinexFileType>();
        for (RinexFileType type : RinexFileType.values()) {
            for (String key : type.keys) {
                KEYS_MAP.put(key, type);
            }
        }
    }
}

