/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.section;

public enum RinexLabels {
    VERSION("RINEX VERSION / TYPE"),
    PROGRAM("PGM / RUN BY / DATE"),
    COMMENT("COMMENT"),
    MARKER_NAME("MARKER NAME"),
    MARKER_NUMBER("MARKER NUMBER"),
    MARKER_TYPE("MARKER TYPE"),
    OBSERVER_AGENCY("OBSERVER / AGENCY"),
    REC_NB_TYPE_VERS("REC # / TYPE / VERS"),
    ANT_NB_TYPE("ANT # / TYPE"),
    APPROX_POSITION_XYZ("APPROX POSITION XYZ"),
    ANTENNA_DELTA_H_E_N("ANTENNA: DELTA H/E/N"),
    ANTENNA_DELTA_X_Y_Z("ANTENNA: DELTA X/Y/Z"),
    ANTENNA_PHASE_CENTER("ANTENNA: PHASECENTER"),
    ANTENNA_B_SIGHT_XYZ("ANTENNA: B.SIGHT XYZ"),
    ANTENNA_ZERODIR_AZI("ANTENNA: ZERODIR AZI"),
    ANTENNA_ZERODIR_XYZ("ANTENNA: ZERODIR XYZ"),
    WAVELENGTH_FACT_L1_2("WAVELENGTH FACT L1/2"),
    OBS_SCALE_FACTOR("OBS SCALE FACTOR"),
    CENTER_OF_MASS_XYZ("CENTER OF MASS: XYZ"),
    DOI("DOI"),
    LICENSE("LICENSE OF USE"),
    STATION_INFORMATION("STATION INFORMATION"),
    NB_TYPES_OF_OBSERV("# / TYPES OF OBSERV"),
    SYS_NB_TYPES_OF_OBSERV("SYS / # / OBS TYPES"),
    SIGNAL_STRENGTH_UNIT("SIGNAL STRENGTH UNIT"),
    INTERVAL("INTERVAL"),
    TIME_OF_FIRST_OBS("TIME OF FIRST OBS"),
    TIME_OF_LAST_OBS("TIME OF LAST OBS"),
    RCV_CLOCK_OFFS_APPL("RCV CLOCK OFFS APPL"),
    SYS_DCBS_APPLIED("SYS / DCBS APPLIED"),
    SYS_PCVS_APPLIED("SYS / PCVS APPLIED"),
    SYS_SCALE_FACTOR("SYS / SCALE FACTOR"),
    SYS_PHASE_SHIFT("SYS / PHASE SHIFT", "SYS / PHASE SHIFTS"),
    GLONASS_SLOT_FRQ_NB("GLONASS SLOT / FRQ #"),
    GLONASS_COD_PHS_BIS("GLONASS COD/PHS/BIS"),
    LEAP_SECONDS("LEAP SECONDS"),
    NB_OF_SATELLITES("# OF SATELLITES"),
    PRN_NB_OF_OBS("PRN / # OF OBS"),
    END("END OF HEADER");

    private final String[] labels;

    private RinexLabels(String ... labels) {
        this.labels = (String[])labels.clone();
    }

    public boolean matches(String label) {
        for (String allowed : this.labels) {
            if (!allowed.equals(label)) continue;
            return true;
        }
        return false;
    }

    public String getLabel() {
        return this.labels[0];
    }
}

