/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.observation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.rinex.AppliedDCBS;
import org.orekit.files.rinex.AppliedPCVS;
import org.orekit.files.rinex.observation.GlonassSatelliteChannel;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.files.rinex.observation.PhaseShiftCorrection;
import org.orekit.files.rinex.observation.RinexObservation;
import org.orekit.files.rinex.observation.RinexObservationHeader;
import org.orekit.files.rinex.observation.ScaleFactorCorrection;
import org.orekit.files.rinex.section.RinexComment;
import org.orekit.files.rinex.section.RinexLabels;
import org.orekit.gnss.ObservationTimeScale;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatInSystem;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ClockModel;
import org.orekit.time.ClockTimeScale;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

public class RinexObservationWriter
implements AutoCloseable {
    private static final int LABEL_INDEX = 60;
    private static final String ONE_DIGIT_INTEGER = "%1d";
    private static final String PADDED_TWO_DIGITS_INTEGER = "%02d";
    private static final String TWO_DIGITS_INTEGER = "%2d";
    private static final String PADDED_FOUR_DIGITS_INTEGER = "%04d";
    private static final String THREE_DIGITS_INTEGER = "%3d";
    private static final String FOUR_DIGITS_INTEGER = "%4d";
    private static final String SIX_DIGITS_INTEGER = "%6d";
    private static final String EIGHT_THREE_DIGITS_FLOAT = "%8.3f";
    private static final String EIGHT_FIVE_DIGITS_FLOAT = "%8.5f";
    private static final String NINE_FOUR_DIGITS_FLOAT = "%9.4f";
    private static final String TEN_THREE_DIGITS_FLOAT = "%10.3f";
    private static final String ELEVEN_SEVEN_DIGITS_FLOAT = "%11.7f";
    private static final String TWELVE_NINE_DIGITS_FLOAT = "%12.9f";
    private static final String THIRTEEN_SEVEN_DIGITS_FLOAT = "%13.7f";
    private static final String FOURTEEN_THREE_DIGITS_FLOAT = "%14.3f";
    private static final String FOURTEEN_FOUR_DIGITS_FLOAT = "%14.4f";
    private static final String FIFTEEN_TWELVE_DIGITS_FLOAT = "%15.12f";
    private static final double EPS_DATE = 1.0E-8;
    private final Appendable output;
    private final String outputName;
    private ClockModel receiverClockModel;
    private TimeScale timeScale;
    private RinexObservationHeader savedHeader;
    private List<RinexComment> savedComments;
    private final List<ObservationDataSet> pending;
    private int lineNumber;
    private int column;

    public RinexObservationWriter(Appendable output, String outputName) {
        this.output = output;
        this.outputName = outputName;
        this.savedHeader = null;
        this.savedComments = Collections.emptyList();
        this.pending = new ArrayList<ObservationDataSet>();
        this.lineNumber = 0;
        this.column = 0;
    }

    @Override
    public void close() throws IOException {
        this.processPending();
    }

    public void setReceiverClockModel(ClockModel receiverClockModel) {
        this.receiverClockModel = receiverClockModel;
    }

    @DefaultDataContext
    public void writeCompleteFile(RinexObservation rinexObservation) throws IOException {
        this.prepareComments(rinexObservation.getComments());
        this.writeHeader((RinexObservationHeader)rinexObservation.getHeader());
        for (ObservationDataSet observationDataSet : rinexObservation.getObservationDataSets()) {
            this.writeObservationDataSet(observationDataSet);
        }
    }

    public void prepareComments(List<RinexComment> comments) {
        this.savedComments = comments;
    }

    /*
     * WARNING - void declaration
     */
    @DefaultDataContext
    public void writeHeader(RinexObservationHeader header) throws IOException {
        if (this.savedHeader != null) {
            throw new OrekitException((Localizable)OrekitMessages.HEADER_ALREADY_WRITTEN, this.outputName);
        }
        this.savedHeader = header;
        this.lineNumber = 1;
        ObservationTimeScale observationTimeScale = header.getSatelliteSystem().getObservationTimeScale() != null ? header.getSatelliteSystem().getObservationTimeScale() : ObservationTimeScale.GPS;
        this.timeScale = observationTimeScale.getTimeScale(TimeScalesFactory.getTimeScales());
        if (!header.getClockOffsetApplied() && this.receiverClockModel != null) {
            this.timeScale = new ClockTimeScale(this.timeScale.getName(), this.timeScale, this.receiverClockModel);
        }
        this.outputField("%9.2f", header.getFormatVersion(), 9);
        this.outputField("", 20, true);
        this.outputField("OBSERVATION DATA", 40, true);
        this.outputField(header.getSatelliteSystem().getKey(), 41);
        this.finishHeaderLine(RinexLabels.VERSION);
        this.outputField(header.getProgramName(), 20, true);
        this.outputField(header.getRunByName(), 40, true);
        DateTimeComponents dtc = header.getCreationDateComponents();
        if (header.getFormatVersion() < 3.0 && dtc.getTime().getSecond() < 0.5) {
            this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getDate().getDay(), 42);
            this.outputField('-', 43);
            this.outputField(dtc.getDate().getMonthEnum().getUpperCaseAbbreviation(), 46, true);
            this.outputField('-', 47);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getDate().getYear() % 100, 49);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getTime().getHour(), 52);
            this.outputField(':', 53);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getTime().getMinute(), 55);
            this.outputField(header.getCreationTimeZone(), 58, true);
        } else {
            this.outputField(PADDED_FOUR_DIGITS_INTEGER, dtc.getDate().getYear(), 44);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getDate().getMonth(), 46);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getDate().getDay(), 48);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getTime().getHour(), 51);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getTime().getMinute(), 53);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, (int)FastMath.rint((double)dtc.getTime().getSecond()), 55);
            this.outputField(header.getCreationTimeZone(), 59, false);
        }
        this.finishHeaderLine(RinexLabels.PROGRAM);
        this.outputField(header.getMarkerName(), 60, true);
        this.finishHeaderLine(RinexLabels.MARKER_NAME);
        if (header.getMarkerNumber() != null) {
            this.outputField(header.getMarkerNumber(), 20, true);
            this.finishHeaderLine(RinexLabels.MARKER_NUMBER);
        }
        if (header.getFormatVersion() >= 2.2) {
            this.outputField(header.getMarkerType(), 20, true);
            this.finishHeaderLine(RinexLabels.MARKER_TYPE);
        }
        this.outputField(header.getObserverName(), 20, true);
        this.outputField(header.getAgencyName(), 60, true);
        this.finishHeaderLine(RinexLabels.OBSERVER_AGENCY);
        this.outputField(header.getReceiverNumber(), 20, true);
        this.outputField(header.getReceiverType(), 40, true);
        this.outputField(header.getReceiverVersion(), 60, true);
        this.finishHeaderLine(RinexLabels.REC_NB_TYPE_VERS);
        this.outputField(header.getAntennaNumber(), 20, true);
        this.outputField(header.getAntennaType(), 40, true);
        this.finishHeaderLine(RinexLabels.ANT_NB_TYPE);
        this.writeHeaderLine(header.getApproxPos(), RinexLabels.APPROX_POSITION_XYZ);
        if (!Double.isNaN(header.getAntennaHeight())) {
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, header.getAntennaHeight(), 14);
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, header.getEccentricities().getX(), 28);
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, header.getEccentricities().getY(), 42);
            this.finishHeaderLine(RinexLabels.ANTENNA_DELTA_H_E_N);
        }
        this.writeHeaderLine(header.getAntennaReferencePoint(), RinexLabels.ANTENNA_DELTA_X_Y_Z);
        if (header.getAntennaPhaseCenter() != null) {
            this.outputField(header.getPhaseCenterSystem().getKey(), 1);
            this.outputField("", 2, true);
            this.outputField(header.getObservationCode(), 5, true);
            this.outputField(NINE_FOUR_DIGITS_FLOAT, header.getAntennaPhaseCenter().getX(), 14);
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, header.getAntennaPhaseCenter().getY(), 28);
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, header.getAntennaPhaseCenter().getZ(), 42);
            this.finishHeaderLine(RinexLabels.ANTENNA_PHASE_CENTER);
        }
        this.writeHeaderLine(header.getAntennaBSight(), RinexLabels.ANTENNA_B_SIGHT_XYZ);
        if (!Double.isNaN(header.getAntennaAzimuth())) {
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, FastMath.toDegrees((double)header.getAntennaAzimuth()), 14);
            this.finishHeaderLine(RinexLabels.ANTENNA_ZERODIR_AZI);
        }
        this.writeHeaderLine(header.getAntennaZeroDirection(), RinexLabels.ANTENNA_ZERODIR_XYZ);
        if (FastMath.abs((double)(header.getFormatVersion() - 2.2)) < 0.001) {
            void var6_17;
            SatelliteSystem[] satelliteSystemArray = SatelliteSystem.values();
            int n = satelliteSystemArray.length;
            boolean bl = false;
            while (var6_17 < n) {
                SatelliteSystem system = satelliteSystemArray[var6_17];
                for (ScaleFactorCorrection scaleFactorCorrection : header.getScaleFactorCorrections(system)) {
                    if (scaleFactorCorrection == null) continue;
                    this.outputField(SIX_DIGITS_INTEGER, (int)FastMath.round((double)scaleFactorCorrection.getCorrection()), 6);
                    this.outputField(SIX_DIGITS_INTEGER, scaleFactorCorrection.getTypesObsScaled().size(), 12);
                    for (int i = 0; i < scaleFactorCorrection.getTypesObsScaled().size(); ++i) {
                        this.outputField(scaleFactorCorrection.getTypesObsScaled().get(i).name(), 18 + 6 * i, false);
                    }
                    this.finishHeaderLine(RinexLabels.OBS_SCALE_FACTOR);
                }
                ++var6_17;
            }
        }
        this.writeHeaderLine(header.getCenterMass(), RinexLabels.CENTER_OF_MASS_XYZ);
        this.writeHeaderLine(header.getDoi(), RinexLabels.DOI);
        this.writeHeaderLine(header.getLicense(), RinexLabels.LICENSE);
        this.writeHeaderLine(header.getStationInformation(), RinexLabels.STATION_INFORMATION);
        for (Map.Entry entry : header.getTypeObs().entrySet()) {
            if (header.getFormatVersion() < 3.0) {
                this.outputField(SIX_DIGITS_INTEGER, ((List)entry.getValue()).size(), 6);
            } else {
                this.outputField(((SatelliteSystem)((Object)entry.getKey())).getKey(), 1);
                this.outputField(THREE_DIGITS_INTEGER, ((List)entry.getValue()).size(), 6);
            }
            for (ObservationType observationType : (List)entry.getValue()) {
                int n = this.column + (header.getFormatVersion() < 3.0 ? 6 : 4);
                if (n > 60) {
                    this.finishHeaderLine(header.getFormatVersion() < 3.0 ? RinexLabels.NB_TYPES_OF_OBSERV : RinexLabels.SYS_NB_TYPES_OF_OBSERV);
                    this.outputField("", 6, true);
                    n = this.column + (header.getFormatVersion() < 3.0 ? 6 : 4);
                }
                this.outputField(observationType.name(), n, false);
            }
            this.finishHeaderLine(header.getFormatVersion() < 3.0 ? RinexLabels.NB_TYPES_OF_OBSERV : RinexLabels.SYS_NB_TYPES_OF_OBSERV);
        }
        this.writeHeaderLine(header.getSignalStrengthUnit(), RinexLabels.SIGNAL_STRENGTH_UNIT);
        if (!Double.isNaN(header.getInterval())) {
            this.outputField(TEN_THREE_DIGITS_FLOAT, header.getInterval(), 10);
            this.finishHeaderLine(RinexLabels.INTERVAL);
        }
        DateTimeComponents dtcFirst = header.getTFirstObs().getComponents(this.timeScale);
        this.outputField(SIX_DIGITS_INTEGER, dtcFirst.getDate().getYear(), 6);
        this.outputField(SIX_DIGITS_INTEGER, dtcFirst.getDate().getMonth(), 12);
        this.outputField(SIX_DIGITS_INTEGER, dtcFirst.getDate().getDay(), 18);
        this.outputField(SIX_DIGITS_INTEGER, dtcFirst.getTime().getHour(), 24);
        this.outputField(SIX_DIGITS_INTEGER, dtcFirst.getTime().getMinute(), 30);
        this.outputField(THIRTEEN_SEVEN_DIGITS_FLOAT, dtcFirst.getTime().getSecond(), 43);
        this.outputField(observationTimeScale.name(), 51, false);
        this.finishHeaderLine(RinexLabels.TIME_OF_FIRST_OBS);
        if (!header.getTLastObs().equals(AbsoluteDate.FUTURE_INFINITY)) {
            DateTimeComponents dateTimeComponents = header.getTLastObs().getComponents(this.timeScale);
            this.outputField(SIX_DIGITS_INTEGER, dateTimeComponents.getDate().getYear(), 6);
            this.outputField(SIX_DIGITS_INTEGER, dateTimeComponents.getDate().getMonth(), 12);
            this.outputField(SIX_DIGITS_INTEGER, dateTimeComponents.getDate().getDay(), 18);
            this.outputField(SIX_DIGITS_INTEGER, dateTimeComponents.getTime().getHour(), 24);
            this.outputField(SIX_DIGITS_INTEGER, dateTimeComponents.getTime().getMinute(), 30);
            this.outputField(THIRTEEN_SEVEN_DIGITS_FLOAT, dateTimeComponents.getTime().getSecond(), 43);
            this.outputField(observationTimeScale.name(), 51, false);
            this.finishHeaderLine(RinexLabels.TIME_OF_LAST_OBS);
        }
        this.outputField(SIX_DIGITS_INTEGER, header.getClockOffsetApplied() ? 1 : 0, 6);
        this.finishHeaderLine(RinexLabels.RCV_CLOCK_OFFS_APPL);
        for (AppliedDCBS appliedDCBS : header.getListAppliedDCBS()) {
            this.outputField(appliedDCBS.getSatelliteSystem().getKey(), 1);
            this.outputField("", 2, true);
            this.outputField(appliedDCBS.getProgDCBS(), 20, true);
            this.outputField(appliedDCBS.getSourceDCBS(), 60, true);
            this.finishHeaderLine(RinexLabels.SYS_DCBS_APPLIED);
        }
        for (AppliedPCVS appliedPCVS : header.getListAppliedPCVS()) {
            this.outputField(appliedPCVS.getSatelliteSystem().getKey(), 1);
            this.outputField("", 2, true);
            this.outputField(appliedPCVS.getProgPCVS(), 20, true);
            this.outputField(appliedPCVS.getSourcePCVS(), 60, true);
            this.finishHeaderLine(RinexLabels.SYS_PCVS_APPLIED);
        }
        if (header.getFormatVersion() >= 3.0) {
            for (SatelliteSystem satelliteSystem : SatelliteSystem.values()) {
                for (ScaleFactorCorrection sfc : header.getScaleFactorCorrections(satelliteSystem)) {
                    if (sfc == null) continue;
                    this.outputField(satelliteSystem.getKey(), 1);
                    this.outputField("", 2, true);
                    this.outputField(FOUR_DIGITS_INTEGER, (int)FastMath.rint((double)sfc.getCorrection()), 6);
                    if (sfc.getTypesObsScaled().size() < header.getTypeObs().get((Object)satelliteSystem).size()) {
                        this.outputField("", 8, true);
                        this.outputField(TWO_DIGITS_INTEGER, sfc.getTypesObsScaled().size(), 10);
                        for (ObservationType observationType : sfc.getTypesObsScaled()) {
                            int next = this.column + 4;
                            if (next > 60) {
                                this.finishHeaderLine(RinexLabels.SYS_SCALE_FACTOR);
                                this.outputField("", 10, true);
                                next = this.column + 4;
                            }
                            this.outputField("", next - 3, true);
                            this.outputField(observationType.name(), next, true);
                        }
                    }
                    this.finishHeaderLine(RinexLabels.SYS_SCALE_FACTOR);
                }
            }
        }
        for (PhaseShiftCorrection phaseShiftCorrection : header.getPhaseShiftCorrections()) {
            this.outputField(phaseShiftCorrection.getSatelliteSystem().getKey(), 1);
            this.outputField(phaseShiftCorrection.getTypeObs().name(), 5, false);
            this.outputField(EIGHT_FIVE_DIGITS_FLOAT, phaseShiftCorrection.getCorrection(), 14);
            if (!phaseShiftCorrection.getSatsCorrected().isEmpty()) {
                this.outputField(TWO_DIGITS_INTEGER, phaseShiftCorrection.getSatsCorrected().size(), 18);
                for (SatInSystem satInSystem : phaseShiftCorrection.getSatsCorrected()) {
                    int n = this.column + 4;
                    if (n > 60) {
                        this.finishHeaderLine(RinexLabels.SYS_PHASE_SHIFT);
                        this.outputField("", 18, true);
                        n = this.column + 4;
                    }
                    this.outputField(satInSystem.getSystem().getKey(), n - 2);
                    this.outputField(PADDED_TWO_DIGITS_INTEGER, satInSystem.getTwoDigitsRinexPRN(), n);
                }
            }
            this.finishHeaderLine(RinexLabels.SYS_PHASE_SHIFT);
        }
        if (header.getFormatVersion() >= 3.01) {
            if (!header.getGlonassChannels().isEmpty()) {
                this.outputField(THREE_DIGITS_INTEGER, header.getGlonassChannels().size(), 3);
                this.outputField("", 4, true);
                for (GlonassSatelliteChannel glonassSatelliteChannel : header.getGlonassChannels()) {
                    int next = this.column + 7;
                    if (next > 60) {
                        this.finishHeaderLine(RinexLabels.GLONASS_SLOT_FRQ_NB);
                        this.outputField("", 4, true);
                        next = this.column + 7;
                    }
                    this.outputField(glonassSatelliteChannel.getSatellite().getSystem().getKey(), next - 6);
                    this.outputField(PADDED_TWO_DIGITS_INTEGER, glonassSatelliteChannel.getSatellite().getPRN(), next - 4);
                    this.outputField(TWO_DIGITS_INTEGER, glonassSatelliteChannel.getK(), next - 1);
                    this.outputField("", next, true);
                }
            }
            this.finishHeaderLine(RinexLabels.GLONASS_SLOT_FRQ_NB);
        }
        if (header.getFormatVersion() >= 3.0) {
            if (Double.isNaN(header.getC1cCodePhaseBias())) {
                this.outputField("", 13, true);
            } else {
                this.outputField(ObservationType.C1C.name(), 4, false);
                this.outputField("", 5, true);
                this.outputField(EIGHT_THREE_DIGITS_FLOAT, header.getC1cCodePhaseBias(), 13);
            }
            if (Double.isNaN(header.getC1pCodePhaseBias())) {
                this.outputField("", 26, true);
            } else {
                this.outputField(ObservationType.C1P.name(), 17, false);
                this.outputField("", 18, true);
                this.outputField(EIGHT_THREE_DIGITS_FLOAT, header.getC1pCodePhaseBias(), 26);
            }
            if (Double.isNaN(header.getC2cCodePhaseBias())) {
                this.outputField("", 39, true);
            } else {
                this.outputField(ObservationType.C2C.name(), 30, false);
                this.outputField("", 31, true);
                this.outputField(EIGHT_THREE_DIGITS_FLOAT, header.getC2cCodePhaseBias(), 39);
            }
            if (Double.isNaN(header.getC2pCodePhaseBias())) {
                this.outputField("", 52, true);
            } else {
                this.outputField(ObservationType.C2P.name(), 43, false);
                this.outputField("", 44, true);
                this.outputField(EIGHT_THREE_DIGITS_FLOAT, header.getC2pCodePhaseBias(), 52);
            }
            this.finishHeaderLine(RinexLabels.GLONASS_COD_PHS_BIS);
        }
        if (header.getLeapSeconds() > 0) {
            this.outputField(SIX_DIGITS_INTEGER, header.getLeapSeconds(), 6);
            if (header.getFormatVersion() >= 3.0) {
                this.outputField(SIX_DIGITS_INTEGER, header.getLeapSecondsFuture(), 12);
                this.outputField(SIX_DIGITS_INTEGER, header.getLeapSecondsWeekNum(), 18);
                this.outputField(SIX_DIGITS_INTEGER, header.getLeapSecondsDayNum(), 24);
            }
            this.finishHeaderLine(RinexLabels.LEAP_SECONDS);
        }
        if (header.getNbSat() >= 0) {
            this.outputField(SIX_DIGITS_INTEGER, header.getNbSat(), 6);
            this.finishHeaderLine(RinexLabels.NB_OF_SATELLITES);
        }
        for (Map.Entry<SatInSystem, Map<ObservationType, Integer>> entry : header.getNbObsPerSat().entrySet()) {
            SatInSystem sis = entry.getKey();
            this.outputField(sis.getSystem().getKey(), 4);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, sis.getTwoDigitsRinexPRN(), 6);
            for (Map.Entry<ObservationType, Integer> entry2 : entry.getValue().entrySet()) {
                int next = this.column + 6;
                if (next > 60) {
                    this.finishHeaderLine(RinexLabels.PRN_NB_OF_OBS);
                    this.outputField("", 6, true);
                    next = this.column + 6;
                }
                this.outputField(SIX_DIGITS_INTEGER, (int)entry2.getValue(), next);
            }
            this.finishHeaderLine(RinexLabels.PRN_NB_OF_OBS);
        }
        this.writeHeaderLine("", RinexLabels.END);
    }

    public void writeObservationDataSet(ObservationDataSet observationDataSet) throws IOException {
        if (this.savedHeader == null) {
            throw new OrekitException((Localizable)OrekitMessages.HEADER_NOT_WRITTEN, this.outputName);
        }
        if (!this.pending.isEmpty() && observationDataSet.durationFrom(this.pending.get(0).getDate()) > 1.0E-8) {
            this.processPending();
        }
        this.pending.add(observationDataSet);
    }

    private void processPending() throws IOException {
        if (!this.pending.isEmpty()) {
            if (this.savedHeader.getFormatVersion() < 3.0) {
                this.writePendingRinex2Observations();
            } else {
                this.writePendingRinex34Observations();
            }
            this.pending.clear();
        }
    }

    public void writePendingRinex2Observations() throws IOException {
        ObservationDataSet first = this.pending.get(0);
        DateTimeComponents dtc = first.getDate().getComponents(this.timeScale);
        this.outputField("", 1, true);
        this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getDate().getYear() % 100, 3);
        this.outputField("", 4, true);
        this.outputField(TWO_DIGITS_INTEGER, dtc.getDate().getMonth(), 6);
        this.outputField("", 7, true);
        this.outputField(TWO_DIGITS_INTEGER, dtc.getDate().getDay(), 9);
        this.outputField("", 10, true);
        this.outputField(TWO_DIGITS_INTEGER, dtc.getTime().getHour(), 12);
        this.outputField("", 13, true);
        this.outputField(TWO_DIGITS_INTEGER, dtc.getTime().getMinute(), 15);
        this.outputField(ELEVEN_SEVEN_DIGITS_FLOAT, dtc.getTime().getSecond(), 26);
        this.outputField("", 28, true);
        if (first.getEventFlag() == 0) {
            this.outputField("", 29, true);
        } else {
            this.outputField(ONE_DIGIT_INTEGER, first.getEventFlag(), 29);
        }
        this.outputField(THREE_DIGITS_INTEGER, this.pending.size(), 32);
        boolean offsetWritten = false;
        double clockOffset = first.getRcvrClkOffset();
        for (ObservationDataSet ods : this.pending) {
            int next = this.column + 3;
            if (next > 68) {
                if (clockOffset != 0.0) {
                    this.outputField(TWELVE_NINE_DIGITS_FLOAT, clockOffset, 80);
                }
                offsetWritten = true;
                this.finishLine();
                this.outputField("", 32, true);
                next = this.column + 3;
            }
            this.outputField(ods.getSatellite().getSystem().getKey(), next - 2);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, ods.getSatellite().getTwoDigitsRinexPRN(), next);
        }
        if (!offsetWritten && clockOffset != 0.0) {
            this.outputField("", 68, true);
            this.outputField(TWELVE_NINE_DIGITS_FLOAT, first.getRcvrClkOffset(), 80);
        }
        this.finishLine();
        for (ObservationDataSet ods : this.pending) {
            for (ObservationData od : ods.getObservationData()) {
                int next = this.column + 16;
                if (next > 80) {
                    this.finishLine();
                    next = this.column + 16;
                }
                double scaling = this.getScaling(od.getObservationType(), ods.getSatellite().getSystem());
                this.outputField(FOURTEEN_THREE_DIGITS_FLOAT, scaling * od.getValue(), next - 2);
                if (od.getLossOfLockIndicator() == 0) {
                    this.outputField("", next - 1, true);
                } else {
                    this.outputField(ONE_DIGIT_INTEGER, od.getLossOfLockIndicator(), next - 1);
                }
                if (od.getSignalStrength() == 0) {
                    this.outputField("", next, true);
                    continue;
                }
                this.outputField(ONE_DIGIT_INTEGER, od.getSignalStrength(), next);
            }
            this.finishLine();
        }
    }

    public void writePendingRinex34Observations() throws IOException {
        ObservationDataSet first = this.pending.get(0);
        DateTimeComponents dtc = first.getDate().getComponents(this.timeScale);
        this.outputField(">", 2, true);
        this.outputField(FOUR_DIGITS_INTEGER, dtc.getDate().getYear(), 6);
        this.outputField("", 7, true);
        this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getDate().getMonth(), 9);
        this.outputField("", 10, true);
        this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getDate().getDay(), 12);
        this.outputField("", 13, true);
        this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getTime().getHour(), 15);
        this.outputField("", 16, true);
        this.outputField(PADDED_TWO_DIGITS_INTEGER, dtc.getTime().getMinute(), 18);
        this.outputField(ELEVEN_SEVEN_DIGITS_FLOAT, dtc.getTime().getSecond(), 29);
        this.outputField("", 31, true);
        if (first.getEventFlag() == 0) {
            this.outputField("", 32, true);
        } else {
            this.outputField(ONE_DIGIT_INTEGER, first.getEventFlag(), 32);
        }
        this.outputField(THREE_DIGITS_INTEGER, this.pending.size(), 35);
        if (first.getRcvrClkOffset() != 0.0) {
            this.outputField("", 41, true);
            this.outputField(FIFTEEN_TWELVE_DIGITS_FLOAT, first.getRcvrClkOffset(), 56);
        }
        this.finishLine();
        for (ObservationDataSet ods : this.pending) {
            this.outputField(ods.getSatellite().getSystem().getKey(), 1);
            this.outputField(PADDED_TWO_DIGITS_INTEGER, ods.getSatellite().getTwoDigitsRinexPRN(), 3);
            for (ObservationData od : ods.getObservationData()) {
                int next = this.column + 16;
                double scaling = this.getScaling(od.getObservationType(), ods.getSatellite().getSystem());
                this.outputField(FOURTEEN_THREE_DIGITS_FLOAT, scaling * od.getValue(), next - 2);
                if (od.getLossOfLockIndicator() == 0) {
                    this.outputField("", next - 1, true);
                } else {
                    this.outputField(ONE_DIGIT_INTEGER, od.getLossOfLockIndicator(), next - 1);
                }
                if (od.getSignalStrength() == 0) {
                    this.outputField("", next, true);
                    continue;
                }
                this.outputField(ONE_DIGIT_INTEGER, od.getSignalStrength(), next);
            }
            this.finishLine();
        }
    }

    private void writeHeaderLine(String s, RinexLabels label) throws IOException {
        if (s != null) {
            this.outputField(s, s.length(), true);
            this.finishHeaderLine(label);
        }
    }

    private void writeHeaderLine(Vector3D vector, RinexLabels label) throws IOException {
        if (vector != null) {
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, vector.getX(), 14);
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, vector.getY(), 28);
            this.outputField(FOURTEEN_FOUR_DIGITS_FLOAT, vector.getZ(), 42);
            this.finishHeaderLine(label);
        }
    }

    private void finishHeaderLine(RinexLabels label) throws IOException {
        for (int i = this.column; i < 60; ++i) {
            this.output.append(' ');
        }
        this.output.append(label.getLabel());
        this.finishLine();
    }

    private void finishLine() throws IOException {
        this.output.append(System.lineSeparator());
        ++this.lineNumber;
        this.column = 0;
        for (RinexComment comment : this.savedComments) {
            if (comment.getLineNumber() == this.lineNumber) {
                this.outputField(comment.getText(), 60, true);
                this.output.append(RinexLabels.COMMENT.getLabel());
                this.output.append(System.lineSeparator());
                ++this.lineNumber;
                this.column = 0;
                continue;
            }
            if (comment.getLineNumber() <= this.lineNumber) continue;
            break;
        }
    }

    private void outputField(char c, int next) throws IOException {
        this.outputField(Character.toString(c), next, false);
    }

    private void outputField(String format, int value, int next) throws IOException {
        this.outputField(String.format(Locale.US, format, value), next, false);
    }

    private void outputField(String format, double value, int next) throws IOException {
        if (Double.isNaN(value)) {
            this.outputField("", next, true);
        } else {
            this.outputField(String.format(Locale.US, format, value), next, false);
        }
    }

    private void outputField(String field, int next, boolean leftJustified) throws IOException {
        int padding = next - (field == null ? 0 : field.length()) - this.column;
        if (padding < 0) {
            throw new OrekitException((Localizable)OrekitMessages.FIELD_TOO_LONG, field, next - this.column);
        }
        if (leftJustified && field != null) {
            this.output.append(field);
        }
        for (int i = 0; i < padding; ++i) {
            this.output.append(' ');
        }
        if (!leftJustified && field != null) {
            this.output.append(field);
        }
        this.column = next;
    }

    private double getScaling(ObservationType type, SatelliteSystem system) {
        for (ScaleFactorCorrection scaleFactorCorrection : this.savedHeader.getScaleFactorCorrections(system)) {
            if (!scaleFactorCorrection.getTypesObsScaled().contains((Object)type)) continue;
            return scaleFactorCorrection.getCorrection();
        }
        return 1.0;
    }
}

