/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.observation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.rinex.AppliedDCBS;
import org.orekit.files.rinex.AppliedPCVS;
import org.orekit.files.rinex.observation.GlonassSatelliteChannel;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.files.rinex.observation.PhaseShiftCorrection;
import org.orekit.files.rinex.observation.RinexObservation;
import org.orekit.files.rinex.observation.RinexObservationHeader;
import org.orekit.files.rinex.observation.ScaleFactorCorrection;
import org.orekit.files.rinex.section.RinexLabels;
import org.orekit.files.rinex.utils.parsing.RinexUtils;
import org.orekit.gnss.ObservationTimeScale;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatInSystem;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;

public class RinexObservationParser {
    public static final String DEFAULT_RINEX_2_NAMES = "^\\w{4}\\d{3}[0a-x](?:\\d{2})?\\.\\d{2}[oO]$";
    public static final String DEFAULT_RINEX_3_NAMES = "^\\w{9}_\\w{1}_\\d{11}_\\d{2}\\w_\\d{2}\\w{1}_\\w{2}\\.rnx$";
    private static final int MAX_SAT_PER_RINEX_2_LINE = 12;
    private static final int MAX_OBS_PER_RINEX_2_LINE = 5;
    private final TimeScales timeScales;

    @DefaultDataContext
    public RinexObservationParser() {
        this(DataContext.getDefault().getTimeScales());
    }

    public RinexObservationParser(TimeScales timeScales) {
        this.timeScales = timeScales;
    }

    public RinexObservation parse(DataSource source) {
        Iterable<LineParser> candidateParsers = Collections.singleton(LineParser.VERSION);
        ParseInfo parseInfo = new ParseInfo(source.getName());
        try (Reader reader = source.getOpener().openReaderOnce();
             BufferedReader br = new BufferedReader(reader);){
            ++parseInfo.lineNumber;
            String line = br.readLine();
            while (line != null) {
                block17: {
                    for (LineParser candidate : candidateParsers) {
                        if (!candidate.canHandle.test(line)) continue;
                        try {
                            candidate.parsingMethod.parse(line, parseInfo);
                            ++parseInfo.lineNumber;
                            candidateParsers = (Iterable)candidate.allowedNextProvider.apply(parseInfo);
                            break block17;
                        }
                        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                            throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, parseInfo.lineNumber, source.getName(), line);
                        }
                    }
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, parseInfo.lineNumber, source.getName(), line);
                }
                line = br.readLine();
            }
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getLocalizedMessage());
        }
        return parseInfo.file;
    }

    @FunctionalInterface
    private static interface ParsingMethod {
        public void parse(String var1, ParseInfo var2);
    }

    private static enum LineParser {
        VERSION(line -> RinexLabels.VERSION.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> RinexUtils.parseVersionFileTypeSatelliteSystem(line, parseInfo.name, parseInfo.file.getHeader(), new double[]{2.0, 2.1, 2.11, 2.12, 2.2, 3.0, 3.01, 3.02, 3.03, 3.04, 3.05, 4.0}), LineParser::headerNext),
        PROGRAM(line -> RinexLabels.PROGRAM.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> RinexUtils.parseProgramRunByDate(line, parseInfo.lineNumber, parseInfo.name, parseInfo.timeScales, parseInfo.file.getHeader()), LineParser::headerNext),
        COMMENT(line -> RinexLabels.COMMENT.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> RinexUtils.parseComment(parseInfo.lineNumber, line, parseInfo.file), LineParser::commentNext),
        MARKER_NAME(line -> RinexLabels.MARKER_NAME.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setMarkerName(RinexUtils.parseString(line, 0, 60)), LineParser::headerNext),
        MARKER_NUMBER(line -> RinexLabels.MARKER_NUMBER.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setMarkerNumber(RinexUtils.parseString(line, 0, 20)), LineParser::headerNext),
        MARKER_TYPE(line -> RinexLabels.MARKER_TYPE.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setMarkerType(RinexUtils.parseString(line, 0, 20)), LineParser::headerNext),
        OBSERVER_AGENCY(line -> RinexLabels.OBSERVER_AGENCY.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            ((RinexObservationHeader)parseInfo.file.getHeader()).setObserverName(RinexUtils.parseString(line, 0, 20));
            ((RinexObservationHeader)parseInfo.file.getHeader()).setAgencyName(RinexUtils.parseString(line, 20, 40));
        }, LineParser::headerNext),
        REC_NB_TYPE_VERS(line -> RinexLabels.REC_NB_TYPE_VERS.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            ((RinexObservationHeader)parseInfo.file.getHeader()).setReceiverNumber(RinexUtils.parseString(line, 0, 20));
            ((RinexObservationHeader)parseInfo.file.getHeader()).setReceiverType(RinexUtils.parseString(line, 20, 20));
            ((RinexObservationHeader)parseInfo.file.getHeader()).setReceiverVersion(RinexUtils.parseString(line, 40, 20));
        }, LineParser::headerNext),
        ANT_NB_TYPE(line -> RinexLabels.ANT_NB_TYPE.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            ((RinexObservationHeader)parseInfo.file.getHeader()).setAntennaNumber(RinexUtils.parseString(line, 0, 20));
            ((RinexObservationHeader)parseInfo.file.getHeader()).setAntennaType(RinexUtils.parseString(line, 20, 20));
        }, LineParser::headerNext),
        APPROX_POSITION_XYZ(line -> RinexLabels.APPROX_POSITION_XYZ.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setApproxPos(new Vector3D(RinexUtils.parseDouble(line, 0, 14), RinexUtils.parseDouble(line, 14, 14), RinexUtils.parseDouble(line, 28, 14))), LineParser::headerNext),
        ANTENNA_DELTA_H_E_N(line -> RinexLabels.ANTENNA_DELTA_H_E_N.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            ((RinexObservationHeader)parseInfo.file.getHeader()).setAntennaHeight(RinexUtils.parseDouble(line, 0, 14));
            ((RinexObservationHeader)parseInfo.file.getHeader()).setEccentricities(new Vector2D(RinexUtils.parseDouble(line, 14, 14), RinexUtils.parseDouble(line, 28, 14)));
        }, LineParser::headerNext),
        ANTENNA_DELTA_X_Y_Z(line -> RinexLabels.ANTENNA_DELTA_X_Y_Z.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setAntennaReferencePoint(new Vector3D(RinexUtils.parseDouble(line, 0, 14), RinexUtils.parseDouble(line, 14, 14), RinexUtils.parseDouble(line, 28, 14))), LineParser::headerNext),
        ANTENNA_PHASE_CENTER(line -> RinexLabels.ANTENNA_PHASE_CENTER.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            ((RinexObservationHeader)parseInfo.file.getHeader()).setPhaseCenterSystem(SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 0, 1)));
            ((RinexObservationHeader)parseInfo.file.getHeader()).setObservationCode(RinexUtils.parseString(line, 2, 3));
            ((RinexObservationHeader)parseInfo.file.getHeader()).setAntennaPhaseCenter(new Vector3D(RinexUtils.parseDouble(line, 5, 9), RinexUtils.parseDouble(line, 14, 14), RinexUtils.parseDouble(line, 28, 14)));
        }, LineParser::headerNext),
        ANTENNA_B_SIGHT_XYZ(line -> RinexLabels.ANTENNA_B_SIGHT_XYZ.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setAntennaBSight(new Vector3D(RinexUtils.parseDouble(line, 0, 14), RinexUtils.parseDouble(line, 14, 14), RinexUtils.parseDouble(line, 28, 14))), LineParser::headerNext),
        ANTENNA_ZERODIR_AZI(line -> RinexLabels.ANTENNA_ZERODIR_AZI.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setAntennaAzimuth(FastMath.toRadians((double)RinexUtils.parseDouble(line, 0, 14))), LineParser::headerNext),
        ANTENNA_ZERODIR_XYZ(line -> RinexLabels.ANTENNA_ZERODIR_XYZ.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setAntennaZeroDirection(new Vector3D(RinexUtils.parseDouble(line, 0, 14), RinexUtils.parseDouble(line, 14, 14), RinexUtils.parseDouble(line, 28, 14))), LineParser::headerNext),
        WAVELENGTH_FACT_L1_2(line -> RinexLabels.WAVELENGTH_FACT_L1_2.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {}, LineParser::headerNext),
        OBS_SCALE_FACTOR(line -> RinexLabels.OBS_SCALE_FACTOR.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            int scaleFactor = FastMath.max((int)1, (int)RinexUtils.parseInt(line, 0, 6));
            int nbObsScaleFactor = RinexUtils.parseInt(line, 6, 6);
            ArrayList<ObservationType> types = new ArrayList<ObservationType>(nbObsScaleFactor);
            for (int i = 0; i < nbObsScaleFactor; ++i) {
                types.add(ObservationType.valueOf(RinexUtils.parseString(line, 16 + 6 * i, 2)));
            }
            ((RinexObservationHeader)parseInfo.file.getHeader()).addScaleFactorCorrection(((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem(), new ScaleFactorCorrection(scaleFactor, types));
        }, LineParser::headerNext),
        CENTER_OF_MASS_XYZ(line -> RinexLabels.CENTER_OF_MASS_XYZ.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setCenterMass(new Vector3D(RinexUtils.parseDouble(line, 0, 14), RinexUtils.parseDouble(line, 14, 14), RinexUtils.parseDouble(line, 28, 14))), LineParser::headerNext),
        DOI(line -> RinexLabels.DOI.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setDoi(RinexUtils.parseString(line, 0, 60)), LineParser::headerNext),
        LICENSE(line -> RinexLabels.LICENSE.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setLicense(RinexUtils.parseString(line, 0, 60)), LineParser::headerNext),
        STATION_INFORMATION(line -> RinexLabels.STATION_INFORMATION.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setStationInformation(RinexUtils.parseString(line, 0, 60)), LineParser::headerNext),
        SYS_NB_TYPES_OF_OBSERV(line -> RinexLabels.SYS_NB_TYPES_OF_OBSERV.matches(RinexUtils.getLabel(line)) || RinexLabels.NB_TYPES_OF_OBSERV.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            double version = ((RinexObservationHeader)parseInfo.file.getHeader()).getFormatVersion();
            if (parseInfo.nbTypes < 0) {
                if (version < 3.0) {
                    parseInfo.currentSystem = ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem();
                    parseInfo.nbTypes = RinexUtils.parseInt(line, 0, 6);
                } else {
                    parseInfo.currentSystem = SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 0, 1));
                    parseInfo.nbTypes = RinexUtils.parseInt(line, 3, 3);
                    if (parseInfo.currentSystem != ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem() && ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem() != SatelliteSystem.MIXED) {
                        throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_SATELLITE_SYSTEM, new Object[]{parseInfo.lineNumber, parseInfo.name, ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem(), parseInfo.currentSystem});
                    }
                }
            }
            int firstIndex = version < 3.0 ? 10 : 7;
            int increment = version < 3.0 ? 6 : 4;
            int size = version < 3.0 ? 2 : 3;
            int i = firstIndex;
            while (i + size <= 60 && parseInfo.typesObs.size() < parseInfo.nbTypes) {
                String type = RinexUtils.parseString(line, i, size);
                try {
                    parseInfo.typesObs.add(ObservationType.valueOf(type));
                }
                catch (IllegalArgumentException iae) {
                    throw new OrekitException(iae, OrekitMessages.UNKNOWN_RINEX_FREQUENCY, type, parseInfo.name, parseInfo.lineNumber);
                }
                i += increment;
            }
            if (parseInfo.typesObs.size() == parseInfo.nbTypes) {
                ((RinexObservationHeader)parseInfo.file.getHeader()).setTypeObs(parseInfo.currentSystem, parseInfo.typesObs);
                parseInfo.typesObs.clear();
                parseInfo.nbTypes = -1;
            }
        }, LineParser::headerNbTypesObs),
        SIGNAL_STRENGTH_UNIT(line -> RinexLabels.SIGNAL_STRENGTH_UNIT.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setSignalStrengthUnit(RinexUtils.parseString(line, 0, 20)), LineParser::headerNext),
        INTERVAL(line -> RinexLabels.INTERVAL.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setInterval(RinexUtils.parseDouble(line, 0, 10)), LineParser::headerNext),
        TIME_OF_FIRST_OBS(line -> RinexLabels.TIME_OF_FIRST_OBS.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            if (((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem() == SatelliteSystem.MIXED) {
                try {
                    parseInfo.timeScale = ObservationTimeScale.valueOf(RinexUtils.parseString(line, 48, 3)).getTimeScale(parseInfo.timeScales);
                }
                catch (IllegalArgumentException iae) {
                    throw new OrekitException(iae, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, parseInfo.lineNumber, parseInfo.name, line);
                }
            } else {
                ObservationTimeScale observationTimeScale = ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem().getObservationTimeScale();
                if (observationTimeScale == null) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, parseInfo.lineNumber, parseInfo.name, line);
                }
                parseInfo.timeScale = observationTimeScale.getTimeScale(parseInfo.timeScales);
            }
            ((RinexObservationHeader)parseInfo.file.getHeader()).setTFirstObs(new AbsoluteDate(RinexUtils.parseInt(line, 0, 6), RinexUtils.parseInt(line, 6, 6), RinexUtils.parseInt(line, 12, 6), RinexUtils.parseInt(line, 18, 6), RinexUtils.parseInt(line, 24, 6), RinexUtils.parseDouble(line, 30, 13), parseInfo.timeScale));
        }, LineParser::headerNext),
        TIME_OF_LAST_OBS(line -> RinexLabels.TIME_OF_LAST_OBS.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setTLastObs(new AbsoluteDate(RinexUtils.parseInt(line, 0, 6), RinexUtils.parseInt(line, 6, 6), RinexUtils.parseInt(line, 12, 6), RinexUtils.parseInt(line, 18, 6), RinexUtils.parseInt(line, 24, 6), RinexUtils.parseDouble(line, 30, 13), parseInfo.timeScale)), LineParser::headerNext),
        RCV_CLOCK_OFFS_APPL(line -> RinexLabels.RCV_CLOCK_OFFS_APPL.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setClockOffsetApplied(RinexUtils.parseInt(line, 0, 6) > 0), LineParser::headerNext),
        SYS_DCBS_APPLIED(line -> RinexLabels.SYS_DCBS_APPLIED.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).addAppliedDCBS(new AppliedDCBS(SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 0, 1)), RinexUtils.parseString(line, 2, 17), RinexUtils.parseString(line, 20, 40))), LineParser::headerNext),
        SYS_PCVS_APPLIED(line -> RinexLabels.SYS_PCVS_APPLIED.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).addAppliedPCVS(new AppliedPCVS(SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 0, 1)), RinexUtils.parseString(line, 2, 17), RinexUtils.parseString(line, 20, 40))), LineParser::headerNext),
        SYS_SCALE_FACTOR(line -> RinexLabels.SYS_SCALE_FACTOR.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            int scaleFactor = 1;
            if (parseInfo.nbObsScaleFactor < 0) {
                parseInfo.currentSystem = SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 0, 1));
                scaleFactor = RinexUtils.parseInt(line, 2, 4);
                parseInfo.nbObsScaleFactor = RinexUtils.parseInt(line, 8, 2);
            }
            if (parseInfo.nbObsScaleFactor == 0) {
                parseInfo.typesObsScaleFactor.addAll((Collection)((RinexObservationHeader)parseInfo.file.getHeader()).getTypeObs().get((Object)parseInfo.currentSystem));
            } else {
                for (int i = 11; i < 60 && parseInfo.typesObsScaleFactor.size() < parseInfo.nbObsScaleFactor; i += 4) {
                    parseInfo.typesObsScaleFactor.add(ObservationType.valueOf(RinexUtils.parseString(line, i, 3)));
                }
            }
            if (parseInfo.typesObsScaleFactor.size() >= parseInfo.nbObsScaleFactor) {
                ((RinexObservationHeader)parseInfo.file.getHeader()).addScaleFactorCorrection(parseInfo.currentSystem, new ScaleFactorCorrection(scaleFactor, new ArrayList<ObservationType>(parseInfo.typesObsScaleFactor)));
                parseInfo.nbObsScaleFactor = -1;
                parseInfo.typesObsScaleFactor.clear();
            }
        }, LineParser::headerNext),
        SYS_PHASE_SHIFT(line -> RinexLabels.SYS_PHASE_SHIFT.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            if (parseInfo.phaseShiftNbSat < 0) {
                parseInfo.currentSystem = SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 0, 1));
                String to = RinexUtils.parseString(line, 2, 3);
                parseInfo.phaseShiftTypeObs = to.isEmpty() ? null : ObservationType.valueOf(to.length() < 3 ? "L" + to : to);
                parseInfo.corrPhaseShift = RinexUtils.parseDouble(line, 6, 8);
                parseInfo.phaseShiftNbSat = RinexUtils.parseInt(line, 16, 2);
            }
            int i = 19;
            while (i + 3 < 60 && parseInfo.satPhaseShift.size() < parseInfo.phaseShiftNbSat) {
                SatelliteSystem system = line.charAt(i) == ' ' ? parseInfo.currentSystem : SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, i, 1));
                int prn = RinexUtils.parseInt(line, i + 1, 2);
                parseInfo.satPhaseShift.add(new SatInSystem(system, system == SatelliteSystem.SBAS ? prn + 100 : (system == SatelliteSystem.QZSS ? prn + 192 : prn)));
                i += 4;
            }
            if (parseInfo.satPhaseShift.size() == parseInfo.phaseShiftNbSat) {
                ((RinexObservationHeader)parseInfo.file.getHeader()).addPhaseShiftCorrection(new PhaseShiftCorrection(parseInfo.currentSystem, parseInfo.phaseShiftTypeObs, parseInfo.corrPhaseShift, new ArrayList<SatInSystem>(parseInfo.satPhaseShift)));
                parseInfo.phaseShiftNbSat = -1;
                parseInfo.satPhaseShift.clear();
            }
        }, LineParser::headerPhaseShift),
        GLONASS_SLOT_FRQ_NB(line -> RinexLabels.GLONASS_SLOT_FRQ_NB.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            if (parseInfo.nbGlonass < 0) {
                parseInfo.nbGlonass = RinexUtils.parseInt(line, 0, 3);
            }
            for (int i = 4; i < 60 && ((RinexObservationHeader)parseInfo.file.getHeader()).getGlonassChannels().size() < parseInfo.nbGlonass; i += 7) {
                SatelliteSystem system = SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, i, 1));
                int prn = RinexUtils.parseInt(line, i + 1, 2);
                int k = RinexUtils.parseInt(line, i + 4, 2);
                ((RinexObservationHeader)parseInfo.file.getHeader()).addGlonassChannel(new GlonassSatelliteChannel(new SatInSystem(system, prn), k));
            }
        }, LineParser::headerNext),
        GLONASS_COD_PHS_BIS(line -> RinexLabels.GLONASS_COD_PHS_BIS.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            String c2p;
            String c2c;
            String c1p;
            String c1c = RinexUtils.parseString(line, 1, 3);
            if (!c1c.isEmpty()) {
                ((RinexObservationHeader)parseInfo.file.getHeader()).setC1cCodePhaseBias(RinexUtils.parseDouble(line, 5, 8));
            }
            if (!(c1p = RinexUtils.parseString(line, 14, 3)).isEmpty()) {
                ((RinexObservationHeader)parseInfo.file.getHeader()).setC1pCodePhaseBias(RinexUtils.parseDouble(line, 18, 8));
            }
            if (!(c2c = RinexUtils.parseString(line, 27, 3)).isEmpty()) {
                ((RinexObservationHeader)parseInfo.file.getHeader()).setC2cCodePhaseBias(RinexUtils.parseDouble(line, 31, 8));
            }
            if (!(c2p = RinexUtils.parseString(line, 40, 3)).isEmpty()) {
                ((RinexObservationHeader)parseInfo.file.getHeader()).setC2pCodePhaseBias(RinexUtils.parseDouble(line, 44, 8));
            }
        }, LineParser::headerNext),
        LEAP_SECONDS(line -> RinexLabels.LEAP_SECONDS.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            ((RinexObservationHeader)parseInfo.file.getHeader()).setLeapSeconds(RinexUtils.parseInt(line, 0, 6));
            if (((RinexObservationHeader)parseInfo.file.getHeader()).getFormatVersion() >= 3.0) {
                ((RinexObservationHeader)parseInfo.file.getHeader()).setLeapSecondsFuture(RinexUtils.parseInt(line, 6, 6));
                ((RinexObservationHeader)parseInfo.file.getHeader()).setLeapSecondsWeekNum(RinexUtils.parseInt(line, 12, 6));
                ((RinexObservationHeader)parseInfo.file.getHeader()).setLeapSecondsDayNum(RinexUtils.parseInt(line, 18, 6));
            }
        }, LineParser::headerNext),
        NB_OF_SATELLITES(line -> RinexLabels.NB_OF_SATELLITES.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> ((RinexObservationHeader)parseInfo.file.getHeader()).setNbSat(RinexUtils.parseInt(line, 0, 6)), LineParser::headerNext),
        PRN_NB_OF_OBS(line -> RinexLabels.PRN_NB_OF_OBS.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            String systemName = RinexUtils.parseString(line, 3, 1);
            if (!systemName.isEmpty()) {
                SatelliteSystem system = SatelliteSystem.parseSatelliteSystem(systemName);
                int prn = RinexUtils.parseInt(line, 4, 2);
                parseInfo.currentSat = new SatInSystem(system, system == SatelliteSystem.SBAS ? prn + 100 : (system == SatelliteSystem.QZSS ? prn + 192 : prn));
                parseInfo.nbTypes = 0;
            }
            List<ObservationType> types = ((RinexObservationHeader)parseInfo.file.getHeader()).getTypeObs().get((Object)parseInfo.currentSat.getSystem());
            int firstIndex = 6;
            int increment = 6;
            int size = 6;
            int i = 6;
            while (i + 6 <= 60 && parseInfo.nbTypes < types.size()) {
                String nb = RinexUtils.parseString(line, i, 6);
                if (!nb.isEmpty()) {
                    ((RinexObservationHeader)parseInfo.file.getHeader()).setNbObsPerSatellite(parseInfo.currentSat, types.get(parseInfo.nbTypes), RinexUtils.parseInt(line, i, 6));
                }
                ++parseInfo.nbTypes;
                i += 6;
            }
        }, LineParser::headerNext),
        END(line -> RinexLabels.END.matches(RinexUtils.getLabel(line)), (line, parseInfo) -> {
            parseInfo.headerCompleted = true;
            double version = ((RinexObservationHeader)parseInfo.file.getHeader()).getFormatVersion();
            if (version < 3.0 ? ((RinexObservationHeader)parseInfo.file.getHeader()).getMarkerName() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getObserverName() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getReceiverNumber() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getAntennaNumber() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getTFirstObs() == null || version < 2.2 && ((RinexObservationHeader)parseInfo.file.getHeader()).getApproxPos() == null || version < 2.2 && Double.isNaN(((RinexObservationHeader)parseInfo.file.getHeader()).getAntennaHeight()) || ((RinexObservationHeader)parseInfo.file.getHeader()).getTypeObs().isEmpty() : ((RinexObservationHeader)parseInfo.file.getHeader()).getMarkerName() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getObserverName() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getReceiverNumber() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getAntennaNumber() == null || Double.isNaN(((RinexObservationHeader)parseInfo.file.getHeader()).getAntennaHeight()) && ((RinexObservationHeader)parseInfo.file.getHeader()).getAntennaReferencePoint() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getTFirstObs() == null || ((RinexObservationHeader)parseInfo.file.getHeader()).getTypeObs().isEmpty()) {
                throw new OrekitException((Localizable)OrekitMessages.INCOMPLETE_HEADER, parseInfo.name);
            }
        }, LineParser::headerEndNext),
        RINEX_2_DATA_SAT_LIST(line -> true, (line, parseInfo) -> {
            for (int index = 32; parseInfo.satObs.size() < parseInfo.nbSatObs && index < 68; index += 3) {
                SatelliteSystem system;
                SatelliteSystem satelliteSystem = system = line.charAt(index) == ' ' ? ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem() : SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, index, 1));
                if (system != ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem() && ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem() != SatelliteSystem.MIXED) {
                    throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_SATELLITE_SYSTEM, new Object[]{parseInfo.lineNumber, parseInfo.name, ((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem(), system});
                }
                int prn = RinexUtils.parseInt(line, index + 1, 2);
                SatInSystem satellite = new SatInSystem(system, system == SatelliteSystem.SBAS ? prn + 100 : prn);
                parseInfo.satObs.add(satellite);
                int nbObservables = ((RinexObservationHeader)parseInfo.file.getHeader()).getTypeObs().get((Object)((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem()).size();
                int nbLines = (nbObservables + 5 - 1) / 5;
                parseInfo.nextObsStartLineNumber += nbLines;
            }
        }, LineParser::first2),
        RINEX_2_DATA_FIRST(line -> true, (line, parseInfo) -> {
            parseInfo.eventFlag = RinexUtils.parseInt(line, 28, 1);
            parseInfo.nbSatObs = RinexUtils.parseInt(line, 29, 3);
            int nbLinesSat = (parseInfo.nbSatObs + 12 - 1) / 12;
            if (parseInfo.eventFlag < 2) {
                parseInfo.specialRecord = false;
                parseInfo.cycleSlip = false;
                int nbSat = ((RinexObservationHeader)parseInfo.file.getHeader()).getNbSat();
                if (nbSat != -1 && parseInfo.nbSatObs > nbSat) {
                    throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_NUMBER_OF_SATS, parseInfo.lineNumber, parseInfo.name, parseInfo.nbSatObs, nbSat);
                }
                parseInfo.nextObsStartLineNumber = parseInfo.lineNumber + nbLinesSat;
                parseInfo.rcvrClkOffset = RinexUtils.parseDouble(line, 68, 12);
                if (Double.isNaN(parseInfo.rcvrClkOffset)) {
                    parseInfo.rcvrClkOffset = 0.0;
                }
            } else if (parseInfo.eventFlag < 6) {
                parseInfo.specialRecord = true;
                parseInfo.cycleSlip = false;
                parseInfo.nextObsStartLineNumber = parseInfo.lineNumber + parseInfo.nbSatObs + 1;
            } else if (parseInfo.eventFlag == 6) {
                parseInfo.specialRecord = false;
                parseInfo.cycleSlip = true;
                parseInfo.nextObsStartLineNumber = parseInfo.lineNumber + nbLinesSat;
            } else {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, parseInfo.lineNumber, parseInfo.name, line);
            }
            parseInfo.satObs.clear();
            if (!parseInfo.specialRecord) {
                parseInfo.setTObs(new AbsoluteDate(RinexUtils.convert2DigitsYear(RinexUtils.parseInt(line, 1, 2)), RinexUtils.parseInt(line, 4, 2), RinexUtils.parseInt(line, 7, 2), RinexUtils.parseInt(line, 10, 2), RinexUtils.parseInt(line, 13, 2), RinexUtils.parseDouble(line, 15, 11), parseInfo.timeScale));
                LineParser.RINEX_2_DATA_SAT_LIST.parsingMethod.parse(line, parseInfo);
            }
            parseInfo.indexObsSat = 0;
            parseInfo.observations.clear();
        }, LineParser::first2),
        RINEX_2_IGNORED_SPECIAL_RECORD(line -> true, (line, parseInfo) -> {}, LineParser::ignore2),
        RINEX_2_OBSERVATION(line -> true, (line, parseInfo) -> {
            List<ObservationType> types = ((RinexObservationHeader)parseInfo.file.getHeader()).getTypeObs().get((Object)((RinexObservationHeader)parseInfo.file.getHeader()).getSatelliteSystem());
            for (int index = 0; parseInfo.observations.size() < types.size() && index < 80; index += 16) {
                ObservationData observationData;
                if (parseInfo.cycleSlip) {
                    observationData = null;
                } else {
                    ObservationType type = types.get(parseInfo.observations.size());
                    double scaling = LineParser.getScaling(parseInfo, type, parseInfo.currentSystem);
                    observationData = new ObservationData(type, scaling * RinexUtils.parseDouble(line, index, 14), RinexUtils.parseInt(line, index + 14, 1), RinexUtils.parseInt(line, index + 15, 1));
                }
                parseInfo.observations.add(observationData);
            }
            if (parseInfo.observations.size() == types.size()) {
                if (!parseInfo.cycleSlip) {
                    parseInfo.file.addObservationDataSet(new ObservationDataSet((SatInSystem)parseInfo.satObs.get(parseInfo.indexObsSat), parseInfo.tObs, parseInfo.eventFlag, parseInfo.rcvrClkOffset, new ArrayList<ObservationData>(parseInfo.observations)));
                }
                parseInfo.indexObsSat++;
                parseInfo.observations.clear();
            }
        }, LineParser::observation2),
        RINEX_3_OBSERVATION(line -> true, (line, parseInfo) -> {
            SatelliteSystem system = SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 0, 1));
            int prn = RinexUtils.parseInt(line, 1, 2);
            SatInSystem sat = new SatInSystem(system, system == SatelliteSystem.SBAS ? prn + 100 : (system == SatelliteSystem.QZSS ? prn + 192 : prn));
            List<ObservationType> types = ((RinexObservationHeader)parseInfo.file.getHeader()).getTypeObs().get((Object)sat.getSystem());
            int index = 3;
            while (parseInfo.observations.size() < types.size()) {
                ObservationData observationData;
                if (parseInfo.specialRecord || parseInfo.cycleSlip) {
                    observationData = null;
                } else {
                    ObservationType type = types.get(parseInfo.observations.size());
                    double scaling = LineParser.getScaling(parseInfo, type, sat.getSystem());
                    observationData = new ObservationData(type, scaling * RinexUtils.parseDouble(line, index, 14), RinexUtils.parseInt(line, index + 14, 1), RinexUtils.parseInt(line, index + 15, 1));
                }
                parseInfo.observations.add(observationData);
                index += 16;
            }
            if (!parseInfo.specialRecord && !parseInfo.cycleSlip) {
                parseInfo.file.addObservationDataSet(new ObservationDataSet(sat, parseInfo.tObs, parseInfo.eventFlag, parseInfo.rcvrClkOffset, new ArrayList<ObservationData>(parseInfo.observations)));
            }
            parseInfo.observations.clear();
        }, LineParser::observation3),
        RINEX_3_DATA_FIRST(line -> line.startsWith(">"), (line, parseInfo) -> {
            parseInfo.eventFlag = RinexUtils.parseInt(line, 31, 1);
            parseInfo.nbSatObs = RinexUtils.parseInt(line, 32, 3);
            if (parseInfo.eventFlag < 2) {
                parseInfo.specialRecord = false;
                parseInfo.cycleSlip = false;
                int nbSat = ((RinexObservationHeader)parseInfo.file.getHeader()).getNbSat();
                if (nbSat != -1 && parseInfo.nbSatObs > nbSat) {
                    throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_NUMBER_OF_SATS, parseInfo.lineNumber, parseInfo.name, parseInfo.nbSatObs, nbSat);
                }
                parseInfo.nextObsStartLineNumber = parseInfo.lineNumber + parseInfo.nbSatObs + 1;
                parseInfo.rcvrClkOffset = RinexUtils.parseDouble(line, 41, 15);
                if (Double.isNaN(parseInfo.rcvrClkOffset)) {
                    parseInfo.rcvrClkOffset = 0.0;
                }
            } else if (parseInfo.eventFlag < 6) {
                parseInfo.specialRecord = true;
                parseInfo.cycleSlip = false;
                parseInfo.nextObsStartLineNumber = parseInfo.lineNumber + parseInfo.nbSatObs + 1;
            } else if (parseInfo.eventFlag == 6) {
                parseInfo.specialRecord = false;
                parseInfo.cycleSlip = true;
                parseInfo.nextObsStartLineNumber = parseInfo.lineNumber + parseInfo.nbSatObs + 1;
            } else {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, parseInfo.lineNumber, parseInfo.name, line);
            }
            parseInfo.satObs.clear();
            if (!parseInfo.specialRecord) {
                parseInfo.setTObs(new AbsoluteDate(RinexUtils.parseInt(line, 2, 4), RinexUtils.parseInt(line, 7, 2), RinexUtils.parseInt(line, 10, 2), RinexUtils.parseInt(line, 13, 2), RinexUtils.parseInt(line, 16, 2), RinexUtils.parseDouble(line, 18, 11), parseInfo.timeScale));
            }
            parseInfo.observations.clear();
        }, parseInfo -> Collections.singleton(RINEX_3_OBSERVATION));

        private final Predicate<String> canHandle;
        private final ParsingMethod parsingMethod;
        private final Function<ParseInfo, Iterable<LineParser>> allowedNextProvider;

        private LineParser(Predicate<String> canHandle, ParsingMethod parsingMethod, Function<ParseInfo, Iterable<LineParser>> allowedNextProvider) {
            this.canHandle = canHandle;
            this.parsingMethod = parsingMethod;
            this.allowedNextProvider = allowedNextProvider;
        }

        private static Iterable<LineParser> commentNext(ParseInfo parseInfo) {
            return parseInfo.headerCompleted ? LineParser.headerEndNext(parseInfo) : LineParser.headerNext(parseInfo);
        }

        private static Iterable<LineParser> headerNext(ParseInfo parseInfo) {
            if (((RinexObservationHeader)parseInfo.file.getHeader()).getFormatVersion() < 3.0) {
                return Arrays.asList(PROGRAM, COMMENT, MARKER_NAME, MARKER_NUMBER, MARKER_TYPE, OBSERVER_AGENCY, REC_NB_TYPE_VERS, ANT_NB_TYPE, APPROX_POSITION_XYZ, ANTENNA_DELTA_H_E_N, ANTENNA_DELTA_X_Y_Z, ANTENNA_B_SIGHT_XYZ, WAVELENGTH_FACT_L1_2, OBS_SCALE_FACTOR, CENTER_OF_MASS_XYZ, SYS_NB_TYPES_OF_OBSERV, INTERVAL, TIME_OF_FIRST_OBS, TIME_OF_LAST_OBS, RCV_CLOCK_OFFS_APPL, LEAP_SECONDS, NB_OF_SATELLITES, PRN_NB_OF_OBS, END);
            }
            if (((RinexObservationHeader)parseInfo.file.getHeader()).getFormatVersion() < 4.0) {
                return Arrays.asList(PROGRAM, COMMENT, MARKER_NAME, MARKER_NUMBER, MARKER_TYPE, OBSERVER_AGENCY, REC_NB_TYPE_VERS, ANT_NB_TYPE, APPROX_POSITION_XYZ, ANTENNA_DELTA_H_E_N, ANTENNA_DELTA_X_Y_Z, ANTENNA_PHASE_CENTER, ANTENNA_B_SIGHT_XYZ, ANTENNA_ZERODIR_AZI, ANTENNA_ZERODIR_XYZ, CENTER_OF_MASS_XYZ, SYS_NB_TYPES_OF_OBSERV, SIGNAL_STRENGTH_UNIT, INTERVAL, TIME_OF_FIRST_OBS, TIME_OF_LAST_OBS, RCV_CLOCK_OFFS_APPL, SYS_DCBS_APPLIED, SYS_PCVS_APPLIED, SYS_SCALE_FACTOR, SYS_PHASE_SHIFT, GLONASS_SLOT_FRQ_NB, GLONASS_COD_PHS_BIS, LEAP_SECONDS, NB_OF_SATELLITES, PRN_NB_OF_OBS, END);
            }
            return Arrays.asList(PROGRAM, COMMENT, MARKER_NAME, MARKER_NUMBER, MARKER_TYPE, OBSERVER_AGENCY, REC_NB_TYPE_VERS, ANT_NB_TYPE, APPROX_POSITION_XYZ, ANTENNA_DELTA_H_E_N, ANTENNA_DELTA_X_Y_Z, ANTENNA_PHASE_CENTER, ANTENNA_B_SIGHT_XYZ, ANTENNA_ZERODIR_AZI, ANTENNA_ZERODIR_XYZ, CENTER_OF_MASS_XYZ, DOI, LICENSE, STATION_INFORMATION, SYS_NB_TYPES_OF_OBSERV, SIGNAL_STRENGTH_UNIT, INTERVAL, TIME_OF_FIRST_OBS, TIME_OF_LAST_OBS, RCV_CLOCK_OFFS_APPL, SYS_DCBS_APPLIED, SYS_PCVS_APPLIED, SYS_SCALE_FACTOR, SYS_PHASE_SHIFT, GLONASS_SLOT_FRQ_NB, GLONASS_COD_PHS_BIS, LEAP_SECONDS, NB_OF_SATELLITES, PRN_NB_OF_OBS, END);
        }

        private static Iterable<LineParser> headerEndNext(ParseInfo parseInfo) {
            return Collections.singleton(((RinexObservationHeader)parseInfo.file.getHeader()).getFormatVersion() < 3.0 ? RINEX_2_DATA_FIRST : RINEX_3_DATA_FIRST);
        }

        private static Iterable<LineParser> headerNbTypesObs(ParseInfo parseInfo) {
            if (parseInfo.typesObs.size() < parseInfo.nbTypes) {
                return Arrays.asList(COMMENT, SYS_NB_TYPES_OF_OBSERV);
            }
            return LineParser.headerNext(parseInfo);
        }

        private static Iterable<LineParser> headerPhaseShift(ParseInfo parseInfo) {
            if (parseInfo.satPhaseShift.size() < parseInfo.phaseShiftNbSat) {
                return Arrays.asList(COMMENT, SYS_PHASE_SHIFT);
            }
            return LineParser.headerNext(parseInfo);
        }

        private static Iterable<LineParser> first2(ParseInfo parseInfo) {
            if (parseInfo.specialRecord) {
                return Collections.singleton(RINEX_2_IGNORED_SPECIAL_RECORD);
            }
            if (parseInfo.satObs.size() < parseInfo.nbSatObs) {
                return Collections.singleton(RINEX_2_DATA_SAT_LIST);
            }
            return Collections.singleton(RINEX_2_OBSERVATION);
        }

        private static Iterable<LineParser> ignore2(ParseInfo parseInfo) {
            if (parseInfo.lineNumber < parseInfo.nextObsStartLineNumber) {
                return Collections.singleton(RINEX_2_IGNORED_SPECIAL_RECORD);
            }
            return Arrays.asList(COMMENT, RINEX_2_DATA_FIRST);
        }

        private static Iterable<LineParser> observation2(ParseInfo parseInfo) {
            if (parseInfo.lineNumber < parseInfo.nextObsStartLineNumber) {
                return Collections.singleton(RINEX_2_OBSERVATION);
            }
            return Arrays.asList(COMMENT, RINEX_2_DATA_FIRST);
        }

        private static Iterable<LineParser> observation3(ParseInfo parseInfo) {
            if (parseInfo.lineNumber < parseInfo.nextObsStartLineNumber) {
                return Collections.singleton(RINEX_3_OBSERVATION);
            }
            return Arrays.asList(COMMENT, RINEX_3_DATA_FIRST);
        }

        private static double getScaling(ParseInfo parseInfo, ObservationType type, SatelliteSystem system) {
            for (ScaleFactorCorrection scaleFactorCorrection : ((RinexObservationHeader)parseInfo.file.getHeader()).getScaleFactorCorrections(system)) {
                if (!scaleFactorCorrection.getTypesObsScaled().contains((Object)type)) continue;
                return 1.0 / scaleFactorCorrection.getCorrection();
            }
            return 1.0;
        }
    }

    private class ParseInfo {
        private final String name;
        private final TimeScales timeScales;
        private int lineNumber;
        private final RinexObservation file;
        private AbsoluteDate tObs;
        private boolean tFirstFixed;
        private boolean tLastFixed;
        private double rcvrClkOffset;
        private TimeScale timeScale;
        private int nbTypes;
        private int nbSatObs;
        private int nbObsScaleFactor;
        private int indexObsSat;
        private int nextObsStartLineNumber;
        private SatelliteSystem currentSystem;
        private int phaseShiftNbSat;
        private int nbGlonass;
        private final List<SatInSystem> satPhaseShift;
        private ObservationType phaseShiftTypeObs;
        private double corrPhaseShift;
        private boolean headerCompleted;
        private boolean specialRecord;
        private boolean cycleSlip;
        private int eventFlag;
        private final List<ObservationType> typesObsScaleFactor;
        private final List<ObservationType> typesObs;
        private final List<ObservationData> observations;
        private final List<SatInSystem> satObs;
        private SatInSystem currentSat;

        ParseInfo(String name) {
            this.name = name;
            this.timeScales = RinexObservationParser.this.timeScales;
            this.file = new RinexObservation();
            this.lineNumber = 0;
            this.tObs = AbsoluteDate.PAST_INFINITY;
            this.tFirstFixed = false;
            this.tLastFixed = false;
            this.timeScale = null;
            this.nbTypes = -1;
            this.nbSatObs = -1;
            this.nbGlonass = -1;
            this.phaseShiftNbSat = -1;
            this.nbObsScaleFactor = -1;
            this.nextObsStartLineNumber = -1;
            this.typesObs = new ArrayList<ObservationType>();
            this.observations = new ArrayList<ObservationData>();
            this.satPhaseShift = new ArrayList<SatInSystem>();
            this.typesObsScaleFactor = new ArrayList<ObservationType>();
            this.satObs = new ArrayList<SatInSystem>();
        }

        private void setTObs(AbsoluteDate rawDate) {
            RinexObservationHeader header = (RinexObservationHeader)this.file.getHeader();
            if (header.getClockOffsetApplied()) {
                this.tObs = rawDate;
            } else {
                if (FastMath.abs((double)rawDate.durationFrom(header.getTFirstObs())) < 1.0E-6 && !this.tFirstFixed) {
                    header.setTFirstObs(header.getTFirstObs().shiftedBy(-this.rcvrClkOffset));
                    this.tFirstFixed = true;
                }
                if (FastMath.abs((double)rawDate.durationFrom(header.getTLastObs())) < 1.0E-6 && !this.tLastFixed) {
                    header.setTLastObs(header.getTLastObs().shiftedBy(-this.rcvrClkOffset));
                    this.tLastFixed = true;
                }
                this.tObs = rawDate.shiftedBy(-this.rcvrClkOffset);
            }
        }
    }
}

