/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.observation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.orekit.files.rinex.AppliedDCBS;
import org.orekit.files.rinex.AppliedPCVS;
import org.orekit.files.rinex.observation.GlonassSatelliteChannel;
import org.orekit.files.rinex.observation.PhaseShiftCorrection;
import org.orekit.files.rinex.observation.ScaleFactorCorrection;
import org.orekit.files.rinex.section.RinexBaseHeader;
import org.orekit.files.rinex.utils.RinexFileType;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatInSystem;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;

public class RinexObservationHeader
extends RinexBaseHeader {
    private String markerName;
    private String markerNumber;
    private String markerType;
    private String observerName;
    private String agencyName;
    private String receiverNumber;
    private String receiverType;
    private String receiverVersion;
    private String antennaNumber;
    private String antennaType;
    private Vector3D approxPos;
    private double antennaHeight;
    private Vector2D eccentricities;
    private Vector3D antRefPoint;
    private SatelliteSystem phaseCenterSystem;
    private String observationCode;
    private Vector3D antennaPhaseCenter;
    private Vector3D antennaBSight;
    private double antennaAzimuth = Double.NaN;
    private Vector3D antennaZeroDirection;
    private Vector3D centerMass;
    private String signalStrengthUnit;
    private double interval;
    private AbsoluteDate tFirstObs;
    private AbsoluteDate tLastObs;
    private boolean clockOffsetApplied = false;
    private final List<AppliedDCBS> listAppliedDCBS;
    private final List<AppliedPCVS> listAppliedPCVS;
    private final List<PhaseShiftCorrection> phaseShiftCorrections;
    private final Map<SatelliteSystem, List<ScaleFactorCorrection>> scaleFactorCorrections;
    private final List<GlonassSatelliteChannel> glonassChannels;
    private int nbSat = -1;
    private final Map<SatInSystem, Map<ObservationType, Integer>> nbObsPerSat;
    private final Map<SatelliteSystem, List<ObservationType>> mapTypeObs;
    private int leapSeconds = 0;
    private int leapSecondsFuture;
    private int leapSecondsWeekNum;
    private int leapSecondsDayNum;
    private double c1cCodePhaseBias;
    private double c1pCodePhaseBias;
    private double c2cCodePhaseBias;
    private double c2pCodePhaseBias;

    public RinexObservationHeader() {
        super(RinexFileType.OBSERVATION);
        this.antennaHeight = Double.NaN;
        this.eccentricities = Vector2D.ZERO;
        this.interval = Double.NaN;
        this.listAppliedDCBS = new ArrayList<AppliedDCBS>();
        this.listAppliedPCVS = new ArrayList<AppliedPCVS>();
        this.phaseShiftCorrections = new ArrayList<PhaseShiftCorrection>();
        this.scaleFactorCorrections = new HashMap<SatelliteSystem, List<ScaleFactorCorrection>>();
        this.glonassChannels = new ArrayList<GlonassSatelliteChannel>();
        this.nbObsPerSat = new HashMap<SatInSystem, Map<ObservationType, Integer>>();
        this.mapTypeObs = new HashMap<SatelliteSystem, List<ObservationType>>();
        this.tLastObs = AbsoluteDate.FUTURE_INFINITY;
        this.c1cCodePhaseBias = Double.NaN;
        this.c1pCodePhaseBias = Double.NaN;
        this.c2cCodePhaseBias = Double.NaN;
        this.c2pCodePhaseBias = Double.NaN;
    }

    public void setMarkerName(String markerName) {
        this.markerName = markerName;
    }

    public String getMarkerName() {
        return this.markerName;
    }

    public void setMarkerNumber(String markerNumber) {
        this.markerNumber = markerNumber;
    }

    public String getMarkerNumber() {
        return this.markerNumber;
    }

    public void setObserverName(String observerName) {
        this.observerName = observerName;
    }

    public String getObserverName() {
        return this.observerName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    public String getAgencyName() {
        return this.agencyName;
    }

    public void setReceiverNumber(String receiverNumber) {
        this.receiverNumber = receiverNumber;
    }

    public String getReceiverNumber() {
        return this.receiverNumber;
    }

    public void setReceiverType(String receiverType) {
        this.receiverType = receiverType;
    }

    public String getReceiverType() {
        return this.receiverType;
    }

    public void setReceiverVersion(String receiverVersion) {
        this.receiverVersion = receiverVersion;
    }

    public String getReceiverVersion() {
        return this.receiverVersion;
    }

    public void setAntennaNumber(String antennaNumber) {
        this.antennaNumber = antennaNumber;
    }

    public String getAntennaNumber() {
        return this.antennaNumber;
    }

    public void setAntennaType(String antennaType) {
        this.antennaType = antennaType;
    }

    public String getAntennaType() {
        return this.antennaType;
    }

    public void setApproxPos(Vector3D approxPos) {
        this.approxPos = approxPos;
    }

    public Vector3D getApproxPos() {
        return this.approxPos;
    }

    public void setAntennaHeight(double antennaHeight) {
        this.antennaHeight = antennaHeight;
    }

    public double getAntennaHeight() {
        return this.antennaHeight;
    }

    public void setEccentricities(Vector2D eccentricities) {
        this.eccentricities = eccentricities;
    }

    public Vector2D getEccentricities() {
        return this.eccentricities;
    }

    @Deprecated
    public void setClkOffset(int clkOffset) {
        this.setClockOffsetApplied(clkOffset > 0);
    }

    @Deprecated
    public int getClkOffset() {
        return this.getClockOffsetApplied() ? 1 : 0;
    }

    public void setClockOffsetApplied(boolean clockOffsetApplied) {
        this.clockOffsetApplied = clockOffsetApplied;
    }

    public boolean getClockOffsetApplied() {
        return this.clockOffsetApplied;
    }

    public void setInterval(double interval) {
        this.interval = interval;
    }

    public double getInterval() {
        return this.interval;
    }

    public void setTFirstObs(AbsoluteDate firstObs) {
        this.tFirstObs = firstObs;
    }

    public AbsoluteDate getTFirstObs() {
        return this.tFirstObs;
    }

    public void setTLastObs(AbsoluteDate lastObs) {
        this.tLastObs = lastObs;
    }

    public AbsoluteDate getTLastObs() {
        return this.tLastObs;
    }

    public void setLeapSeconds(int leapSeconds) {
        this.leapSeconds = leapSeconds;
    }

    public int getLeapSeconds() {
        return this.leapSeconds;
    }

    public void setMarkerType(String markerType) {
        this.markerType = markerType;
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public void setAntennaReferencePoint(Vector3D refPoint) {
        this.antRefPoint = refPoint;
    }

    public Vector3D getAntennaReferencePoint() {
        return this.antRefPoint;
    }

    public void setPhaseCenterSystem(SatelliteSystem phaseCenterSystem) {
        this.phaseCenterSystem = phaseCenterSystem;
    }

    public SatelliteSystem getPhaseCenterSystem() {
        return this.phaseCenterSystem;
    }

    public void setObservationCode(String observationCode) {
        this.observationCode = observationCode;
    }

    public String getObservationCode() {
        return this.observationCode;
    }

    public void setAntennaPhaseCenter(Vector3D antennaPhaseCenter) {
        this.antennaPhaseCenter = antennaPhaseCenter;
    }

    public Vector3D getAntennaPhaseCenter() {
        return this.antennaPhaseCenter;
    }

    public void setAntennaBSight(Vector3D antennaBSight) {
        this.antennaBSight = antennaBSight;
    }

    public Vector3D getAntennaBSight() {
        return this.antennaBSight;
    }

    public void setAntennaAzimuth(double antennaAzimuth) {
        this.antennaAzimuth = antennaAzimuth;
    }

    public double getAntennaAzimuth() {
        return this.antennaAzimuth;
    }

    public void setAntennaZeroDirection(Vector3D antennaZeroDirection) {
        this.antennaZeroDirection = antennaZeroDirection;
    }

    public Vector3D getAntennaZeroDirection() {
        return this.antennaZeroDirection;
    }

    public void setCenterMass(Vector3D centerMass) {
        this.centerMass = centerMass;
    }

    public Vector3D getCenterMass() {
        return this.centerMass;
    }

    public void setSignalStrengthUnit(String signalStrengthUnit) {
        this.signalStrengthUnit = signalStrengthUnit;
    }

    public String getSignalStrengthUnit() {
        return this.signalStrengthUnit;
    }

    public void setLeapSecondsFuture(int leapSecondsFuture) {
        this.leapSecondsFuture = leapSecondsFuture;
    }

    public int getLeapSecondsFuture() {
        return this.leapSecondsFuture;
    }

    public void setLeapSecondsWeekNum(int leapSecondsWeekNum) {
        this.leapSecondsWeekNum = leapSecondsWeekNum;
    }

    public int getLeapSecondsWeekNum() {
        return this.leapSecondsWeekNum;
    }

    public void setLeapSecondsDayNum(int leapSecondsDayNum) {
        this.leapSecondsDayNum = leapSecondsDayNum;
    }

    public int getLeapSecondsDayNum() {
        return this.leapSecondsDayNum;
    }

    public void addAppliedDCBS(AppliedDCBS appliedDCBS) {
        this.listAppliedDCBS.add(appliedDCBS);
    }

    public List<AppliedDCBS> getListAppliedDCBS() {
        return Collections.unmodifiableList(this.listAppliedDCBS);
    }

    public void addAppliedPCVS(AppliedPCVS appliedPCVS) {
        this.listAppliedPCVS.add(appliedPCVS);
    }

    public List<AppliedPCVS> getListAppliedPCVS() {
        return Collections.unmodifiableList(this.listAppliedPCVS);
    }

    public void addPhaseShiftCorrection(PhaseShiftCorrection phaseShiftCorrection) {
        this.phaseShiftCorrections.add(phaseShiftCorrection);
    }

    public List<PhaseShiftCorrection> getPhaseShiftCorrections() {
        return Collections.unmodifiableList(this.phaseShiftCorrections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScaleFactorCorrection(SatelliteSystem satelliteSystem, ScaleFactorCorrection scaleFactorCorrection) {
        List sfc;
        Map<SatelliteSystem, List<ScaleFactorCorrection>> map = this.scaleFactorCorrections;
        synchronized (map) {
            sfc = this.scaleFactorCorrections.computeIfAbsent(satelliteSystem, k -> new ArrayList());
        }
        sfc.add(scaleFactorCorrection);
    }

    public List<ScaleFactorCorrection> getScaleFactorCorrections(SatelliteSystem satelliteSystem) {
        List<ScaleFactorCorrection> sfc = this.scaleFactorCorrections.get((Object)satelliteSystem);
        return sfc == null ? Collections.emptyList() : Collections.unmodifiableList(sfc);
    }

    public void addGlonassChannel(GlonassSatelliteChannel glonassChannel) {
        this.glonassChannels.add(glonassChannel);
    }

    public List<GlonassSatelliteChannel> getGlonassChannels() {
        return Collections.unmodifiableList(this.glonassChannels);
    }

    public void setNbSat(int nbSat) {
        this.nbSat = nbSat;
    }

    public int getNbSat() {
        return this.nbSat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNbObsPerSatellite(SatInSystem sat, ObservationType type, int nbObs) {
        Map satNbObs;
        Map<SatInSystem, Map<ObservationType, Integer>> map = this.nbObsPerSat;
        synchronized (map) {
            satNbObs = this.nbObsPerSat.computeIfAbsent(sat, k -> new HashMap());
        }
        satNbObs.put(type, nbObs);
    }

    public Map<SatInSystem, Map<ObservationType, Integer>> getNbObsPerSat() {
        return Collections.unmodifiableMap(this.nbObsPerSat);
    }

    public void setTypeObs(SatelliteSystem system, List<ObservationType> types) {
        this.mapTypeObs.put(system, new ArrayList<ObservationType>(types));
    }

    public Map<SatelliteSystem, List<ObservationType>> getTypeObs() {
        return Collections.unmodifiableMap(this.mapTypeObs);
    }

    public void setC1cCodePhaseBias(double c1cCodePhaseBias) {
        this.c1cCodePhaseBias = c1cCodePhaseBias;
    }

    public double getC1cCodePhaseBias() {
        return this.c1cCodePhaseBias;
    }

    public void setC1pCodePhaseBias(double c1pCodePhaseBias) {
        this.c1pCodePhaseBias = c1pCodePhaseBias;
    }

    public double getC1pCodePhaseBias() {
        return this.c1pCodePhaseBias;
    }

    public void setC2cCodePhaseBias(double c2cCodePhaseBias) {
        this.c2cCodePhaseBias = c2cCodePhaseBias;
    }

    public double getC2cCodePhaseBias() {
        return this.c2cCodePhaseBias;
    }

    public void setC2pCodePhaseBias(double c2pCodePhaseBias) {
        this.c2pCodePhaseBias = c2pCodePhaseBias;
    }

    public double getC2pCodePhaseBias() {
        return this.c2pCodePhaseBias;
    }
}

