/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.observation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.rinex.RinexFile;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.files.rinex.observation.RinexObservationHeader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ClockOffset;
import org.orekit.time.SampledClockModel;

public class RinexObservation
extends RinexFile<RinexObservationHeader> {
    private final List<ObservationDataSet> observations = new ArrayList<ObservationDataSet>();

    public RinexObservation() {
        super(new RinexObservationHeader());
    }

    public List<ObservationDataSet> getObservationDataSets() {
        return Collections.unmodifiableList(this.observations);
    }

    public void addObservationDataSet(ObservationDataSet observationsDataSet) {
        AbsoluteDate last;
        double acceptable;
        AbsoluteDate previous;
        double factor;
        RinexObservationHeader header = (RinexObservationHeader)this.getHeader();
        AbsoluteDate current = observationsDataSet.getDate();
        if (!this.observations.isEmpty() && FastMath.abs((double)((factor = current.durationFrom(previous = this.observations.get(this.observations.size() - 1).getDate()) / header.getInterval()) - (acceptable = FastMath.max((double)0.0, (double)FastMath.rint((double)factor))))) > 0.01) {
            throw new OrekitIllegalArgumentException(OrekitMessages.INCONSISTENT_SAMPLING_DATE, previous.shiftedBy(acceptable * header.getInterval()), current);
        }
        AbsoluteDate first = header.getTFirstObs();
        if (!current.isBetweenOrEqualTo(first, last = header.getTLastObs())) {
            throw new OrekitIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_DATE, current, first, last);
        }
        this.observations.add(observationsDataSet);
    }

    public SampledClockModel extractClockModel(int nbInterpolationPoints) {
        ArrayList<ClockOffset> sample = new ArrayList<ClockOffset>();
        boolean someNonZero = false;
        AbsoluteDate previous = null;
        for (ObservationDataSet ods : this.observations) {
            if (previous == null || ods.getDate().durationFrom(previous) > 0.5 * ((RinexObservationHeader)this.getHeader()).getInterval()) {
                sample.add(new ClockOffset(ods.getDate(), ods.getRcvrClkOffset(), Double.NaN, Double.NaN));
                someNonZero |= ods.getRcvrClkOffset() != 0.0;
            }
            previous = ods.getDate();
        }
        return someNonZero ? new SampledClockModel(sample, nbInterpolationPoints) : null;
    }
}

