/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.observation;

import java.util.Collections;
import java.util.List;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.gnss.SatInSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class ObservationDataSet
implements TimeStamped {
    private final SatInSystem satellite;
    private final AbsoluteDate tObs;
    private final int eventFlag;
    private final List<ObservationData> observationData;
    private final double rcvrClkOffset;

    public ObservationDataSet(SatInSystem satellite, AbsoluteDate tObs, int eventFlag, double rcvrClkOffset, List<ObservationData> observationData) {
        this.satellite = satellite;
        this.tObs = tObs;
        this.eventFlag = eventFlag;
        this.observationData = observationData;
        this.rcvrClkOffset = rcvrClkOffset;
    }

    public SatInSystem getSatellite() {
        return this.satellite;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.tObs;
    }

    public int getEventFlag() {
        return this.eventFlag;
    }

    public List<ObservationData> getObservationData() {
        return Collections.unmodifiableList(this.observationData);
    }

    public double getRcvrClkOffset() {
        return this.rcvrClkOffset;
    }
}

